<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// manager for apps, blocks, filters, and templates
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
namespace SCHLIX;

trait cmsAdmin_CustomizablePluginInfo
{

    public function getCustomizableComponentInfo($block_name)
    {
        $component_dir = $this->managed_class_name;        
        $pdir = "{$component_dir}/{$block_name}";
        $at_system = false;
        $at_web = false;
        $at_theme = false;
        $original_classes = [];
            
        $c = get_system_or_user_file("{$pdir}/{$block_name}.class.php");        
        
            $og = null;
            $prefix = null;
            if (str_starts_with($c, SCHLIX_SYSTEM_PATH))
            {
                $at_system = true;
                $prefix = SCHLIX_SYSTEM_PATH;
                $relative_prefix = SCHLIX_SYSTEM_URL_PATH;
                $data = ['original_file' => $og, 'prefix' => $prefix, 'relative_prefix' => $relative_prefix ];
                
            }
            elseif (str_starts_with($c, CURRENT_THEME_PATH))
            {
                $at_theme = true;
                $prefix = CURRENT_THEME_PATH;
                $relative_prefix = CURRENT_THEME_URL_PATH;
                $data = ['original_file' => $og, 'prefix' => $prefix, 'relative_prefix' => $relative_prefix ];
                
            }
            elseif (str_starts_with($c, CURRENT_SUBSITE_PATH))
            {
                $at_web = true;
                $prefix = CURRENT_SUBSITE_PATH;
                $relative_prefix = CURRENT_SUBSITE_URL_PATH;
                $data = ['original_file' => $og, 'prefix' => $prefix, 'relative_prefix' => $relative_prefix ];
                
            }
            
            if ($prefix != null)
            {
                $og = remove_prefix_from_string($c, $prefix);
                $data = ['original_file' => $og, 'prefix' => $prefix, 'relative_prefix' => $relative_prefix ];
                $text = '';
                if ($at_system)
                    $text = sprintf(___('You can override the system file %s located in %s by copying it to %s.'), $data['original_file'], $data['relative_prefix'], CURRENT_SUBSITE_URL_PATH.$data['original_file']) ;
                elseif ($at_web) 
                {
                    if (file_exists(SCHLIX_SYSTEM_PATH.$og))
                        $text = sprintf(___('The file %s located in %s was copied from %s.'), $data['original_file'], $data['relative_prefix'], SCHLIX_SYSTEM_URL_PATH.$data['original_file']) ;
                    else
                        $text = ___('N/A') ;
                } else
                    $text = sprintf(___('The file %s located in %s'), $data['original_file'], $data['relative_prefix']) ;
                $data['text'] = $text;
                $original_classes = $data;
                
            } 
        
        $item_array = null;
        $view_dir =  null;
        if (is_dir(SCHLIX_SYSTEM_PATH.'/'.$pdir))
        {
            $view_dir = SCHLIX_SYSTEM_PATH;
            $item_array = get_list_of_view_files(SCHLIX_SYSTEM_PATH, $pdir, null);
        } else if (is_dir(CURRENT_SUBSITE_PATH.'/'.$pdir))
        {
            $view_dir = CURRENT_SUBSITE_PATH;
            $item_array =  get_list_of_view_files(SCHLIX_SYSTEM_PATH, $pdir, null);
        }
         return ['main_file' => $original_classes, 'view_files' => $item_array, 'view_dir' => $view_dir ];
        
    }    
}
class cmsAdmin_PluginsManager extends \SCHLIX\cmsAdmin_CategorizedList {

    /**
     *
     * @var string 
     */
    protected $managed_class_name;
    
    /**
     *
     * @var array 
     */
    protected $forbidden_names;
    //_________________________________________________________________________//
    public function __construct($managed_class_name, $forbidden_names = null) {
        parent::__construct('', null);
        $this->managed_class_name = $managed_class_name;
        $this->forbidden_names = $forbidden_names;
    }
    
    //_________________________________________________________________________//
    public function findInstalledItem($title) {
        global $SystemDB;

        $result = $SystemDB->getQueryResultArray( "SELECT * from {$this->table_items} WHERE (title = :title)", ['title' => $title]);
        return $result;
    }
    
    /**
     * Returns true if it's installed from the extension gallery
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param string $name
     * @return bool
     */
    public function isInstalledFromExtensionGallery($name)
    {
        global $SystemDB;
        
        $search =   str_replace('/','\\\\\/', '/'.$this->managed_class_name . '/' . $name . '/' . $name . '.class.php');
        //echo $search;die;
        $sanitized_search = "'%".sanitize_string($search, true)."%'";
        $sql = "SELECT id FROM gk_extmanager_items WHERE file_list LIKE {$sanitized_search}";
        //echo $sql;die;
        $existing_row = $SystemDB->getQueryResultSingleRow($sql);
        return $existing_row != null;
    }
    
    /**
     * Returns true if it's a system component
     * @param string $component
     * @return boolean
     */
    public function isSystem($component) {
        return file_exists(SCHLIX_SYSTEM_PATH . '/' . $this->managed_class_name . '/' . $component . '/' . $component . '.class.php');
    }

    //_________________________________________________________________________//
    public function installItem($filename) {
        global $SystemDB;

        $datavalues['title'] = $filename;
        $SystemDB->simpleInsertInto($this->table_items, $datavalues);                            
        // Child classes (app, blocks, filters, templates) install inherit here
    }

    //_________________________________________________________________________//
    public function installItemFromUploadedFile() {
        // TODO: install from a ZIP file
    }

    //_________________________________________________________________________//
    public function cleanUpOrphanedItems($items_from_directory) {
        global $SystemDB;

        $total_count = ___c($items_from_directory);
        for ($i = 0; $i < $total_count; $i++)
            $items_from_directory[$i] = sanitize_string($items_from_directory[$i]);
        $existing_apps = implode(',', $items_from_directory);
        $sql = "DELETE FROM `{$this->table_items}` WHERE title NOT IN ({$existing_apps})";
        $SystemDB->query($sql);
    }

    //_________________________________________________________________________//
    protected function __checkFolder($items) {
        $forbidden_listing = (is_array($this->forbidden_names)) ? $this->forbidden_names : [];

        $item_array = [];
        if ($items)
        {
            foreach ($items as $item) {
                $file = $item->getFileName();
                if ((!in_array($file, $forbidden_listing)) && (strpos($file, 'uninstalled_') === false ))
                    $item_array[] = $file;
            }
        }

        return $item_array;
    }

    //_________________________________________________________________________//
    public function checkForUnregisteredItems() {
        /* TODO: FIX THIS - NOT URGENT, JUST EFFICIENCY ISSUE */
        //TODO: fix - May 26, 2016

        $items = cmsDirectoryFilter::getDirectoryIterator(SCHLIX_SYSTEM_PATH . '/' . $this->managed_class_name . '/', cmsDirectoryFilter::FILTER_DIR_ONLY);
        $user_items = cmsDirectoryFilter::getDirectoryIterator(SCHLIX_SITE_PATH . '/' . $this->managed_class_name . '/', cmsDirectoryFilter::FILTER_DIR_ONLY);
        $item_array = $this->__checkFolder($items);
        $user_item_array = $this->__checkFolder($user_items);

        if (is_array($user_item_array))
            $item_array = array_merge($item_array, $user_item_array);

        if ($item_array) {
            $this->cleanUpOrphanedItems($item_array); // delete non-existant apps from db
            foreach ($item_array as $item) {
                $dups = $this->findInstalledItem($item);
                if (___c($dups) == 0)
                    $this->installItem($item);
            }
        }
    }

    //_________________________________________________________________________//
    public function saveItem($id) {
        return parent::saveItem($id);
    }

    //_________________________________________________________________________//
    public function Install() {
        global $CurrentUser;
        //TODO: error checking and validation
        //include_inc('pclzip/pclzip.class.php');
        // Set the available backend directories, e.g.: apps, blocks, filters, libs, themes, etc
        $backend_dirs = array('themes', 'apps', 'blocks', 'macros', 'libs', 'wysiwygeditors');
        $zipfile = $_FILES['zipfileupload'];


        $errorstr = '';
        $password = fpost_string('password');
        if (empty($password))
            return ajax_reply(401, ___('Please type your password to authenticate'));
        else 
        {
            $password_ok = $CurrentUser->verifyUserNamePassword($CurrentUser->getCurrentUserName(), $password);
            if (!$password_ok)
                return ajax_reply(401, ___('Invalid password'));
        }

        if (is_array($zipfile)) {
            if ($zipfile['error'] == 0 && $zipfile['size'] > 0) {
                $zip = new \PclZip($zipfile['tmp_name']);
            } else {
                return ajax_reply(401, ___('An error occured while trying to unzip the uploaded archive'));
            }
        } else {
            return ajax_reply(401, ___('No file uploaded'));
        }

        //$zip = new \PclZip($file_to_open);
        // 1. Determine the app name
        if (($list = $zip->listContent()) == 0) {
            //displayMessageBox("Error : " . $zip->errorInfo(true));
            return ajax_reply(401, $zip->errorInfo(true));
        }

        $array_app_name = [];
        $array_directories = [];
        $count = sizeof($list);
        for ($i = 0; $i < $count; $i++) {
            if ($list[$i]['folder'] == true) {
                $filename = $list[$i]['filename'];
                $dirnamestack = explode('/', $filename);
                $array_directories[] = $filename;
                $app_name = $dirnamestack[0];
                $array_app_name[$app_name] ++;
            }
        }
        $maxcount = max($array_app_name);
        $the_app_name = array_search($maxcount, $array_app_name);
        // 2. Determine if all directory structure is correct  - TODO: fix inefficient detection
        $is_valid = false;
        // 3. Extract
        // 4. Move directories to destination
        foreach ($backend_dirs as $backend_dir) {
            /* if ($valid_pkg[$prefix]) {
              //echo $prefix.BR();

              if ($zip->extract(PCLZIP_OPT_PATH, $targetpath, PCLZIP_OPT_BY_NAME, $the_app_name . "/{$prefix}_files/", PCLZIP_OPT_REMOVE_PATH, $the_app_name . "/{$prefix}_files/") == 0)
              $errorstr = $zip->errorInfo(true);

              } */
            $targetpath = SCHLIX_SITE_PATH . '/' . $backend_dir . '/';
            $str_file = $the_app_name . '/' . $backend_dir . '/' . $the_app_name . '/';
            if (in_array($str_file, $array_directories)) {
                $target_dest1 = $the_app_name . '/' . $backend_dir . '/';
                $target_dest2 = $target_dest1;
                if ($zip->extract(PCLZIP_OPT_PATH, $targetpath, PCLZIP_OPT_BY_NAME, $target_dest1, PCLZIP_OPT_REMOVE_PATH, $target_dest2) == 0)
                    $errorstr = $zip->errorInfo(true);
                $is_valid = true;
            }
        }
        if ($is_valid) {
            if (empty($errorstr)) {
                return ajax_reply(200, 'OK');
            } else {
                return ajax_reply('201', ___('Some errors occured :') . $errorstr);
            }
        } else {
            return ajax_reply(401, ___('The uploaded ZIP file either does not contain a valid SCHLIX CMS extension package or the extension name is invalid'));
        }
    }

    //_________________________________________________________________________//
    public function Upgrade() {
        return false;
    }

//_________________________________________________________________________//
    /*public function processUninstall($name) {
        if ($this->isSystem($name))
            return false;

        if (fpost_bool('sure')) {
            $item_path = SCHLIX_SITE_PATH . '/' . $this->app_name . '/' . $name;
            $item_path_newname = SCHLIX_SITE_PATH . '/' . $this->app_name . '/uninstalled_' . $name;
            // April 10, 2010
            $result2 = rename($item_path, $item_path_newname);
            if (fpost_bool('everything')) {
                __del_tree($item_path_newname);
            }
            return ( $result2);
        }
        return false;
    }*/
    
    public function extensionExists($name)
    {
        die ('extensionExists not implemented');
    }
    


    public function getIconURL($name)
    {
        $file = '/' . $this->managed_class_name . '/' . $name . '/' . $name . '_logo.png';
        if (file_exists(CURRENT_SUBSITE_PATH . $file))
        {
            return CURRENT_SUBSITE_URL_PATH.$file;
        }
        return null;

    }    
    
    /**
     * 
     * @global \App\Users $CurrentUser
     * @return array
     */
    public function ajxp_ConfirmUninstall()
    {
        global $CurrentUser;
        
        $error_list = [];
        check_csrf_halt_on_error();
        $name = fpost_alphanumeric('name', 63);
        
        // 1. validate app exists
        if (!$this->extensionExists($name))
            $error_list[] = ___('Invalid name');
        elseif ($this->isSystem($name))
            $error_list[] = ___('System extension cannot be removed');
        elseif ($this->isInstalledFromExtensionGallery($name))
            $error_list[] = ___('Please remove this extension from the Extension Gallery Manager');
        // 2. validate password
        if (empty($error_list))
        {
            $password = fpost_string('password');
            if (empty($password))
                $error_list[] = ___('Please type your password to authenticate');
            else 
            {
                $password_ok = $CurrentUser->verifyUserNamePassword($CurrentUser->getCurrentUserName(), $password);
                if (!$password_ok)
                    $error_list[] = ___('Invalid password');
            }
        }
        $reply['messages'] = $error_list;
        $status = empty($error_list);
        if ($status)
        {
            $item_path = CURRENT_SUBSITE_PATH .  '/' . $this->managed_class_name . '/'  . $name;
            __del_tree($item_path);
            $this->deleteExtensionByName($name);
            $reply['messages'] = [___('Uninstall completed')];
            $reply['hide_form'] = true;
        }
        return ajax_reply($status, $reply);
    }
    

    protected function deleteExtensionByName($name)
    {
        global $SystemDB;
        
        $SystemDB->query( "DELETE FROM `{$this->table_items}` WHERE title = :title", ['title' => $name]);
    }
    //_________________________________________________________________________//
    public function Uninstall() {
        global $SystemDB;

        $this->setPageTitle(___('Uninstall'));
        //$title = fget_alphanumeric('name');
        /*if (fpost_int('cancel_uninstall') === 1) {
            $this->returnToMainAdminApplication();
            return;
        }
        if ($this->findInstalledItem($title)) {
            if (fpost_bool('sure')) {
                $uninstall_result = $this->processUninstall($title);
            }
            if ($uninstall_result) {
                $sql = "DELETE FROM `{$this->table_items}` WHERE title = '{$title}'";
                $SystemDB->query($sql);
            }
        } else {
            $error_title = sprintf(___('%s is not a valid installed item'), $title);
            $error_description = ___('Cannot proceed with uninstall process');
        }
        */        
        $this->loadTemplateFile('uninstall', compact(array_keys(get_defined_vars())));
    }

    //_________________________________________________________________________//
    public function Run() {
        switch (fget_alphanumeric('action')) {
            case 'install': 
                return ajax_echo($this->Install());
                break;
            case 'upgrade': $this->Upgrade();
                return true;
                break;
            case 'uninstall': $this->Uninstall();
                return true;
                break;
            default:return parent::Run();
        }
    }

}
