<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
define ('JS_PATH', str_replace('\\','/',dirname(__FILE__)).'/');
error_reporting(E_ERROR | E_CORE_ERROR | E_COMPILE_ERROR  | E_PARSE);

$filename = preg_replace("/[^a-z-.\/_\d]/i", "", $_GET['js']); // sanitize, prevent path traversal
$filename = str_replace('..','', $filename); // further sanitize
$etag = sprintf('sch%u',crc32($filename));
header("Content-type: text/javascript; charset: UTF-8");
if(isset($_SERVER['HTTP_IF_MODIFIED_SINCE']) || isset($_SERVER['HTTP_IF_NONE_MATCH']))
{
	if ($_SERVER['HTTP_IF_MODIFIED_SINCE'] || str_replace('"', '', stripslashes($_SERVER['HTTP_IF_NONE_MATCH'])) == $etag)
	{
		header('HTTP/1.1 304 Not Modified');
		exit();
	}
} else
if (file_exists (JS_PATH.$filename.'.js.gz'))
{
	header("Vary: Accept-Encoding");
	header("Cache-Control: public, max-age=".(24));
        header("Content-Type: text/javascript; charset: UTF-8;charset=UTF-8");
        header("Content-Encoding: gzip");        
	header("Pragma: public");
        header('Expires: '.gmdate('D, d M Y H:i:s \G\M\T', time() + (24 * 3600))); // 1 day	
	header("ETag: \"{$etag}\"");
	readfile(JS_PATH.$filename.'.js.gz');
} else
{
    $filename = JS_PATH.$filename.'.js.gz';
	echo ("alert('{$filename} could not be loaded');");
}