<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION'))
    die();

global $HTMLHeader;

// from public function viewPasswordResetPage($id, $hash)
$s_hash = ___h($hash);
$s_id = ___h($id);
?>
<h1 class="title"><i class="fa fa-user"></i> <?= ___('Password Reset') ?></h1>
<hr />

<x-ui:row>
    <!-- col -->
    <?php if (empty($error_list)): ?>
        <x-ui:form-simple-ajax name="form-user-reset-password" id="form-user-reset-password" method="post" data-action="<?= $this->createFriendlyURL("action=userforgotpasswordreset&hash={$s_hash}&xt={$s_id}") ?>" enctype="multipart/form-data" >
            <x-ui:csrf />
            <x-ui:hidden name="<?= $s_hash ?>" />
            <x-ui:hidden name="<?= $s_id ?>" />

            <x-ui:column sm="6" md="4">

                <x-ui:panel type="panel-default">
                    <x-ui:panel-header>
                        <strong> <?= ___('Enter a new password') ?></strong>
                    </x-ui:panel-header>
                    <x-ui:panel-body>

                                <x-ui:form-group>

                                    <x-ui:input-group>
                                        <x-ui:input-addon>
                                            <i class="fa fa-lock"></i>
                                        </x-ui:input-addon>                                    
                                        <x-ui:password name="password" id="password" required="required" placeholder="<?= ___('Password') ?>" pattern=".{7,70}" value="" />

                                        <x-ui:password name="password_verify" id="password_verify" required="required"   placeholder="<?= ___('Password') ?>" value="" />
                                    </x-ui:input-group>
                                </x-ui:form-group>
                                <?php if ($this->getConfig('bool_enable_captcha_reset_password')): ?>
                                    <x-ui:captcha id="verification_code" name="verification_code" />
                                <?php endif ?>
                                <x-ui:button button-type="ok"  type="submit" name="submit" id="btn-reset-password" data-form-submit="1"  value="Submit" label="<?= ___('Reset Password') ?>" fonticon="fas fa-unlock" block="1" size="large" />
                    </x-ui:panel-body>
                </x-ui:panel>

            </x-ui:column>
        </x-ui:form-simple-ajax> 

    <?php endif ?>

    <!-- col -->
    <x-ui:column sm="6" md="8">
        <!-- output for ajax message -->
        <div class="schlix-ajax-output"></div>
        <!-- end output -->

        <?php if (___c($error_list) > 0): ?>
            <x-ui:alert type="error" var="error_list" fonticon="fa fa-times" />
        <?php endif; ?>            
        <!-- content -->
        <x-ui:echo-safe-config-value key="str_password_reset_text" />
    </x-ui:column>
</x-ui:row>


