<?php
/**
 * Users - Main admin view template
 * 
 * @copyright (C)  SCHLIX Web Inc
 *
 * @license GPLv3
 *

 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die('No Access');
?>
<?php $app = $this->app_name; ?>
<x-ui:schlix-explorer-sub-application-header />

<x-ui:schlix-user-explorer id="schlix-<?= $this->app->getApplicationNameOnly() ?>-admin" class="schlix-data-explorer"  data-schlix-controller="SCHLIX.CMS.UsersAdmin" data-main-app-description="<?= $this->app->getApplicationDescription() ?>" data-app="<?= $this->app->getApplicationNameOnly() ?>" data-model="<?= $this->getDataModelURL() ?>" 
                           data-field-category_title="groupname"
                           data-field-item_title="username" >
    <x-ui:schlix-explorer-toolbar>
        <x-ui:schlix-explorer-toolbar-menu data-position="left">    
            <x-ui:schlix-explorer-menu-command data-schlix-command="new-item" data-schlix-app-action="newitem"   fonticon="fa fa-user-plus text-blue" label="<?= ___('New User') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="new-category" data-schlix-app-action="newcategory" fonticon="fas fa-folder-plus text-orange" label="<?= ___('New Group') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="edit-current-category" data-schlix-app-action="editcategory" require-category="1" fonticon="fas fa-pencil-alt text-orange" label="<?= ___('Edit Current Category') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="cut" require-selected-items="1" fonticon="fa fa-cut" label="<?= ___('Cut') ?>" />
            <?php /*             * Copy user is disabled because email must be uniqu */ ?>                
            <x-ui:schlix-explorer-menu-command data-schlix-command="paste" require-clipboard-items="1" fonticon="far fa-clipboard" label="<?= ___('Paste') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="delete" require-selected-items="1" fonticon="far fa-trash-alt" label="<?= ___('Delete') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="config" data-schlix-app-action="editconfig"  fonticon="fas fa-cog text-slategray" label="<?= ___('Configuration') ?>" />
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
        </x-ui:schlix-explorer-toolbar-menu>
        <x-ui:schlix-explorer-toolbar-search />
        <x-ui:schlix-explorer-toolbar-menu data-position="right">
            <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
            </x-ui:schlix-explorer-menu-folder>
        </x-ui:schlix-explorer-toolbar-menu>


    </x-ui:schlix-explorer-toolbar>

    <schlix-data-breadcrumb schlix-id="breadcrumb"></schlix-data-breadcrumb>


    <!-- breadcrumb -->
    <x-ui:schlix-explorer-breadcrumb />        
    <!-- data viewer -->        
    <x-ui:schlix-explorer-row>
        <!-- Left Column -->
        <x-ui:schlix-explorer-left-column>
            <!-- treeview -->
            <x-ui:schlix-treeview schlix-id="datanav-tree" data-dynamic="true" ></x-ui:schlix-treeview>
            <!-- end column -->
        </x-ui:schlix-explorer-left-column>
        <!-- Right Column -->
        <x-ui:schlix-explorer-right-column>
            <!-- datatable -->
            <x-ui:schlix-data-table schlix-id="datanav-datatable" data-default-sort-by="username" data-default-sort-direction="asc">
                <x-ui:schlix-data-table-columns>

                    <schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="this.formatDataTableCell_CheckBox" sortable="false" />
                    <schlix-data-table-column key="this.field_item_title" sortable="true" label="<?= ___('Username') ?>" formatter="this.formatUserName" />
                    <schlix-data-table-column key="email_address" sortable="true" label="<?= ___('Email') ?>" formatter="text" />
                    <schlix-data-table-column key="this.field_id" hidden="true" sortable="false" formatter="number" />
                    <schlix-data-table-column key="status" label="<?= ___('Status') ?>" sortable="true" formatter="this.formatDataTableCell_Status" />

                    <schlix-data-table-column key="date_last_logged_in" label="<?= ___('Last Login') ?>" sortable="true" formatter="this.formatDataTableCell_Date" />
                    <schlix-data-table-column key="last_ip_address" label="<?= ___('Last IP Address') ?>" sortable="true" formatter="text"  />
                </x-ui:schlix-data-table-columns>
            </x-ui:schlix-data-table>
            <!-- pagination -->
            <x-ui:schlix-explorer-pagination />
            <!-- end column -->
        </x-ui:schlix-explorer-right-column>
    </x-ui:schlix-explorer-row> 

</x-ui:schlix-user-explorer>
