<?php
/**
 * Tag - Category view template
 * 
 * Tag Manager
 * 
 * @copyright 2016 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();
?>
<?php 
    $field_cid = $this->getFieldCategoryID();
    $field_id = $this->getFieldID();
    $current_category_id = $category[$field_cid];        
    $cached_app = []; // cached object to reduce reinitialization for each different obj entries
?>
<div class="app-page-category app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-category-<?= $category[$field_cid]; ?>" >   
    <?= isset($category['macro_processed_text_outside_article_top']) ? $category['macro_processed_text_outside_article_top'] : null ?>    
    <!-- ########################################################################### -->
    <!-- ####################### main info of this category  ####################### -->
    <!-- ########################################################################### -->
    <article class="main category">
	<?php if ($category_meta_options['display_pagetitle']): ?>
            <h1 class="category title"><?= ___h($category['title']); ?></h1>
        <?php endif; ?>
        <?php if ($category['macro_processed_text_before_article']): ?>        
        <!-- Macro - Pre -->            
            <div class="meta before-article">        
            <?= $category['macro_processed_text_before_article'] ?>            
            </div>
        <!-- End Macro - Pre -->        
        <?php endif ?>
        <div class="text">
            <?= $category['summary'].$category['description'] ?>
        </div>
        <?php if (isset($category['macro_processed_text_after_article'])): ?>
        <!-- Macro - Post -->                
            <div class="meta after-article">
                <?= $category['macro_processed_text_after_article'] ?>
            </div>
        <?php endif ?>
        <!-- End Macro - Post -->                
    </article>
    <!-- ########################################################################### -->
    <!-- ######################## end info of this category  ####################### -->
    <!-- ########################################################################### -->

    <?php if ($items):  ?>
    <!-- ########################################################################### -->
    <!-- ########################## child items #################################### -->
    <!-- ########################################################################### -->
       <div class="category child items">
            <?php foreach ($items as $child_item): ?>
                <section class="child-item">    
                    <?php 
                        $child_item_app = '\\App\\'.$child_item['application'];
                        if ($cached_app[$child_item['application']])
                        {
                            $child_app_obj = $cached_app[$child_item['application']];
                        } else
                        {
                            $child_app_obj = new $child_item_app();
                            $cached_app[$child_item['application']] = $child_app_obj;
                        }
                        
                        
                        if ($child_app_obj): ?>                        
                            <?php $child_item_object = $child_app_obj->getAnyObjectByGUID($child_item['guid']); ?>
                            <?php if ($child_item_object): ?>
                            <?php
                               /* $field_id = $child_app_obj->getFieldID();
                                $field_category_id = $child_app_obj->getFieldCategoryID();
                                $item_link = $child_item_object['__type__'] == 'item' ? 
                                    $child_app_obj->createFriendlyURL("action=viewitem&id={$child_item_object[$field_id]}") :
                                    $child_app_obj->createFriendlyURL("action=viewcategory&id={$child_item_object[$field_category_id]}");*/
                                    $item_link = $child_app_obj->createFriendlyURL($child_item['internalurl']);
                             ?>
                            <h2><a href="<?= $item_link ?>"><?= ___h($child_item_object['title']) ?></a></h2>                          
                            <?php if ($child_item_object['date_created'] && ($child_item_object['date_created'] != NULL_DATE)): ?>
                                <div class="tag-article-date">
                                    <i class="far fa-clock"></i> <?= $child_item_object['date_created'] ?>                                    
                                </div>
                            <?php endif ?>                            
                            <?php if ($child_item_object['summary']): ?>
                                <?= ($child_item_object['summary']) ?>
                            <?php endif ?>
                            <hr />
                            <?php endif ?>
                    <?php endif ?>
                    
                    
                </section>
            <?php endforeach ?>       
        </div>     
    <!-- ########################################################################### -->
    <!-- ####################### end child items ################################### -->
    <!-- ########################################################################### -->
    <?php endif; ?>
    <!-- pagination -->
    <?php $pagination_str = $this->displayItemPagination($pg,$pagination['total'],"action=viewcategory&cid={$current_category_id}"); ?>
    <?php if ($pagination_str &&  $category_meta_options['display_items']): ?>
        <div class="pagination"><?= $pagination_str; ?></div>
    <?php endif?>
    <!-- end pagination -->
    <?= $category['macro_processed_text_outside_article_bottom'] ?>
</div>