//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

/**
 * View Controller class
 */
SCHLIX.CMS.SitemapAdmin = class extends SCHLIX.CMS.BaseController  {  
    /**
     * Constructor
     */
    constructor ()
    {
        super("simplesitemap");
    };

    onSitemapUpdated (o)
    {
        var response = ajax_parse(o.responseText);
        if (response.status === 'OK')
        {
            SCHLIX.Dom.get('txt_cached_sitemap').innerHTML = response.content;
            SCHLIX.Alert.info('XML Sitemap updated');            
        }
        else
            SCHLIX.Alert.error(response);
        
    };
    
    regenerateSitemap (e)
    {
        var postData = "_csrftoken=" + _csrftoken + '&regen=1';
            
        var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/" + this.app_name + "?action=regeneratesitemap",
                {success: this.onSitemapUpdated, failure: this.handleFailure, scope: this}, postData);
    };
    
    onDOMReady()
    {
        SCHLIX.Event.on('btn-regenerate-sitemap','click',this.regenerateSitemap, this, true);
    }
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'config':
                this.redirectToCMSCommand("editconfig");
                return true;
                break;
            default:
                return super.runCommand(command, evt);
                break;
        }
    }
}; 