<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
$app_list = $this->getListofApplications('apps');
$forbidden_apps = ['core','admin','search','sitemanager','personaldatarequest','users','landing','tag'];
?>
<?php global $SystemConfig, $CurrentUser; ?>

<schlix-config:data-editor   data-schlix-controller="SCHLIX.CMS.SitemapAdmin">

        <schlix-config:save-result />
        <x-ui:schlix-editor-form id="form-edit-config" method="post" data-config-action="save" action="<?= $this->createFriendlyAdminURL('action=saveconfig') ?>" autocomplete="off">

            <schlix-config:action-buttons />
            <x-ui:csrf />

            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_general" fonticon="far fa-file" label="<?= ___('General') ?>"> 
                        <!--config -->
                        <schlix-config:app_alias   config-default-value="<?= strtolower($this->schlix_master_class) ?>" />
                        <schlix-config:app_description   />
                        <schlix-config:checkboxgroup config-key="array_enabled_apps" label="<?=  ___('Enable for the following applications') ?>">
                            <?php foreach ($app_list as $enabled_app): ?>
                            <?php if (!in_array($enabled_app['value'], $forbidden_apps)): ?>
                                <schlix-config:option value='<?= $enabled_app['value'] ?>'><?= $enabled_app['label'] ?></schlix-config:option>
                            <?php endif ?>
                            <?php endforeach ?>
                        </schlix-config:checkboxgroup>
                        
                        <!-- end config -->

                </x-ui:schlix-tab>
                <!-- tab -->
                <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditConfigTab', $this) ?>           
                <!-- end -->
            </x-ui:schlix-tab-container>
            
        </x-ui:schlix-editor-form>
</schlix-config:data-editor>     
