<?php
/**
 * Personal Data Request - Main page template. Lists all items. 
 * 
 * Plugin for compliance with GDPR
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package personaldatarequest
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');

 $str_mainpage_title =  $this->getConfig('str_mainpage_title') ? $this->getConfig('str_mainpage_title') : $this->getApplicationDescription();
$str_mainpage_text =  $this->getConfig('str_mainpage_text');
 // OPTIONAL - feel free to uncomment
 // $this->processDataOutputWithMacro($str_mainpage_text, 'viewMainPage');
$show_captcha = $this->getConfig('bool_enable_captcha_confirm');
$request_guid = $command['guid'];
?>
<div class="app-page-main app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-main">
    <h1 class="main title"><?= ___h($str_mainpage_title) ?></h1>
    
    <x-ui:row>
        <x-ui:column sm="4">
            <div class="schlix-ajax-output"></div>
        <x-ui:form-simple-ajax name="form_personal_data_request"  method="post" data-action="<?= $this->createFriendlyURL("action=confirmrequest"); ?>" enctype="multipart/form-data" >
            <x-ui:csrf />
            <x-ui:hidden name="guid" data-var="request_guid" />

            <x-ui:form-group>
                <x-ui:textbox type="auth_code" name="auth_code" id="auth_code" autofocus="autofocus" required="required" label="<?= ___('Auth Code') ?>"  placeholder="<?= ___('Auth Code') ?>" />
            </x-ui:form-group>
         
            <?php if ($show_captcha): ?>
            <x-ui:captcha id="verification_code" name="verification_code" required="required" title="<?= ___('Please enter a valid captcha') ?>" value="" />
            <?php endif; ?>

            <x-ui:button button-type="ok"  type="submit" name="submit" data-form-submit="1" id="btn-request" value="Submit" label="<?= ___('Confirm Request') ?>" fonticon="fas fa-sign-in-alt" block="1" size="large" />
        </x-ui:form-simple-ajax>
        </x-ui:column>

        <x-ui:column sm="8">
                <?= $str_mainpage_text ?>
        </x-ui:column>

    </x-ui:row>
      
</div>