/**
 * Personal Data Request - Javascript admin controller class
 * 
 * Plugin for compliance with GDPR 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package personaldatarequest
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class SCHLIX_GDPR
{
    constructor()
    {
        SCHLIX.Event.onDOMReady(this.onDOMReady, this, true);
    };

    onDOMReady()
    {
        this.setReasonBoxVisibility(false);
        SCHLIX.Event.on('{.gdpr_opts}','click', this.onGDPROptionClicked, this, true);
        
    };
    
    onGDPROptionClicked(e)
    {
        var target = SCHLIX.Event.getTarget(e);
        var visible = (parseInt(target.value, 10) === 2);
        this.setReasonBoxVisibility(visible);
    };
    
    setReasonBoxVisibility(visible)
    {
        var reason_box = SCHLIX.Dom.get('reason');
        if (reason_box)
        {
            reason_box.style.display = visible ? '' : 'none';
        }
    }
};

var gdpr = new SCHLIX_GDPR();