/**
 * View Controller class
 */
SCHLIX.CMS.HtmlAdmin = class extends SCHLIX.CMS.BaseController  {  
    /**
     * Constructor
     */
    constructor ()
    {
        super("html");
    };
    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    static formatDataTableCell_DefaultTitleColumn  (elCell, oRecord, oColumn, oData) {

        var field_title = SCHLIX.Util.isUndefined(this.parentControl.element_data["field-item_title"]) ? "title" : this.parentControl.element_data["field-item_title"];
        var odata_id = oRecord.getData("id");
        var odata_cid = oRecord.getData("cid");
        var itemTitle = oRecord.getData(field_title); // oRecord.getData("title");
        var itemLink = site_httpbase;
        if (itemTitle == null)
        {
            console.warn("formatDataTableCell_DefaultTitleColumn cannot process a null title", 'warn');
            return;
        }
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';
        var app_name = this.parentControl.app_name;
        if (odata_cid > 0)
        {
            SCHLIX.CMS.__default_formatFolderInDataTable(app_name, elCell, oRecord, itemTitle, site_httpbase + this.parentControl.schlix_application_url + 'action=editcategory&id=' + odata_cid);
        } else
        {
            // console.log(oRecord);
            var the_id = oRecord.getData("id");
            var theValue = 'i' + the_id;
            if (itemTitle === '')
                itemTitle = '(Untitled)';
            var icon = ___$HTML.I('', {'class' : 'far fa-file-alt fa-2x'});              

            itemLink = oRecord.getData("edit_link"); //this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
            var item_class = (oRecord.getData('id')==1 || oRecord.getData('virtual_filename') == 'home') ? 'html_home' : 'dragdrop';
            var preview_link = oRecord.getData("preview_link");
            var display_preview_link = '';
            if (SCHLIX.Util.isString(preview_link))
            {
                var preview_icon = ___$HTML.I('', {'class' : 'fas fa-eye text-purple'});  
                display_preview_link = 
                        ___$HTML.DIV_start({'class' : 'schlix-cms-data-explorer-dt-right-icon'}) + 
                        ___$HTML.A(preview_icon, preview_link, {'target': '_blank'}) + 
                        ___$HTML.DIV_end();                
            }
            if (itemTitle)
                itemTitle = SCHLIX.Util.escapeHTML(itemTitle);
            var lnk_attrs = {
                'class': item_class, 
                'id' : app_name + "-lnk-" + theValue,
                'data-dragdrop-id' : theValue,
                'title' : 'Click here to edit this item'
                
            };
            elCell.innerHTML = ___$HTML.A(icon + " " + itemTitle, itemLink, lnk_attrs) + display_preview_link;
        }
    };
    
    
    static formatDataTableCell_CheckBox (elCell, oRecord, oColumn, oData) {
            if (oRecord.getData('id')==1 || oRecord.getData('virtual_filename') == 'home')
                    elCell.innerHTML = '<i class="fa fa-2x fa-home"></i>';
            else
            {
                var theID = '';
                var theValue = '';

                var app_name = this.parentControl.app_name;
                if (oRecord.getData("cid") > 0)
                {
                    theID = app_name + '-select-cid' + oRecord.getData("cid");
                    theValue = 'c' + oRecord.getData("cid");
                }
                else
                {
                    theID = app_name + '-select-id' + oRecord.getData("id");
                    theValue = 'i' + oRecord.getData("id");
                }

                elCell.innerHTML = '<input type="checkbox" class="' + app_name + '-chkselections" name="' + app_name + '-chkselections[]" id="' + theID + '"  value="' + theValue + '" />';

            }
    }; 
    runCommand (command, evt)
    {
        //if (evt.type == 'contextmenu')
        var open_in_new_window = is_rightclick_event(evt);
        switch (command)
        {
            case 'new-item':
                this.redirectToCMSCommand("newitem",open_in_new_window);
                return true;
                break;
            case 'new-category':
                this.redirectToCMSCommand("newcategory",open_in_new_window);
                return true;
                break;
            case 'edit-current-category':
                var target = evt.target;                
                window.location = target.href;
                return true;
                break;         
            case 'config':
                this.redirectToCMSCommand("editconfig",open_in_new_window);
                return true;
                break;
            default:
                return super.runCommand(command, evt);
                break;
        }
    }
};
