<?php
namespace App;

/**
 * Core: Versioning - Admin class
 * 
 * Core - Versioning
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_Versioning_Admin extends \SCHLIX\cmsAdmin_List {
    /**
     *
     * @var Core_Versioning 
     */
    protected $app;
    /**
     * Constructor
     */

//_________________________________________________________________________//
    public function __construct()
    {
        // Data: Item
        parent::__construct(true, []);
        $this->setItemFieldNamesForAjaxListing('id', 'guid', 'date_created', 'version', 'app_name', 'created_by_id');
        \SCHLIX\cmsHooks::register($this);
    }

    public function ajaxGetItemVersions($app, $guid, $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC')
    {
        global $SystemDB;
        global $CurrentUser;

        $tmp_user_table = [];

        if ((int) $start > (int) $end)
            return ajax_reply(400, 'Invalid Request');
        $sortby = $SystemDB->escapeString($sortby);
        $items_per_page = min(HARDCODE_MAX_ROWLIMIT, $end - $start);
        $fields = implode(',', quote_array_of_field_names_for_query($this->getItemFieldNamesForAjaxListing()));
        $sanitized_appname = sanitize_string($app);
        $sanitized_guid = sanitize_string($guid);

        $criteria = "app_name = {$sanitized_appname} AND guid = {$sanitized_guid}";
        $total_item_count = $this->app->getTotalItemCount($criteria);

        $result_array_files = $this->app->getAllItems($fields, $criteria, $start, $end, $sortby, $sortdirection, false);
        $count = ___c($result_array_files);
        for ($i = 0; $i < $count; $i++)
        {
            $user_id = $result_array_files[$i]['created_by_id'];
            $username = $CurrentUser->getUserNameByID($user_id);
            $result_array_files[$i]['created_by_username'] = $username;
        }
        return ajax_datasource_reply(200, $result_array_files, $start, $end, $items_per_page, $total_item_count, $sortby, $sortdirection);
    }
            

    //_________________________________________________________________________//
    public function ajaxViewItemByVersion($app_name, $guid, $version)
    {
        global $Versioning;

        $version = $version;
        $item = $Versioning->getItemArchiveByVersion($app_name, $guid, $version);
        $content = '';
        if ($item) {
            $keys = array_keys($item);
            $content = \__HTML::TABLE_start(array('class' => 'versioning'));
            foreach ($keys as $key)
            {
                if (is_serialized($item[$key])) {
                    $key_content = @unserialize($item[$key]);
                    if (is_array($key_content)) {
                        $tmp_content = var_export($key_content, true);
                        $key_content = $tmp_content;
                    }
                }
                else {
                    $key_content = $item[$key];
                }
                $content.= \__HTML::TR_start();
                $content.= \__HTML::TD_start() . $key . \__HTML::TD_end();
                $content.= \__HTML::TD_start() . $key_content . \__HTML::TD_end();
                $content.= \__HTML::TR_end();
            }
            $content.=\__HTML::TABLE_end();
        }
        else {
            $content = ___('This item could not be found');
        }
        return ajax_reply(200, $content);
    }
    
    private function loadHookTemplateFile($obj, $type, $datavalues)
    {
        if ($obj instanceof \SCHLIX\cmsAdmin_List)
        {
            $frontendapp = $obj->frontendApp();
            if ($frontendapp->hasVersioning())
            {
                $load = ($type === 'category') ? ($obj instanceof \SCHLIX\cmsAdmin_CategorizedList) && $frontendapp->categoryColumnExists('version') && $frontendapp->categoryColumnExists('guid')  : $frontendapp->itemColumnExists('version') && $frontendapp->itemColumnExists('guid');
                if ($load)
                    $this->loadNativeTemplateFile('versioning.hook', null, true);
            }
        }     
    }
    //_________________________________________________________________________//
    public function hook_getApplicationAdminExtraEditCategoryTab($obj, $category)
    {
        $this->loadHookTemplateFile($obj, 'category', $category);
    }
    //_________________________________________________________________________//
    public function hook_getApplicationAdminExtraEditItemTab($obj, $item)
    {
        $this->loadHookTemplateFile($obj, 'item', $item);
    }
    
    //_________________________________________________________________________//
    /**
     * Deprecated, replaced with viewApplicationVersioning. Backward compatibility until end of 2021
     * @deprecated since version 2.2.0
     * @param string $app_name
     * @param string $guid
     */
    public static function displayVersioningGrid($app_name, $guid)
    {
        $filename = SCHLIX_SYSTEM_PATH . "/apps/versioning/versioning_per_app.template.php";
        if (file_exists($filename)) {
            $app = new versioning_Admin();
            $app->loadApplicationJavascript();
            include_once ($filename);
        }
        else
            echo (___('Missing template'));        
    }
    
    //_________________________________________________________________________//
    public function viewApplicationVersioning($app_name, $guid)
    {
        /*$filename = SCHLIX_SYSTEM_PATH . "/apps/versioning/versioning_per_app.template.php";
        if (file_exists($filename)) {
            $app = new versioning_Admin();
            //$app->loadApplicationJavascript();
            
            include_once ($filename);
        }
        else
            echo (___('Missing template'));*/
        $local_variables = compact(array_keys(get_defined_vars()));
        $this->loadTemplateFile('versioning_per_app', $local_variables);
    }
    
    

    public function ajaxRestoreArchive()
    {
        $id = fpost_int('id');
        $version = fpost_double('version');
        $itemtype = fpost_string('type',10);
        check_csrf_halt_on_error();
        $appname = fpost_string_noquotes_notags('appname');// filter_var($_POST['appname'], FILTER_SANITIZE_STRING);
        $guid = fpost_string_noquotes_notags('guid',37);

        $archiving_result = false;

        $the_app_name = '\\App\\'.$appname;
        $temp_app = new $the_app_name;
        if ($itemtype == 'item' && method_exists($temp_app, 'restoreItem'))
        {
            $temp_item = $temp_app->getItemByID($id);
            $archiving_result = ($temp_item['guid'] == $guid) ? $temp_app->restoreItem($id, $version) : false;
        }
        else if ($itemtype == 'category' && method_exists($temp_app, 'restoreCategory')) {

            $temp_cat = $temp_app->getCategoryByID($id);
            $archiving_result = ($temp_cat['guid'] == $guid) ? $temp_app->restoreCategory($id, $version) : false;
        }

        // $archiving_result = $this->app->restoreCategory($id, $version);
        if ($archiving_result)
            return ajax_reply(200, 'OK');
        else
            return ajax_reply(201, "Restore Failed for {$itemtype} ID# {$id} and version {$version}");
    }

    public function viewMainPage() {
        die('Disabled');
    }
    //_________________________________________________________________________//
    public function Run()
    {
        switch (fget_alphanumeric('action'))
        {
            case 'restore': 
                return ajax_echo($this->ajaxRestoreArchive());
                break;
            case 'getitemversions':
                return ajax_echo($this->ajaxGetItemVersions(fget_string('appname'), fget_string('guid'), fget_int('start'), fget_int('end'), fget_string_noquotes_notags('sortby'), fget_string_noquotes_notags('sortdirection')));
                break;
            case 'viewitembyversion':
                return ajax_echo($this->ajaxViewItemByVersion(fget_string('appname'), fget_string_noquotes_notags('guid'), fget_double('version')));
                break;
            default:return parent::Run();
        }
    }    
}
            