<?php
/**
 * Core - SCHLIX Updater
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');
try 
{
    $latest_version = $this->getLatestCMSUniversalVersion();
} catch (\Exception $exc)
{
    $error_msg = $exc->getMessage();
}
?>
<x-ui:schlix-explorer-sub-application-header />
<x-ui:schlix-data-explorer-blank data-schlix-controller="SCHLIX.CMS.Core_SCHLIXUpdaterAdminController" >

       
    

        <div class="content">
            <!-- content -->
            <div class="row">
                <div class="col-sm-6">
                    <!-- col content -->
                    <?php if ($latest_version): ?>
                        <strong><?= ___('Current Version') ?></strong>: <?= SCHLIX_VERSION ?><Br />
                        <strong><?= ___('New Version') ?></strong>: <?= $latest_version['version'] ?><Br />                        
                        <strong><?= ___('Released on') ?></strong>: <?= date('Y-m-d', strtotime($latest_version['date_created'])) ?><br />
                        <strong><?= ___('Size') ?></strong>: <?= number_format($latest_version['size'] / (1024*1024), 2) ?>Mb<Br />
                        <strong><?= ___('SHA1') ?></strong>: <?= $latest_version['sha1'] ?><Br />
                        <br />
                        
                        <?php if (version_compare(strtoupper($latest_version['version']), strtoupper(SCHLIX_VERSION)) > 0) : ?>
                            
                            <button class="btn btn-success btn-lg" id="btn-begin-update"><i class="fas fa-shield-alt" ></i> <?= ___('Begin Update') ?></button>
                        <?php else: ?>
                            <i class="fa fa-check-circle" style="color:limegreen"></i> <?= ___('System is up to date') ?>
                        <?php endif ?>
                        <h3><?= ___("What's New") ?></h3>
                        <a href="https://www.schlix.com<?= $latest_version['announcement_url'] ?>" target="_blank" ><i class="fas fa-external-link-alt-square"></i> <?= ___('Read the announcement') ?></a>
                        <?= $latest_version['changelog'] ?>
                    <?php else: ?>
                        <?= ___('503 - Service Unavailable') ?>
                        <p><?= ___h($error_msg) ?></p>
                    <?php endif ?>
                    
                    <!-- end col content -->
                </div>
                
                <div class="col-sm-6">
                    <!-- col content -->
                    <div id="download_progress_indicator" style="display:none">
                        <i class="fa fa-spinner fa-spin fa-3x fa-fw"></i> <?= ___('Please wait while downloading..') ?>
                    </div>
                    <div id="update_processing_files" style="display:none">
                        <i class="fa fa-spinner fa-spin fa-3x fa-fw"></i> <?= ___('Please wait while processing files') ?>
                    </div>
                    <div id="update_upgrading_post_install" style="display:none">
                        <i class="fa fa-spinner fa-spin fa-3x fa-fw"></i> <?= ___('Please wait while running post-install script') ?>
                    </div>
                    <div id="update_upgrading_language" style="display:none">
                        <i class="fa fa-spinner fa-spin fa-3x fa-fw"></i> <?= ___('Please wait while upgrading system language') ?>
                    </div>
                    
                    <div id="update_progress_complete" style="display:none">
                        <i class="fa fa-check fa-2x" style="color:green"></i> <strong><?= ___('Update completed') ?></strong>
                        <p><?= ___('It is recommended that you clear your browser cache and login again to ensure all that all Javascript cache are purged') ?></p>
                    </div>
                    <!-- messages -->
                            <!-- Update Progress -->
                            <div id="update_progress_error"></div>
                            <br/>
                            <div id="update_progress_message"></div>
                            <br/>
                            <!-- End Update Progress -->
                            <!-- Update Progress -->
                            <div id="post_upgrade_error"></div>
                            <br/>
                            <div id="post_upgrade_message"></div>
                            <br/>
                            <!-- End Update Progress -->                
                            <!-- Upgrade Languages  -->
                            <div id="upgrade_lang_error"></div>
                            <br/>
                            <div id="upgrade_lang_message"></div>
                            <br/>
                            <!-- End Upgrade Languages -->                
                    
                    <!-- end col content -->
                    
                </div>                
            </div>
 
            
            <!-- end content -->
        
        </div>
        <!-- End Data Viewer -->
</x-ui:schlix-data-explorer-blank>
