/**
 * Core: Redirection - Javascript admin controller class
 * 
 * Core - Redirection 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  Roy <roy.hadrianoro@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.Core_RedirectionAdminController = class extends SCHLIX.CMS.BaseController
{
    constructor()
    {
        super("core.redirection");
    };
    
    static formatDataTableCell_OldURL(elCell, oRecord, oColumn, oData) {
        var the_id = oRecord.getData('id');
        var itemLink = site_httpbase + this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
        var old_url = site_httpbase + '/' + oData;
        elCell.innerHTML = '<a href="' + itemLink +'">' + old_url + '</a>';
    }

    static formatDataTableCell_NewURL(elCell, oRecord, oColumn, oData) {
        elCell.innerHTML = oData;
    }

    ///////////////////////////////////////////////////////////

    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    
    static formatDataTableCell_CheckBox (elCell, oRecord, oColumn, oData) {

                var theID = '';
                var theValue = '';

                var app_name = this.parentControl.app_name;
                theID = app_name + '-select-id' + oRecord.getData("id");
                theValue = 'i' + oRecord.getData("id");
                elCell.innerHTML = '<input type="checkbox" class="' + app_name + '-chkselections" name="' + app_name + '-chkselections[]" id="' + theID + '"  value="' + theValue + '" />';

    };
    
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'new-item':
                this.redirectToCMSCommand("newitem");
                return true;
                break;
            case 'config':
                this.redirectToCMSCommand("editconfig");
                return true;
                break;
            case 'refresh':
                this.cms_control.refreshControls();
                return true;
                break;
            default:
                return super.runCommand(command, evt);
                break;
        }
    }
};

