<?php
namespace App;

/**
 * Core: Media Header - Admin class
 * 
 * Core - Media Header
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */

class Core_MediaHeader_Admin extends \SCHLIX\cmsAdmin_List {
    /**
     *
     * @var Core_MediaHeader
     */
    protected $app;
    /**
     * Constructor
     */
    public function __construct() {
        // Data: Item
        parent::__construct(true, array());
        // You can enable more items here        
        $this->setItemFieldNamesForAjaxListing('id', 'virtual_filename', 'title',  'date_created', 'date_modified');        
    }
    
    /**
     * Modify data before save item
     * @global \App\Users $CurrentUser
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues) {
        global $CurrentUser;
        
        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);
        
        $current_admin_id = $CurrentUser->getCurrentUserID();
        $field_admin_id = ($datavalues['id'] == 'new') ? 'created_by_id' : 'modified_by_id';
        $datavalues[$field_admin_id] = isset($datavalues[$field_admin_id]) ? (int) $datavalues[$field_admin_id] : 0;
        if (!($datavalues[$field_admin_id] > 0 && $datavalues[$field_admin_id] != $current_admin_id))
            $datavalues[$field_admin_id] = $current_admin_id;
        return $datavalues;
    }
    
    //_________________________________________________________________________//
    public function hook_getApplicationAdminExtraEditCategoryTab($obj, $category)
    {        
        $this->loadHookTemplateFile($obj, 'category', $category);
    }
    //_________________________________________________________________________//
    public function hook_getApplicationAdminExtraEditItemTab($obj, $item)
    {        
        $this->loadHookTemplateFile($obj, 'item', $item);
    }
    //_________________________________________________________________________//
    public function hook_saveConfig($app, $datavalues)
    {
        global $SystemDB, $CurrentUser;
        
        $id =  0;//(int) $id;
        $int_width = $this->app->getConfig('int_width',1920);
        $int_height = $this->app->getConfig('int_height',600);
        $int_image_quality = $this->app->getConfig('int_image_quality',70);
        
        $this->app->initializeDataDirectories();
        $current_year_and_month = date('Y-m');
        $guid = BLANK_GUID;// $app->frontendApp()->getFullApplicationName();
        if ($app && (___c($datavalues) > 0) )
        {
            $current_user_id = $CurrentUser->getCurrentUserID();
            $selection = isset($datavalues['str_cmh_media_selection']) ?  $datavalues['str_cmh_media_selection'] : null;
            $value = '';
            
            switch ($selection)
            {
                case 'path': $value = $datavalues['str_cmh_media_path'];break;
                case 'url': $value = $datavalues['str_cmh_media_url'];break;
                case 'upload':
                    
                    $uploaded_file = $_FILES['str_cmh_media_upload'];
                    $new_image_filename = pathinfo($uploaded_file['name'], PATHINFO_BASENAME);
                    $new_image_fullpath = $this->app->getDataFileFullPath('media_processed', $current_year_and_month.'/'. $new_image_filename);                    
                    $original_image_fullpath = $this->app->getDataFileFullPath('media_original', $current_year_and_month.'/'. $new_image_filename);
                    create_directory_if_not_exists(pathinfo($original_image_fullpath, PATHINFO_DIRNAME), true);
                    create_directory_if_not_exists(pathinfo($new_image_fullpath, PATHINFO_DIRNAME), true);
                    $is_uploaded = is_uploaded_file($uploaded_file['tmp_name']);
                    $upload_ok = $uploaded_file['error'] == UPLOAD_ERR_OK;
                    $valid_image = is_valid_uploaded_image_file($uploaded_file['tmp_name'], $new_image_filename);
                    
                    if ($upload_ok && $is_uploaded && $valid_image)
                    {
                        $move_result = move_uploaded_file($uploaded_file['tmp_name'], $original_image_fullpath);
                        if ($move_result)
                        {
                            $resize_result = create_image_thumbnail($original_image_fullpath, $new_image_fullpath, $int_width, $int_height, true, $int_image_quality);
                            $value = $new_image_filename;
                            $size = $uploaded_file['size'];
                            $type = $uploaded_file['type'];
                            
                        }
                    } else return $datavalues;
                    break;
                default: // none, clear values
                    break;
                    
            }
           
           $app_name = strtolower(get_class($app->frontendApp()));
           $existing_header_image = $this->app->getHeaderImage($app_name, $guid);
           if ($existing_header_image)
           {

               $cmh_row = ['url_file_media' => $value, 'date_modified' => get_current_datetime(), 'modified_by_id' => $current_user_id];
               if ($selection == 'upload')
                   $cmh_row['parent_dir'] =  $current_year_and_month;
               $sanitized_guid = sanitize_string($guid);
               $sanitized_app_class =sanitize_string($app_name);
               $this->app->getItemTable()->quickUpdate($cmh_row, "app_class = {$sanitized_app_class} AND guid = {$sanitized_guid}");
           } else
           {
               $cmh_row = ['app_class' => $app_name, 'guid' => $guid, 'url_file_media' => $value, 'date_created' => get_current_datetime(), 'created_by_id' => $current_user_id];
               $cmh_row['parent_dir'] =  ($selection == 'upload') ? $current_year_and_month : '';
               $this->app->getItemTable()->quickInsert($cmh_row);
           }
        }
        
        return $datavalues;

    }
    
    public function hook_editConfig($obj, $config)
    {        
        if ($obj)
        {
             $frontendapp = $obj->frontendApp();
            $header_image = $this->app->getHeaderImage(get_class($frontendapp), BLANK_GUID);
            
            $config['str_cmh_media'] = isset($header_image['url_file_media']) ? $header_image['url_file_media'] : null;
            $config['str_cmh_parent_dir'] = isset($header_image['parent_dir']) ?  $header_image['parent_dir'] : null;
        }
        
        return $config;

    }    
    
    public function hook_getApplicationAdminExtraEditConfigTab($obj)
    {        
        if ($obj instanceof \SCHLIX\cmsAdmin_List)
        {
            $frontendapp = $obj->frontendApp();
            if ($frontendapp->hasCustomMediaHeader() ) 
            {  
                $header_image = $this->app->getHeaderImage(get_class($frontendapp), BLANK_GUID);
                //print_r($header_image);die;
                $cmh_media = isset($header_image['url_file_media']) ? $header_image['url_file_media'] : null;
                $cmh_parent_dir = isset($header_image['parent_dir']) ? $header_image['parent_dir'] : null;
                
                //$cmh_media = $frontendapp->getConfig('str_cmh_media');
                //$cmh_parent_dir =  $frontendapp->getConfig('str_cmh_parent_dir');
                $attrs = null;
                $data_full_path = null;
                if ($cmh_media && $cmh_parent_dir)
                {
                    
                    $fn = $cmh_parent_dir.'/'.$cmh_media;
                    
                    $data_full_path = $this->app->getDataFileFullPath('media_original', $fn);
                    $data_absolute_url = $this->app->getDataFileURLPathWithHash('media_processed', $fn);                    
                    $attrs = ['data_full_path' => $data_full_path, 'data_absolute_url' => $data_absolute_url];
                }
                $this->loadNativeTemplateFile('config.mediaheader.hook', $attrs, true);
            }
        }        
    }
    
    private function loadHookTemplateFile($obj, $type, $item_obj)
    {
        if ($obj instanceof \SCHLIX\cmsAdmin_List)
        {
            
            $frontendapp = $obj->frontendApp();
            if ($frontendapp->hasCustomMediaHeader() ) 
            {  
                $attrs = null;
                
                if ($item_obj['cmh_media'] && $item_obj['cmh_parent_dir'])
                {
                    
                    $fn = $item_obj['cmh_parent_dir'].'/'.$item_obj['cmh_media'];
                    
                    $data_full_path = $this->app->getDataFileFullPath('media_original', $fn);
                    $data_absolute_url = $this->app->getDataFileURLPathWithHash('media_processed', $fn);
                    $attrs = ['data_full_path' => $data_full_path, 'data_absolute_url' => $data_absolute_url];
                }
                $this->loadNativeTemplateFile('edit.mediaheader.hook', $attrs, true);
            }
        }        
    }
    
    public function Run() {
        switch (fget_alphanumeric('action')) {
            case '':
            case 'main':
                 $this->editConfig();return true;
                break;            
            default: return parent::Run();
        }
    }
    
}