<?php
/**
 * Core: LogViewer - Main admin view template
 * 
 * Core - LogViewer
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();

$this->app->CSS('logviewer.css');

?>
<x-ui:schlix-explorer-sub-application-header />
<x-ui:schlix-data-explorer-list data-schlix-controller="SCHLIX.CMS.Core_LogViewerAdminController" data-enable-preview-link="true" >
    <!-- Toolbar -->
        <x-ui:schlix-explorer-toolbar>
            <x-ui:schlix-explorer-toolbar-menu data-position="left">    
                <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
            </x-ui:schlix-explorer-toolbar-menu>
            <x-ui:schlix-explorer-toolbar-search />
            <x-ui:schlix-explorer-toolbar-menu data-position="right">
                <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                    <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
                </x-ui:schlix-explorer-menu-folder>
            </x-ui:schlix-explorer-toolbar-menu>

        </x-ui:schlix-explorer-toolbar>

        <!-- breadcrumb -->
        <x-ui:schlix-explorer-breadcrumb />        
        <!-- data viewer -->        
        <x-ui:schlix-explorer-row>
            <!-- Right Column -->
            <x-ui:schlix-explorer-right-column>
                <!-- datatable -->
                <x-ui:schlix-data-table schlix-id="datanav-datatable" data-default-sort-by="id" data-default-sort-direction="desc">
                    <x-ui:schlix-data-table-columns>
                        <x-ui:schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="this.formatDataTableCell_CheckBox" sortable="false" />
                        <x-ui:schlix-data-table-column key="id" hidden="false" sortable="true" formatter="number" />
                        <x-ui:schlix-data-table-column key="date_created" label="<?= ___('Date Created') ?>" sortable="true" formatter="this.formatDataTableCell_DateTime"  />
                        <x-ui:schlix-data-table-column key="module" label="<?= ___('Module') ?>" formatter="string" />
                        <x-ui:schlix-data-table-column key="description" sortable="true" label= "<?= ___('Description') ?>" role="title" formatter="SCHLIX.CMS.Core_LogViewerAdminController.formatDataTableCell_ViewLog" />
                        
                        <x-ui:schlix-data-table-column key="ip_address" label="<?= ___('IP address') ?>" formatter="text" />
                        <x-ui:schlix-data-table-column key="host_name" label="<?= ___('Host Name') ?>" formatter="text" />
                        <x-ui:schlix-data-table-column key="user_agent" label="<?= ___('User Agent') ?>" formatter="string" />
                     </x-ui:schlix-data-table-columns>
                </x-ui:schlix-data-table>
                <!-- pagination -->
                <x-ui:schlix-explorer-pagination />
                <!-- end column -->
            </x-ui:schlix-explorer-right-column>
        </x-ui:schlix-explorer-row>
        <!-- End Data Viewer -->
    </x-ui:schlix-data-explorer-list>

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ Log Viewer Dialog ~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<x-ui:schlix-cms-common-dialog class="schlix-cms-common-dialog" id="schlix-cms-logviewer-dialog" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.Core_LogViewerAdminController" header-label="<?= ___('View Log') ?>" data-model="<?= $this->getDataModelURL() ?>" data-button-cancel-id="btn-dialog-cancel"  >
    <!-- form -->
        <div class="logviewer-content" id="message-content" >
            <!-- content goes here -->
        </div>
    <hr />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-dialog-cancel" fonticon="fa fa-times" label="<?= ___('Close') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>

