/**
 * Core: HttpError - Javascript admin controller class
 * 
 * Core - HttpError 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.Core_HttpErrorAdminController = class extends SCHLIX.CMS.BaseController
{
    constructor()
    {
        super("core.httperror");
    };


    ///////////////////////////////////////////////////////////

    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    
    static formatDataTableCell_CheckBox (elCell, oRecord, oColumn, oData) {

                var theID = '';
                var theValue = '';

                var app_name = this.parentControl.app_name;
                theID = app_name + '-select-id' + oRecord.getData("id");
                theValue = 'i' + oRecord.getData("id");
                elCell.innerHTML = '<input type="checkbox" class="' + app_name + '-chkselections" name="' + app_name + '-chkselections[]" id="' + theID + '"  value="' + theValue + '" />';
    };
    
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'new-item':
                this.redirectToCMSCommand("newitem");
                return true;
                break;
            case 'config':
                this.redirectToCMSCommand("editconfig");
                return true;
                break;
            case 'refresh':
                this.cms_control.refreshControls();
                return true;
                break;
            default:
                return super.runCommand(command, evt);
                break;
        }
    }
};

