<?php
/**
 * Core: Extension Gallery - Edit Item Template (Admin)
 * 
 * Core - Extension Gallery
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');
global $HTMLHeader;
$all_screenshots = $this->app->getAllScreenshotsByExtensionID($item['id']);
$all_downloads = $this->app->getAllDownloadsByExtensionID($item['id']);
$this->app->CSS('extgallery.css');
$HTMLHeader->CSS('/system/js/glightbox/glightbox.min.css');
$HTMLHeader->JAVASCRIPT('/system/js/glightbox/glightbox.min.js');

$existing_install = $this->app->getInstalledExtensionRowByExtensionGUID($item['guid']);
$installed_version_info = $existing_install ? $this->app->getDownloadInfoByGUID($existing_install['version_guid']) : null;
$installed_version = $installed_version_info ? $installed_version_info['ext_version'] : null;
?>
<x-ui:schlix-explorer-sub-application-header />
<x-ui:schlix-item-editor  data-main-app-description="<?= ___('Extension Gallery').': '.___h($item['title']) ?>" data-schlix-controller="SCHLIX.CMS.Core_ExtGalleryAdminController">    
    <x-ui:schlix-explorer-toolbar>
        <x-ui:schlix-explorer-toolbar-menu data-position="left">    
            <x-ui:schlix-explorer-menu-command data-schlix-command="main" data-schlix-app-action="main"  fonticon="fab fa-schlix" label="<?= ___('Extension Gallery') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="installedexts" data-schlix-app-action="installedexts" fonticon="fas fa-archive" label="<?= ___('Installed Extensions') ?>" />
            
            
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
        </x-ui:schlix-explorer-toolbar-menu>
        <!-- {help-about} -->
        <x-ui:schlix-explorer-toolbar-menu data-position="right">
            <x-ui:schlix-explorer-menu-command href="https://www.schlix.com/extensions/" target="_blank"  fonticon="fas fa-chalkboard-teacher" open-new-window="1" label="<?= ___('Publish your extensions') ?>" />            
            <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
            </x-ui:schlix-explorer-menu-folder>
        </x-ui:schlix-explorer-toolbar-menu>
        <!-- {end help-about} -->

    </x-ui:schlix-explorer-toolbar>
        

        <x-ui:schlix-editor-form id="form-install-item" method="post" admin-action="extinstall">
            <x-ui:csrf id="_csrftoken" />
            <x-ui:hidden id="id" name="id" data-field="id" />
            <x-ui:row>
                <x-ui:column sm="2">
                    <img src="<?= $item['url_icon'] ?>" alt="<?= ___h($item['title']) ?>" />
                </x-ui:column>
                
                <x-ui:column sm="10">
                    <h1><?= ___h($item['title']) ?></h1>
                    <?php if ($existing_install): ?>
                    <span class="label label-success"><i class="fas fa-check-circle-o"></i> <?= ___('Already installed') ?> (v<?= $installed_version ?>)</span>
                    <?php endif ?>
                    <?= $item['summary'] ?>
                    <x-ui:clearboth />
                    <?= $item['description'] ?>
                </x-ui:column>                
            </x-ui:row>

            <!-- downloads -->
            <?php $total_downloads = ___c($all_downloads); ?>
            <?php if ($total_downloads > 0): ?>
            <table class="table table-responsive table-borderless table-striped ">
                <tr>
                    <th><?= ___('Version') ?></th>
                    <th><?= ___('Compatibility with SCHLIX CMS') ?></th>
                    <th><?= ___('Release date') ?></th>
                    <th><?= ___('File size') ?></th>
                    <th>&nbsp;</th>
                </tr>
            <?php foreach ($all_downloads as $download): ?>
                <?php if ((int) $download['status'] === 1): ?>
                <?php 
                    $btn_type = $download['is_current_stable'] ? 'btn-default' : 'btn-success';
                    $disable_install_reason = $this->app->getIncompatibilityErrorMessage($download);
                    
                    $str_compatible_with = '';
                    if ($download['min_schlix_version'] && $download['max_schlix_version'])
                    {
                        if ($download['min_schlix_version'] === $download['max_schlix_version'])
                            $str_compatible_with = ___('only').' '."{$download['min_schlix_version']}";
                        $str_compatible_with = "{$download['min_schlix_version']} - {$download['max_schlix_version']}";
                    }
                     elseif ($download['min_schlix_version'] )
                        $str_compatible_with = "v{$download['min_schlix_version']}+";
                    elseif ($download['max_schlix_version'] )
                        $str_compatible_with = "< v{$download['max_schlix_version']}";
                    $can_be_installed = empty($disable_install_reason);
                    
                    $act_label = [___('Upgrade to') , ___('Downgrade to'), ___('Install')];
                    $act_type = $installed_version ? (version_compare( $download['ext_version'], $installed_version)> 0 ? 0 : 1) : 2;
                    $label = $act_label[$act_type];
                    
                    //$label = $installed_version ? (version_compare( $download['ext_version'], $installed_version) > 0 ?  ___('Upgrade to') : ___('Downgrade to')) : ___('Install');
                    
                    $install_btn_class = $installed_version == null ? 'schlix-first-time-install-ext-button' : 'schlix-install-ext-button';
                ?>
                <tr>
                    <td><?= $download['ext_version'] ?> <?= $download['is_current_stable'] ? '<i class="fas fa-check"></i> &nbsp;'.___('Stable') : '' ?> </td>
                    <td><?= ___h($str_compatible_with) ?></td>
                    <td><?= date('Y-M-d @ H:i', strtotime($download['date_created'])) ?></td>
                    <td><?=  number_format($download['file_size'], 0) ?> <?= ___('bytes') ?></td>
                    <td>
                        <?php if ($can_be_installed): ?>
                        <?php if ($download['is_current_stable']): ?>
                        <x-ui:button button-type="primary" name="install" class="<?= $install_btn_class ?>" id="btn-request-<?= $download['id'] ?>"  label="<?= $label. ' v'.___h($download['ext_version']) ?>" value="<?= ___h($download['guid']) ?>" fonticon="fas fa-download" data-title="<?= ___h($item['title'].' v'.$download['ext_version']) ?>" data-act="<?= $act_type ?>" />  
                        <?php else: ?>
                            <x-ui:button button-type="default" name="install" class="<?= $install_btn_class ?>" id="btn-request-<?= $download['id'] ?>"  label="<?= $label. ' v'.___h($download['ext_version']) ?>" value="<?= ___h($download['guid']) ?>" fonticon="fas fa-download" data-title="<?= ___h($item['title'].' v'.$download['ext_version']) ?>" data-act="<?= $act_type ?>" />                                       
                        <?php endif ?>
                        <?php else: ?>
                            <span class="label label-default"><?= ___h($disable_install_reason) ?></span>
                        <?php endif ?>
                    </td>
                </tr>
                <?php endif ?>
            <?php endforeach ?>
            </table>
            <?php endif ?>
            

            <!-- screenshots -->
            <?php if (___c($all_screenshots) > 0): ?>
            <hr />
                <div id="ext-screenshots">
                    <h3><?= ___('Screenshots') ?></h3>
                    <ul class="schlix_screenshot-thumbnails">
                        <?php $screenshot_count = 0; ?>
                        <?php foreach ($all_screenshots as $ss): ?>
                        <li>
                            <a class="glightbox" href="<?= ___h($ss['url_image_large']) ?>">
                            <img class="jslghtbx-thmb" src="<?= ___h($ss['url_image_small']) ?>" alt="<?= ___h($item['title']).' '.$screenshot_count ?>" />             
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ul>

                </div>
            <?php endif ?>
             <!-- end main section -->
            <!-- begin tabs -->
     
            <!-- end tabs -->
        </x-ui:schlix-editor-form>    
</x-ui:schlix-item-editor>



<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~ First time install Dialog ~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<x-ui:schlix-cms-common-dialog class="schlix-cms-common-dialog" id="schlix-cms-first-time-install-dialog" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.Core_ExtGalleryAdminController" header-label="<?= ___('Installation Confirmation') ?>" data-model="<?= $this->getDataModelURL() ?>" data-button-submit-id="btn-install-ok" data-button-cancel-id="btn-install-cancel" data-action="action=extinstall" form-method="post" >
    <!-- form -->
    <x-ui:csrf />
    <x-ui:hidden name="guid" id="first-time-install-version-guid" />
    
    <div id="install-title"></div>
    <x-ui:checkbox label="<?= ___('Install sample data (if available)') ?>" name="install_sample_data" value="1" />
    <x-ui:alert type="info"><p class="ext-install-notice"><?= ___('Please note that still need to activate the extension by going to Application/Block/Macro Manager once the installation has been completed') ?></p></x-ui:alert>
    <x-ui:textbox type="password" name="password" id="password" required="required" label="<?= ___('Please enter your password') ?>" fonticon="fas fa-lock" />
    <hr />
    <x-ui:schlix-cms-dialog-button-submit id="btn-install-ok" fonticon="fa fa-check" label="<?= ___('OK') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-install-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>


<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~ Upgrade Dialog ~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<x-ui:schlix-cms-common-dialog class="schlix-cms-common-dialog" id="schlix-cms-upgrade-ext-dialog" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.Core_ExtGalleryAdminController" header-label="<?= ___('Upgrade confirmation') ?>" data-model="<?= $this->getDataModelURL() ?>" data-button-submit-id="btn-install-ok" data-button-cancel-id="btn-install-cancel" data-action="action=extupgrade" form-method="post" >
    <!-- form -->
    <x-ui:csrf />
    <x-ui:hidden name="guid" id="upgrade-guid" />
    
    <div id="upgrade-title"></div>
    <hr />
    <x-ui:textbox type="password" name="password" id="password" required="required" label="<?= ___('Please enter your password to confirm') ?>" fonticon="fas fa-lock" />
    <hr />
    <x-ui:schlix-cms-dialog-button-submit id="btn-install-ok" fonticon="fa fa-check" label="<?= ___('OK') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-install-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>
