<?php
namespace App;
/**
 * Core: Extension Gallery - Main Class
 * 
 * Core - Extension Gallery
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */

class Core_ExtGallery extends \SCHLIX\cmsApplication_HierarchicalTree_List {

    protected $data_directories = array(
      'tmp' => '/data/private/extmanager/tmp',      
      'extract_tmp' => '/data/private/extmanager/tmp/schlix',      
      'backupsql' => '/data/private/extmanager/backupsql',
    );
    
    /**
     *
     * @var \SCHLIX\cmsSQLTable 
     */
    protected $table_extmanager;

    /**
     * Constructor
     * @global \SCHLIX\cmsDatabase $SystemDB
     */
    public function __construct() {
        global $SystemDB;
        
        parent::__construct('Extension Gallery', 'gk_extgallery_items', 'gk_extgallery_categories');
        $this->table_extmanager = new \SCHLIX\cmsSQLTable('gk_extmanager_items');
        $this->schema_org_type_item = '';
        /* You can modify this  */
        $this->has_versioning = true; // set to false if you don't need versioning capability if this app wants versioning enabled
        $this->disable_frontend_runtime = true; //  set this to true if this is a backend only app         
    }
    
    public function getInstalledExtensionRowByVersionGUID($version_guid)
    {
        global $SystemDB;
        
        $row = $SystemDB->getQueryResultSingleRow("SELECT * FROM {$this->table_extmanager} WHERE version_guid = :guid", ['guid' => $version_guid]);
        return $row;
    }
    
    
    public function getInstalledExtensionRowByExtensionGUID($ext_guid)
    {
        global $SystemDB;
        
        $row = $SystemDB->getQueryResultSingleRow("SELECT * FROM {$this->table_extmanager} WHERE ext_guid = :guid", ['guid' => $ext_guid]);
        return $row;
    } 
    
    public function getInstallID($ext_guid, $version_guid)
    {
        global $SystemDB;
        
        $row = $SystemDB->getQueryResultSingleRow("SELECT * FROM {$this->table_extmanager} WHERE ext_guid = :ext_guid AND version_guid = :version_guid", ['ext_guid' => $ext_guid, 'version_guid' => $version_guid]);
        return $row ? (int) $row['id'] : 0;
    }
 
    /**
     * Check if an extension is installed. GUID is the download GUID
     * @global \App\Users $CurrentUser
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param string $ext_guid
     * @param string $version_guid
     * @param array $dir_list
     * @param array $file_list
     */
    public function markInstalled($ext_guid, $version_guid, $dir_list, $file_list)
    {
        global $CurrentUser;
        
        $extver = $this->getDownloadInfoByGUID($version_guid);
        usort($dir_list, function($a, $b) {
    return strlen($b) - strlen($a);});
        if ($extver && $extver['item_guid'] = $ext_guid)
        {
            
            $existing_install = $this->getInstalledExtensionRowByExtensionGUID($ext_guid);
            if ($existing_install)
            {
                $id = $existing_install['id']; // $this->getInstallID($ext_guid, $version_guid);
                if ($id > 0)
                {
                    $data = [
                        'version_guid' => $version_guid,
                        'date_modified' => get_current_datetime(),
                        //'is_outdated' => false,
                        'installed_by_id' => $CurrentUser->getCurrentUserID(),

                        //'file_list' => $str_file_list
                    ];
                    $this->table_extmanager->quickUpdate($data, "id = {$id}");
                    $this->logInfo("Extension {$extver['title']} has been upgraded to {$extver['ext_version']}");
                } else throw new \Exception("Error during upgrade");
            } else 
            {
                $combo_list = ['dirs' => $dir_list, 'files' => $file_list];
                $str_combo_list = json_encode($combo_list, JSON_PRETTY_PRINT | JSON_OBJECT_AS_ARRAY);
                $data = [
                    'ext_guid' => $ext_guid,
                    'version_guid' => $version_guid,
                    'date_created' => get_current_datetime(),
                    'is_outdated' => false,
                    'installed_by_id' => $CurrentUser->getCurrentUserID(),
                    'file_list' => $str_combo_list
                ];
                $this->table_extmanager->quickInsert($data);
                $this->logInfo("Extension {$extver['title']} has been installed for the first time");
            }
        }
    }
    

    public function refreshInstallDatabase()
    {
        $admin_app = new \App\Core_ApplicationManager_Admin();
        $admin_app->checkForUnregisteredItems();
        $admin_app = null;
        
        $admin_block = new \App\Core_BlockManager_Admin();
        $admin_block->checkForUnregisteredItems();
        $admin_block = null;

        $admin_macro = new \App\Core_MacroManager_Admin();
        $admin_macro->checkForUnregisteredItems();
        $admin_macro = null;

        $admin_theme = new \App\Core_ThemeManager_Admin();
        $admin_theme->checkForUnregisteredItems();
        $admin_theme = null;        
        
    }
    
    public function uninstallExtension($id)
    {
        global $SystemDB;
        
        $row = $SystemDB->getQueryResultSingleRow("SELECT * FROM {$this->table_extmanager} WHERE id = :id", ['id' => $id]);
        if ($row)
        {
            $file_list = json_decode($row['file_list'], true);
            if (json_last_error() == JSON_ERROR_NONE)
            {
                $dirs = $file_list['dirs'];
                //$files = $file_list['files'];
                /*foreach ($files as $file)
                {
                    //$path = remove_multiple_slashes(CURRENT_SUBSITE_PATH.$file);
                }*/
                if ($dirs)
                {
                    
                    foreach ($dirs as $dir)                
                    {
                        
                        if (strlen($dir) > 5)
                            __del_tree( CURRENT_SUBSITE_PATH.$dir);
                    }
                    $sdirs = implode(', ', $dirs);
                    $extinfo = $this->getDownloadInfoByGUID($row['version_guid']);
                    $this->logInfo("Uninstalled {$extinfo['title']} v{$extinfo['ext_version']} and deleted {$sdirs}");
                    $this->refreshInstallDatabase();
                    
                } else
                    $this->logError("Nothing to delete for ext ID # {$id}");
            }
            $SystemDB->query("DELETE FROM {$this->table_extmanager} WHERE id = :id", ['id' => (int) $id]);
        } else  $this->logError("Unable to uninstall ext ID # {$id}");
    }
    //_________________________________________________________________________//
    public function installExtensionFromFile($filename, $extension_guid, $version_guid) {
        //TODO: error checking and validation
        //include_inc('pclzip/pclzip.class.php');
        // Set the available backend directories, e.g.: apps, blocks, filters, libs, themes, etc
        $backend_dirs = array('themes', 'apps', 'blocks', 'macros', 'libs', 'wysiwygeditors');


        $filename = realpath($filename);
        $zip = null;
        if (is_file($filename) && is_readable($filename))
        {
            $zip = new \PclZip($filename);
        } else return -1;
        // 1. Determine the app name
        if (($list = $zip->listContent()) == 0) {
            //displayMessageBox("Error : " . $zip->errorInfo(true));
            return -2;
        }

        $array_app_name = [];
        $array_directories = [];
        $arr_list_dirs = [];
        $arr_list_files = [];
        $count = sizeof($list);
        for ($i = 0; $i < $count; $i++) {
            $filename = $list[$i]['filename'];
            if ($list[$i]['folder'] == true) {
                
                $dirnamestack = explode('/', $filename);
                $array_directories[] = $filename;
                $app_name = $dirnamestack[0];
                // PHP8 compatibility
                if (isset($array_app_name[$app_name]))
                    $array_app_name[$app_name]++;
                else 
                    $array_app_name[$app_name] = 1;
                // end PHP8 compatibility
                if (substr_count($filename, '/') > 2 && !str_contains($filename, '..'))
                    $arr_list_dirs[] = $filename;
            } else
            {
                if ( !str_contains($filename, '..'))
                    $arr_list_files[] = $filename;
            }
            
                
        }
        $cnt_dirs = ___c($arr_list_dirs);
        for ($i = 0; $i < $cnt_dirs; $i++)
        {
            $arr_list_dirs[$i] = remove_prefix_from_file_name($arr_list_dirs[$i], $app_name);
        }
        $cnt_files = ___c($arr_list_files);
        for ($i = 0; $i < $cnt_files; $i++)
        {
            $arr_list_files[$i] = remove_prefix_from_file_name($arr_list_files[$i], $app_name);
        }
        //$arr_list_files = $list;
        $maxcount = max($array_app_name);
        $the_app_name = array_search($maxcount, $array_app_name);
        // 2. Determine if all directory structure is correct  - TODO: fix inefficient detection
        $is_valid = false;
        // 3. Extract
        // 4. Move directories to destination
        foreach ($backend_dirs as $backend_dir) {
            /* if ($valid_pkg[$prefix]) {
              //echo $prefix.BR();

              if ($zip->extract(PCLZIP_OPT_PATH, $targetpath, PCLZIP_OPT_BY_NAME, $the_app_name . "/{$prefix}_files/", PCLZIP_OPT_REMOVE_PATH, $the_app_name . "/{$prefix}_files/") == 0)
              $errorstr = $zip->errorInfo(true);

              } */
            $targetpath = SCHLIX_SITE_PATH . '/' . $backend_dir . '/';
            $str_file = $the_app_name . '/' . $backend_dir . '/' . $the_app_name . '/';
            if (in_array($str_file, $array_directories)) {
                $target_dest1 = $the_app_name . '/' . $backend_dir . '/';
                $target_dest2 = $target_dest1;
                if ($zip->extract(PCLZIP_OPT_PATH, $targetpath, PCLZIP_OPT_BY_NAME, $target_dest1, PCLZIP_OPT_REMOVE_PATH, $target_dest2) == 0)
                    $errorstr = $zip->errorInfo(true);
                $is_valid = true;
            }
        }
        if ($is_valid) {
            $this->markInstalled($extension_guid, $version_guid, $arr_list_dirs, $arr_list_files);
            $this->refreshInstallDatabase();
            return 1;
        } else {
            return -3;
        }
    }

    //_________________________________________________________________________//
    public function Upgrade() {
        return false;
    }    
    
    public function getDownloadInfoByGUID($guid)
    {
        global $SystemDB;        
        return $SystemDB->getQueryResultSingleRow("SELECT gk_extgallery_downloads.*, gk_extgallery_items.virtual_filename, gk_extgallery_items.title, gk_extgallery_items.guid as item_guid FROM gk_extgallery_downloads INNER JOIN gk_extgallery_items ON gk_extgallery_downloads.item_guid = gk_extgallery_items.guid WHERE gk_extgallery_downloads.guid = :guid", ['guid' => $guid]);
    }

    public function checkLatestRepoData()
    {
        $last_update_check = $this->getConfig('str_last_repo_check');
        $current_time = get_current_datetime();
        
        
        $cs = 3600 ;
        $check_n_dl = false;
        if (is_date($last_update_check))
        {
            
            $seconds_diff = time_difference($last_update_check, $current_time);
            //echo $seconds_diff;die;
            $check_n_dl = ($seconds_diff > $cs);
        } else $check_n_dl = true;
        
        
        if ($check_n_dl)
        {
            
            $repo_data = $this->getLatestRepoData();
            $this->logInfo('Checking the latest SCHLIX CMS extensions repo data');
            $checksum = isset($repo_data['sha1_checksum']) ? $repo_data['sha1_checksum'] : null;
            $prev_checksum = $this->getConfig('str_repo_checksum');            
            if ($checksum !== $prev_checksum || empty($checksum))
            {
                $this->logInfo('Trying to refresh the latest SCHLIX CMS extension data');
                $this->forceRefreshRepoData($repo_data);
                $this->logInfo('Completed - repo data has been successfully refreshed');
                $this->setConfig('str_last_repo_check', $current_time);
                $this->setConfig('str_repo_checksum', $checksum);
            }
        }
    }
    
    public function forceRefreshRepoData($jsdata)
    {
        global $SystemDB;
        
        if ((int) $jsdata ['status'] === 200)
        {
            $repo_data = $jsdata['data'];
            $categories = $repo_data['categories'];
            $exts = $repo_data['extensions'];
            $dls = $repo_data['extensions_downloads'];
            
            $screenshots = $repo_data['extensions_screenshots'];
            $table_downloads = new \SCHLIX\cmsSQLTable('gk_extgallery_downloads');
            $table_screenshots = new \SCHLIX\cmsSQLTable('gk_extgallery_screenshots');
            
            $SystemDB->query("TRUNCATE TABLE {$this->table_categories}");
            $SystemDB->query("TRUNCATE TABLE {$this->table_items}");
            $SystemDB->query("TRUNCATE TABLE {$table_downloads}");
            $SystemDB->query("TRUNCATE TABLE {$table_screenshots}");
            // categories
            $i = 1;
            $catguids = [];
            foreach ($categories as $cat)
            {
                $cat['date_created'] = get_current_datetime();
                $this->table_categories->quickInsert($cat);
                $catguids[$cat['guid']] = $i;
                $i++;
            }
            // items
            $i = 1;
            $extguids = [];
            foreach ($exts as $ext)
            {
                $ext['category_id'] = $catguids[$ext['category_guid']];
                $ext['status'] = 1;
                $this->table_items->quickInsert($ext);                
                $extguids[$ext['guid']] = $i;
                $i++;
            }
            //downloads
            foreach ($dls as $dl)
            {
                $dl['item_id'] = $extguids[$dl['item_guid']];
                $dl['status'] = $dl['version_status'];
                $table_downloads->quickInsert($dl);
                
            }
            //screenshots
            foreach ($screenshots as $dl)
            {
                $dl['item_id'] = $extguids[$dl['item_guid']];
                $table_screenshots->quickInsert($dl);
                
            }
            
            //die;
        }
    }
    
    public function getAllScreenshotsByExtensionID($item_id)
    {
        $table = new \SCHLIX\cmsSQLTable('gk_extgallery_screenshots');
        return $table->q()->select('*')->where('item_id = :item_id')->getQueryResultArray(['item_id' => $item_id]);
    }
    
    public function getAllDownloadsByExtensionID($item_id)
    {
        $table = new \SCHLIX\cmsSQLTable('gk_extgallery_downloads');
        return $table->q()->select('*')->where('item_id = :item_id')->getQueryResultArray(['item_id' => $item_id]);        
    }
    
    /**
     * Get latest CMS version
     * @return array
     */
    public function getLatestRepoData() {
        
        $repo_domain = "https://www.schlix.com";
        
        $str_content = @get_remote_file_content("{$repo_domain}/cms-services/action/repodata");        
        if ($str_content) {
            $jsdata = json_decode($str_content, true);
            if (json_last_error() === 0)
                return $jsdata;
            else 
            {
                $this->logError("Error - Unable to check the latest repo data from {$repo_domain}");
                die('error');
            }
        }
        return null;
    }
    
    public function getInstalledExtensions()
    {
        global $SystemDB;
        
        $sql = "SELECT gk_extmanager_items.id as install_id, gk_extgallery_downloads.*, gk_extgallery_items.virtual_filename, url_icon, gk_extgallery_items.title, gk_extgallery_items.guid as item_guid, gk_extgallery_items.id as item_id, file_list "
                . "FROM gk_extmanager_items "
                . "INNER JOIN gk_extgallery_items ON (gk_extmanager_items.ext_guid = gk_extgallery_items.guid) "
                . "LEFT JOIN gk_extgallery_downloads ON (gk_extmanager_items.version_guid = gk_extgallery_downloads.guid) ";
                //. "WHERE gk_extgallery_downloads.guid = :guid";
        return $SystemDB->getQueryResultArray($sql );
    }
    
    /**
     * Get error message
     * @internal
     * @param array $download
     */
    public function getIncompatibilityErrorMessage($download)
    {
        $install_id = $this->getInstallID($download['item_guid'], $download['guid']);

        $disable_install_reason = '';
        if ($install_id > 0)
        {
            $disable_install_reason = ___('Already installed') ;
        }
        if (!empty($download['min_schlix_version']) && version_compare(SCHLIX_VERSION, $download['min_schlix_version']) === -1)
            $disable_install_reason = ___('Incompatible. Minimum version').': '.$download['min_schlix_version'];
        if (!empty($download['max_schlix_version']) && version_compare(SCHLIX_VERSION, $download['max_schlix_version']) === 1)
            $disable_install_reason = ___('Incompatible. Maximum version').': '.$download['max_schlix_version'];
        return $disable_install_reason;
    }
    
    /**
     * Return the next available package to upgrade
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param string $download_guid
     * @return array
     */
    public function getNextCompatibleVersion($download_guid)
    {
        global $SystemDB;
        
        $current_v =  $SystemDB->getQueryResultSingleRow("SELECT * FROM gk_extgallery_downloads WHERE guid = :guid", ['guid' => $download_guid]);
        $next_version = null;
        if ($current_v)
        {
            $sql = "SELECT * FROM gk_extgallery_downloads WHERE item_id = :ext_id AND guid <> :guid and id > :current_id AND status = 1";
            $other_versions = $SystemDB->getQueryResultArray($sql, ['ext_id' => $current_v['item_id'], 'guid' => $current_v['guid'], 'current_id' => $current_v['id']]);
            
            foreach ($other_versions as $other_v)
            {
                $error_message = $this->getIncompatibilityErrorMessage($other_v);
                if (empty($error_message))
                    return $other_v;
            }
        } 
        return $next_version;
    }
    /**
     * Returns the default category ID 
     * @return int
     */
    public function getDefaultCategoryID() {
        return 0;
    }   
    
    /**
     * Run command passed by the main router
     * @param array $command
     * @return bool
     */
    public function Run($command) {
        switch ($command['action']) {
            case 'viewitem':
                $this->viewItemByID($command['id'], $this->cache);
                break;
            case 'viewcategory': $this->viewCategoryByID($command['cid'], $command['pg'], 'date_created', 'DESC', $this->cache);
                break;
            case 'main': $this->viewMainPage($command['pg']);
                break;

            default: return parent::Run($command);
        }

        return RETURN_FULLPAGE;
    }
}
            