<?php
namespace App;

/**
 * Core: Error 404 - Admin class
 * 
 * Core - Error 404
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  Roy <roy.hadrianoro@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_Error404_Admin extends \SCHLIX\cmsAdmin_List {

    /**
     * Constructor
     */
    public function __construct() {
        // Data: Item
        parent::__construct(true, array());
        // You can enable more items here        
        $this->setItemFieldNamesForAjaxListing('id', 'path', 'hits', 'date_modified');
        $this->search_field = 'path';
    }

    /**
     * Modify items to show edit rule button when there's existing redirect rule.
     * @param array $result
     * @return array
     */
    public function modifyAjaxGetAllItemsResult($result)
    {
        $count = ___c($result);
        $app_redirect = new \App\Core_Redirection();
        // TODO: probably should get all rules at once rather than triggering SQL queries for each item?
        for ($i = 0;$i < $count; $i++)
        {
            $path = $result[$i]['path'];
            $existing_redir = $app_redirect->getItemByExactPath($path);
            $result[$i]['redirect_id'] = $existing_redir ? $existing_redir['id'] : '0';
        }
        return $result;
        
    }
    
}