<?php
/**
 * Core - Email setup Admin
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die('No Access');

$SCHLIX_MAIL_DEFAULT_SENDER = SCHLIX_MAIL_DEFAULT_SENDER;
$SCHLIX_MAIL_DEFAULT_EMAIL = SCHLIX_MAIL_DEFAULT_EMAIL;
$SCHLIX_SMTP_HOST = SCHLIX_SMTP_HOST;
$SCHLIX_SMTP_PORT = SCHLIX_SMTP_PORT;
$SCHLIX_SMTP_SECURITY = SCHLIX_SMTP_SECURITY;
$SCHLIX_SMTP_USERNAME = SCHLIX_SMTP_USERNAME;
$SCHLIX_SMTP_PASSWORD = SCHLIX_SMTP_PASSWORD;

$SCHLIX_SMTP_OAUTH2_PROVIDER = defined('SCHLIX_SMTP_OAUTH2_PROVIDER') ? SCHLIX_SMTP_OAUTH2_PROVIDER : null;
$SCHLIX_SMTP_OAUTH2_CLIENT_ID = defined('SCHLIX_SMTP_OAUTH2_CLIENT_ID') ? SCHLIX_SMTP_OAUTH2_CLIENT_ID : null;
$SCHLIX_SMTP_OAUTH2_SECRET = defined('SCHLIX_SMTP_OAUTH2_SECRET') ? SCHLIX_SMTP_OAUTH2_SECRET : null;
$SCHLIX_SMTP_OAUTH2_REFRESH_TOKEN = defined('SCHLIX_SMTP_OAUTH2_REFRESH_TOKEN') ? SCHLIX_SMTP_OAUTH2_REFRESH_TOKEN : null;
$SCHLIX_SMTP_USE_AUTH = defined('SCHLIX_SMTP_USE_AUTH') ? (int) SCHLIX_SMTP_USE_AUTH : 0;
$SCHLIX_SMTP_SECURITY_SELF_SIGNED = defined('SCHLIX_SMTP_SECURITY_SELF_SIGNED') ? (int) SCHLIX_SMTP_SECURITY_SELF_SIGNED : 0;

$fix_smtp_auth_allow_self_signed = defined('SCHLIX_SMTP_SECURITY_SELF_SIGNED') && SCHLIX_SMTP_SECURITY_SELF_SIGNED ? ' checked="checked" ' : ''; 

$this->app->CSS('emailsetup.css');

?>

<x-ui:schlix-data-explorer-blank data-schlix-controller="SCHLIX.CMS.Core_EmailSetupAdminController" >
    <!-- Toolbar -->
    <x-ui:schlix-explorer-toolbar>
        <x-ui:schlix-explorer-toolbar-menu data-position="left">    
            <x-ui:schlix-explorer-menu-command data-schlix-command="main" data-schlix-app-action="main"  fonticon="fas fa-server" label="<?= ___('Basic Email Setup') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="authxo2" data-schlix-app-action="authxo2"  fonticon="fas fa-server" label="<?= ___('Authorize OAUTH2 connection') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="test-send"  fonticon="fas fa-envelope" label="<?= ___('Test outgoing email') ?>" />                               
        </x-ui:schlix-explorer-toolbar-menu>


    </x-ui:schlix-explorer-toolbar>
    <x-ui:form-simple-ajax data-action="<?= $this->createFriendlyAdminURL('action=submitconfig') ?>" id="schlix-contact-form" class="contact_form" enctype="multipart/form-data">        
        <x-ui:schlix-info-box class="box-danger" fonticon="fa fa-envelope" label="<?= ___('E-mail') ?>" >

            <x-ui:row>
                <!-- col -->
                <x-ui:column md="6">
                    
                    <x-ui:csrf />
                    <x-ui:textbox name="mail_default_sender" autocomplete="off" id="mail_default_sender" default-value="Webmaster" data-var="SCHLIX_MAIL_DEFAULT_SENDER" fonticon="fa fa-user-circle" label="<?= ___('Default Mail Sender Name') ?>" required="required" placeholder="Webmaster" />
                    <x-ui:textbox type="email" name="mail_default_email" id='mail_default_email'  data-var="SCHLIX_MAIL_DEFAULT_EMAIL" fonticon="fa fa-envelope" label="<?= ___('Email address') ?>" required="required" placeholder="mail@example.com" />

                    <fieldset>
                        <legend><?= ___('Outgoing SMTP server') ?></legend>
                        <em><?= (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN' && empty($SCHLIX_SMTP_HOST) ) ? ___('Please configure the SMTP server, otherwise registration/contact mail will not work') : ___('Leave the SMTP settings below blank to use the default settings') ?></em>

                        <x-ui:textbox name="smtp_host" id="smtp_host" data-var="SCHLIX_SMTP_HOST" placeholder="mail.example.com" label="<?= ___('Server') ?>" prefix="<?= ___('Host') ?>" />
                        <!-- field -->
                        <x-ui:form-group>
                            <x-ui:input-group>
                                <x-ui:input-addon>                                
                                    <?= ___('Port') ?>
                                </x-ui:input-addon>

                                <x-ui:textbox name="smtp_port" id="smtp_port" type="number" min="0" max="65535" data-var="SCHLIX_SMTP_PORT" placeholder="25, 465 (SSL), <?= ___('or') ?> 587 (TLS)"  />

                                <x-ui:input-addon>
                                    <span><?= ___('Security') ?>: </span>

                                    <x-ui:radio name="smtp_secure_with" id="smtp_secure_with_none"  value="" data-var="SCHLIX_SMTP_SECURITY" label="<?= ___('none') ?>" no-wrapper="1" />
                                    <x-ui:radio name="smtp_secure_with" id="smtp_secure_with_ssl"  value="ssl" data-var="SCHLIX_SMTP_SECURITY" label="<?= ___('SSL') ?>" no-wrapper="1" />
                                    <x-ui:radio name="smtp_secure_with" id="smtp_secure_with_tls"  value="tls" data-var="SCHLIX_SMTP_SECURITY" label="<?= ___('TLS') ?>" no-wrapper="1" />
                                    <x-ui:checkbox name="smtp_security_self_signed" id="smtp_security_self_signed"  value="1" label="<?= ___('Allow self-signed certificate'); ?>" <?= $fix_smtp_auth_allow_self_signed ?> no-wrapper="1" />


                                </x-ui:input-addon>

                            </x-ui:input-group>
                        </x-ui:form-group>

                        
                        <x-ui:select name="smtp_use_auth" id="smtp_use_auth" fonticon="fas fa-server" label="<?= ___('Use SMTP authentication') ?>" data-var="SCHLIX_SMTP_USE_AUTH">
                            <x-ui:option value="" label="-- <?= ___('No authentication') ?> --" />
                            <x-ui:option value="1" label="Regular password" />
                            <x-ui:option value="2" label="OAUTH2" />
                        </x-ui:select> 

                        <div id="smtp_username_box">
                            <x-ui:textbox name="smtp_username" id="smtp_username" data-var="SCHLIX_SMTP_USERNAME" fonticon="far fa-user" label="SMTP <?= ___('Username') ?>" autocomplete="off" placeholder="smtpuser@mail.example.com"   /></div>
                        <div id="smtp_password_box">
                        <x-ui:textbox type="password" name="smtp_password" id="smtp_password" data-var="SCHLIX_SMTP_PASSWORD" fonticon="fa fa-lock" label="SMTP <?= ___('Password') ?>" autocomplete="off" placeholder="SMTP <?= ___('Password') ?>" /> 
                        </div>
                    </fieldset>        
                    </x-ui:column>
                    <!-- columnn -->
                    <?php if ($SCHLIX_SMTP_OAUTH2_PROVIDER): ?>
                        <x-ui:column md="6">
                            <fieldset id="smtp_oauth2_box">

                                <legend><?= ___('OAUTH2 Settings') ?></legend>
                                <x-ui:textbox  id="oauth2_provider" data-var="SCHLIX_SMTP_OAUTH2_PROVIDER" fonticon="far fa-user" label="<?= ___('Provider') ?>" readonly="readonly" disabled="disabled" />
                                <x-ui:textbox  id="oauth2_clientid" data-var="SCHLIX_SMTP_OAUTH2_CLIENT_ID" fonticon="far fa-user" label="<?= ___('Client ID') ?>/<?= ___('Application ID') ?>" readonly="readonly" disabled="disabled"  />
                                <x-ui:textbox  id="oauth2_secret" data-var="SCHLIX_SMTP_OAUTH2_SECRET" fonticon="fas fa-key" label="<?= ___('Secret Key') ?>" readonly="readonly" disabled="disabled"  />
                                <x-ui:textbox  id="oauth2_refresh_token" data-var="SCHLIX_SMTP_OAUTH2_REFRESH_TOKEN" fonticon="fas fa-mask" label="<?= ___('Refresh Token') ?>" readonly="readonly" disabled="disabled" />

                            </fieldset>  
                        </x-ui:column>
                    <?php endif ?>
            </x-ui:row>
            <x-ui:row>
                <x-ui:column sm="6">
                    <div class="schlix-ajax-output"></div>
                    <x-ui:button button-type="ok" type="submit" data-form-submit="1" name="sendmail" id="schlixcontact-submit-button" value="Submit" label="<?= ___('Save') ?>" fonticon="fa fa-paper-plane" />
                </x-ui:column>
            </x-ui:row>
        </x-ui:schlix-info-box>


    </x-ui:form-simple-ajax>    
    <!-- End Data Viewer -->
</x-ui:schlix-data-explorer-blank>


<?php require('view.testmail.admin.template.php'); ?>