<?php
namespace App;

use League\OAuth2\Client\Provider\Google;
use Hayageek\OAuth2\Client\Provider\Yahoo;
use Stevenmaguire\OAuth2\Client\Provider\Microsoft;

/**
 * Core: EmailQueue - Main Class
 * 
 * Core - EmailQueue
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_EmailSetup extends \SCHLIX\cmsApplication_Basic {
                    
    /**
     * Constructor
     */
    public function __construct() {
        
        parent::__construct('Email Setup');
            
        $this->disable_frontend_runtime = false;   
    } 
    

    //_______________________________________________________________________________________________________________//
    public function Run($command) {
        switch ($command['action'])
        {
            case 'redirect': 
                $this->getOauthToken();
                return FALSE;
                break;
            default:
                return parent::Run($command);
        }
        
        return false;
    }
    
    public static function checkOAuthPackages()
    {
        //https://console.developers.google.com/project
        $required_classes = [
            "\\League\\OAuth2\\Client\\Provider\\Google",
            "\\Hayageek\\OAuth2\\Client\\Provider\\Yahoo",
            "\\Stevenmaguire\\OAuth2\\Client\\Provider\\Microsoft"            
        ];
        $composer_packages = ['league/oauth2-google', 'hayageek/oauth2-yahoo', 'stevenmaguire/oauth2-microsoft'];
        
        foreach ($required_classes as $cl)
        {
            if (!class_exists($cl))
            {
                $composer = new \App\Core_Composer();
                $composer->installComposerPackage($composer_packages);
                return false;
            }
        }
        return true;
    }
    
    /**
     * Returns OAuth provider object
     * @param string $provider
     * @param string $clientid
     * @param string $secret
     * @return array 
     */
    public function getOAuthProviderObject($provider, $clientid, $secret)
    {
        $oauth_provider = null;
            
            $params = [
                'clientId' => $clientid,
                'clientSecret' => $secret,
                'redirectUri' => $this->getURLRedirect(),
                'accessType' => 'offline'
            ];

        $options = [];
        switch ($provider) {
            case 'google':
                $oauth_provider = new Google($params);
                $options = [ 'scope' => [ 'https://mail.google.com/' ] ];
                break;
            case 'yahoo':
                $oauth_provider = new Yahoo($params);
                break;
            case 'microsoft':
                $oauth_provider = new Microsoft($params);
                $options = [
                    'scope' => [
                        'wl.imap',
                        'wl.offline_access'
                    ]
                ];
                break;
        }      
        return ['provider' => $oauth_provider, 'options' => $options];
    }
    
    private function redirectToAdminURL()
    {
        
        include_once(SCHLIX_ROOT_PATH . '/system/libs/schlix/admin_basic.class.php');

        $adm = new \App\Core_EmailSetup_Admin();
        $url_admin = $adm->getURLResult();
        redirect_url($url_admin);    
    }
    /**
     * 
     * @global \App\Users $CurrentUser
     * @global \SCHLIX\cmsHTMLPageHeader $HTMLHeader
     * @return boolean
     */
    public function viewMainPage() {
        
        global $CurrentUser, $HTMLHeader;
        
        $code = fget_string('code', 255);
        $state = fget_string('state', 255);
        $scope = fget_string('scope', 255);
        
        $clientid = fsession_string('mail_oauth2_client_id');
        $secret = fsession_string('mail_oauth2_secret');
        $provider = fsession_string('mail_oauth2_provider');
        
        $HTMLHeader->META('robots', 'noindex, nofollow');
        $error_list = [];
        if (empty($clientid) || empty($secret) || empty($provider))
            $error_list[] = ___('No direct access is allowed without initialization');        
        if (empty($code) || empty($state) ) // || empty($scope)
            $error_list[] = ___('Missing OAuth parameters. No direct access allowed.');
        if (empty($_SESSION['mail_oauth2_state']))
            $error_list[] = ___('OAuth2 State was not specified yet. Please return to the backend email setup in the administration area.');
        elseif (!($CurrentUser->authenticated() && $CurrentUser->getCurrentUserID() > 0))
            $error_list[] = ___('You are not logged in');
        elseif (!$CurrentUser->hasAdministrationPermission())         
            $error_list[] = ___('Current logged in user must have access to the administration area');       
        $url = SCHLIX_SITE_URL. $_SERVER['REQUEST_URI'];
        $this->logInfo("Received URL = {$url}");
        
        if (!empty($error_list))
        {                        
            $combo_msg = implode(", ", $error_list);
            $this->logError("Error trying to complete OAUTH setup {$combo_msg}");
            $local_variables = compact(array_keys(get_defined_vars()));
            $this->loadTemplateFile('view.main', $local_variables, true);
        } else 
        {
            try 
            {
                $arr_oauth_provider_info = $this->getOAuthProviderObject($provider, $clientid, $secret);
                $oauth_provider = $arr_oauth_provider_info['provider'];
                
                $token = $oauth_provider->getAccessToken('authorization_code', ['code' => $code]);
                $refresh_token = $token->getRefreshToken();
                $_SESSION['mail_oauth2_setup_success'] = true ;
                $_SESSION['mail_oauth2_refresh_token'] = $refresh_token ;
                $_SESSION['mail_oauth2_debug']  = var_export($token, true); // json_encode($token, JSON_PRETTY_PRINT);
                $this->logInfo("Received refresh token {$refresh_token}, now redirecting to admin to complete setup");
                
            } catch (\Exception $ex) {

                $msg = $ex->getMessage();
                $_SESSION['mail_oauth2_error'] = $msg.' '.$ex->getTraceAsString().' '.$ex->getCode();
                $_SESSION['mail_oauth2_setup_success'] = false ;
            }
            //print_r($token);die;
            $this->redirectToAdminURL();
            
            
        }
        
        return true;
    }
    /**
     * URL redirect
     * @return string
     */
    public function getURLRedirect()
    {
        return SCHLIX_SITE_URL.$this->createFriendlyURL('');
    }

} 