<?php
/**
 * Core - Editor Manager - Edit Item Template
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');
?>
<?php

global $SystemConfig, $CurrentUser, $WYSIWYGEditor;

if ((int) $id > 0)
{
    $editor_name = \App\Core_EditorManager::getClassNameByProfileID($id);
    $header_title = ___('Edit Item').' #'.___h($id);
} else
{
    $editor = $WYSIWYGEditor->getWysiwygEditorByName(fget_string('editorname'));
    if ($editor)
        $editor_name = $editor['title'];
    else die('Editor not found');
}
?>


<x-ui:schlix-data-editor id="schlix-<?= $this->app_name ?>-admin" class="schlix-data-editor" data-schlix-controller="SCHLIX.CMS.Core_EditorManagerAdminController" data-model="<?= $this->getDataModelURL() ?>"  data-main-app-description="<?= $this->app->getOriginalApplicationDescription() . ': ' . $header_title ?>"  data-field-id="<?= $this->app->getFieldID() ?>" data-cancel-warning="true">    

    <x-ui:schlix-editor-form id="wysiwyg_item_editor" method="post" action="<?= $this->createFriendlyAdminURL('action=saveitem') ?>" enctype="multipart/form-data" >

        <x-ui:csrf id="_csrftoken" />
        <x-ui:hidden name="id" id="id" value="<?= ___h($id) ?>" />

        <x-ui:schlix-editor-top-row>    
            <x-ui:schlix-editor-top-left>
                <!-- Page Title -->
                <x-ui:form-group>
                    <x-ui:label for="title"><?= ___('Profile Name') ?></x-ui:label>
                    <x-ui:input-group>
                        <!-- title -->
                        <x-ui:textbox name="title" id="title" type="text" maxlength="254"  required="required"   data-field="title" <?= $item['is_system'] ? 'readonly="readonly"' : '' ?> /> 
                       <!-- is_system -->
                       <?php if ($item['is_system']): ?>
                           <x-ui:input-group-addon>
                               <?= ___('System Profile'); ?>
                           </x-ui:input-group-addon>
                       <?php endif; ?>                            
                       <!-- end is_system -->

                    </x-ui:input-group>
                </x-ui:form-group>
                
                <x-ui:schlix-document-virtual-filename id="virtual_filename" data-field="virtual_filename" label="<?= ___('Profile Short Code Name'); ?>" />

            </x-ui:schlix-editor-top-left>
            <x-ui:schlix-editor-top-right>
                <x-ui:schlix-editor-action-buttons />
            </x-ui:schlix-editor-top-right>            
        </x-ui:schlix-editor-top-row>

        <br />
        <!-- main -->
        <x-ui:clearboth />

        <x-ui:schlix-document-save-result />
        <!-- end main section -->

        <!-- begin tabs -->
        <x-ui:schlix-tab-container>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_macro_config" fonticon="far fa-file-alt" label="<?= ___('Editor Configuration') ?>"> 

                    <div class="schlix_editor_main">
                        <?=  \SCHLIX\cmsConfigRegistry::loadConfigFile('wysiwygeditors', $item, $editor_name, $item['virtual_filename']);  ?>
                    </div>


            </x-ui:schlix-tab>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_permissions" fonticon="fa fa-users" label="<?= ___('Permissions') ?>">     
 
                <x-ui:schlix-permission-read id="permission_read" data-field="permission_read"  />
                <x-ui:schlix-permission-write id="permission_write" data-field="permission_write"  />
            </x-ui:schlix-tab>                


        </x-ui:schlix-tab-container>            
        <!-- end tabs -->
    </x-ui:schlix-editor-form>
</x-ui:schlix-data-editor> 
