<?php
/**
 * Core - Editor Manager - Config
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die('No Access');
?>
<?php
global $SystemConfig, $CurrentUser;
$all_wysiwyg_profiles = \App\Core_EditorManager::getAllWysiwygProfiles();

?>
<schlix-config:data-editor   data-schlix-controller="SCHLIX.CMS.Core_EditorManagerAdminController">

<!-- end sidebar -->
        <schlix-config:save-result />
        <x-ui:schlix-editor-form id="form-edit-config" method="post" data-config-action="save" action="<?= $this->createFriendlyAdminURL('action=saveconfig') ?>" autocomplete="off">

            <schlix-config:action-buttons />
            <x-ui:csrf />

            <x-ui:schlix-tab-container>
                <x-ui:schlix-tab id="tab_general" fonticon="far fa-file" label="<?= ___('General') ?>">     
                    <!-- row -->
                    <h3><?= ___('Default WYSIWYG Editor Profiles') ?></h3>
                    <!-- row -->
                    <x-ui:row>
                        <x-ui:column sm="6">
                            <schlix-config:dropdownlist   config-key="int_default_full_privilege_wysiwyg_profile_id" label="<?=  ___('Full privilege (backend and frontend)') ?>">
                            <?php foreach ($all_wysiwyg_profiles as $profile): ?>
                                <schlix-config:option value="<?= $profile['id'] ?>"><?= ___h('#'.$profile['id'].' '.$profile['editor_name'].': '.$profile['title'].' ('.$profile['virtual_filename'].')') ?> </schlix-config:option>
                            <?php endforeach ?>
                            </schlix-config:dropdownlist>
                            
                            <schlix-config:dropdownlist   config-key="int_default_limited_privilege_wysiwyg_profile_id" label="<?=  ___('Limited privilege (frontend application)') ?>">
                            <?php foreach ($all_wysiwyg_profiles as $profile): ?>
                                <schlix-config:option value="<?= $profile['id'] ?>"><?= ___h('#'.$profile['id'].' '.$profile['editor_name'].': '.$profile['title'].' ('.$profile['virtual_filename'].')') ?> </schlix-config:option>
                            <?php endforeach ?>
                            </schlix-config:dropdownlist>
                            
                        </x-ui:column>
                    </x-ui:row>
                </x-ui:schlix-tab>                
                
                <!-- tab -->
                <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditConfigTab', $this) ?>  
                <!-- end -->
            </x-ui:schlix-tab-container>
            
        </x-ui:schlix-editor-form>
</schlix-config:data-editor>    