<?php
/**
 * Core: CronScheduler - Main admin view template
 * 
 * Core - CronScheduler
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();
?>
<x-ui:schlix-explorer-sub-application-header />
<x-ui:schlix-data-explorer-list data-schlix-controller="SCHLIX.CMS.Core_CronSchedulerAdmin" data-enable-preview-link="true" >
 
        <!-- Toolbar -->
        <x-ui:schlix-explorer-toolbar>
            <x-ui:schlix-explorer-toolbar-menu data-position="left">    
                <x-ui:schlix-explorer-menu-command data-schlix-command="new-item" data-schlix-app-action="newitem"   fonticon="far fa-clock text-blue" label="<?= ___('New Scheduled Task') ?>" />
                
                <x-ui:schlix-explorer-menu-command data-schlix-command="copy" require-selected-items="1" fonticon="fa fa-copy" label="<?= ___('Copy') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="paste" require-clipboard-items="1" fonticon="far fa-clipboard" label="<?= ___('Paste') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="delete" require-selected-items="1" fonticon="far fa-trash-alt" label="<?= ___('Delete') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="config" data-schlix-app-action="editconfig"  fonticon="fas fa-cog text-slategray" label="<?= ___('Configuration') ?>" />
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
            </x-ui:schlix-explorer-toolbar-menu>
            <x-ui:schlix-explorer-toolbar-search />
            <x-ui:schlix-explorer-toolbar-menu data-position="right">
                <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                    <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
                </x-ui:schlix-explorer-menu-folder>
            </x-ui:schlix-explorer-toolbar-menu>

            
        </x-ui:schlix-explorer-toolbar>
        <!-- breadcrumb -->
        <x-ui:schlix-explorer-breadcrumb />        
        <!-- data viewer -->        
        <x-ui:schlix-explorer-row>
            <!-- Right Column -->
            <x-ui:schlix-explorer-right-column>
                <!-- datatable -->
                <x-ui:schlix-data-table schlix-id="datanav-datatable" >

                    <x-ui:schlix-data-table-columns>
                        <x-ui:schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="this.formatDataTableCell_CheckBox" sortable="false" />
                        <x-ui:schlix-data-table-column key="this.field_id" label= "<?= ___('ID') ?>" hidden="false" sortable="false" formatter="number" />                        
                        <x-ui:schlix-data-table-column key="this.field_item_title" sortable="true" label= "<?= ___('Job Name') ?>" formatter="text" editor="new SCHLIX.UI.TextboxCellEditor({disableBtns:false})"/>
                        <x-ui:schlix-data-table-column key="cron" sortable="true" label= "<?= ___('CRON String') ?>" formatter="SCHLIX.CMS.Core_CronSchedulerAdmin.formatCronString" />
                        <x-ui:schlix-data-table-column key="command_type" sortable="true" label= "<?= ___('Command Type') ?>" formatter="SCHLIX.CMS.Core_CronSchedulerAdmin.formatCommandType" editor='new SCHLIX.UI.RadioCellEditor({radioOptions:command_type_array,disableBtns:false})' />
                        <x-ui:schlix-data-table-column key="command_internal" sortable="true" label= "<?= ___('Internal Command') ?>" formatter="SCHLIX.CMS.Core_CronSchedulerAdmin.formatInternalCommand" editor="new SCHLIX.UI.DropdownCellEditor({dropdownOptions:_internal_class_method_choices,disableBtns:false})" />
                        <x-ui:schlix-data-table-column key="command_external_url" sortable="true" label= "<?= ___('External URL') ?>" formatter="SCHLIX.CMS.Core_CronSchedulerAdmin.formatExternalURL" editor="new SCHLIX.UI.TextboxCellEditor({disableBtns:false})" />

                        <x-ui:schlix-data-table-column key="status" label="<?= ___('Status') ?>" sortable="true" formatter="this.formatDataTableCell_Status" editor="new SCHLIX.UI.DropdownCellEditor({dropdownOptions:[{value:0, label: 'Inactive'}, {value:1, label: 'Active'} ],disableBtns:false})" />


                        <x-ui:schlix-data-table-column key="date_available" label="<?= ___('Start Date') ?>" sortable="true" formatter="this.formatDataTableCell_Date"  editor="new SCHLIX.CMS.DateCellEditor({disableBtns:false})" />
                        <x-ui:schlix-data-table-column key="date_expiry" label="<?= ___('End date') ?>" sortable="true" formatter="this.formatDataTableCell_Date" editor="new SCHLIX.CMS.DateCellEditor({disableBtns:false})" />
                        <x-ui:schlix-data-table-column key="date_modified" label="<?= ___('Date Modified') ?>" sortable="true" formatter="this.formatDataTableCell_Date" />
                        <x-ui:schlix-data-table-column label="<?= ___('View Log') ?>" sortable="true"  formatter="SCHLIX.CMS.Core_CronSchedulerAdmin.formatViewLog" />
                    </x-ui:schlix-data-table-columns>
                </x-ui:schlix-data-table>
                <!-- pagination -->
                <x-ui:schlix-explorer-pagination />
                <!-- end column -->
            </x-ui:schlix-explorer-right-column>
        </x-ui:schlix-explorer-row>
        <!-- End Data Viewer -->
</x-ui:schlix-data-explorer-list>


<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ Log Dialog ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->

<x-ui:schlix-cms-common-dialog id="schlix-cms-logviewer-dialog" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.Core_CronSchedulerAdmin" data-button-submit-id="btn-install-ok" data-button-cancel-id="btn-dialog-cancel" header-label="<?= ___("View Log"); ?>">

    <div id="message-container">

        <div id="message-content">
            <!-- content goes here -->
        </div>
    </div>
    <hr />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-dialog-cancel" fonticon="fa fa-times" label="<?= ___('Close') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>