/**
 * Core: CronScheduler - Javascript admin controller class
 * 
 * Core - CronScheduler 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
var _cronSchedulerAppMethodsArray = [];

/**
 * View Controller class
 */
SCHLIX.CMS.Core_CronSchedulerAdmin = class extends SCHLIX.CMS.BaseController  {  
    /**
     * Constructor
     */
    constructor ()
    {
        super("core.cronscheduler");
    }
    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */

    static formatDataTableCell_ViewLog  (elCell, oRecord, oColumn, oData) {

        var odata_id = oRecord.getData("id");
        if (oData === undefined)
        {
            elCell.innerHTML = "Invalid column!";
            return;
        }
        //  alert(this.parentControl.getTableFieldNameByRole('title'));
        var itemTitle = oData;// oRecord.getData("title");
        var itemLink = '';
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';
        var app_name = this.parentControl.app_name;

        var the_id = oRecord.getData("id");
        var theValue = 'i' + the_id;
        if (itemTitle == '')
            itemTitle = '(Untitled)';
        //itemLink = _schlix_app_controller + oColumn.app_name + '&action=edititem&id=' + oRecord.getData("id");
        var icon = "<i class =\"far fa-file-alt fa-2x\"></i>";
        // var checkbox = '<input type="checkbox" class="selections" value="' + theValue + '"  />';            
        itemLink = this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
        elCell.innerHTML = '<a class="open-viewlog" id="' + app_name + "-lnk-" + theValue + '" data-log-id="' + theValue + '" href="javascript:void(0)" data-log-message="' + oData + '">' + " " + icon + " " + itemTitle + '</a>';
    };

     ///////////////////////////////////////////////////////////
    static formatCommandType  (elCell, oRecord, oColumn, oData)
    {
        var command_type;

        switch (oData)
        {
            case 1:
                command_type = 'external URL';
                break;
            default:
                command_type = 'internal';
                break;
        }
        elCell.innerHTML = command_type;
    };
    ///////////////////////////////////////////////////////////
    static formatCronString  (elCell, oRecord, oColumn, oData)
    {
        var selectbox = '<select class="form-control reset-cron" data-cron-id="' + oRecord.getData('id') + '" />';
        var date_next_expected_run = oRecord.getData('date_expected_next_run');
        var str_date = "Next expected run: " + date_next_expected_run;
        for (var i = 0; i < _common_cron_settings.length; i++)
        {
            var selected = (oData == _common_cron_settings[i].value) ? ' selected="selected"' : "";
            selectbox += '<option value="' + _common_cron_settings[i].value + '"' + selected + '>' + _common_cron_settings[i].label + '</option>';
        }
        selectbox += '</select>';

        elCell.innerHTML = oData + selectbox + '<br />' + str_date;
    };
    ///////////////////////////////////////////////////////////
    static formatInternalCommand  (elCell, oRecord, oColumn, oData)
    {
        var command = (oRecord.getData("command_type") == 1) ? "N/A" : oData;
        elCell.innerHTML = command;
    };
    ///////////////////////////////////////////////////////////
    static formatExternalURL  (elCell, oRecord, oColumn, oData)
    {
        var command = (oRecord.getData("command_type") == 1) ? oData : "N/A";
        elCell.innerHTML = SCHLIX.Util.escapeHTML(command);        
    };

    static formatViewLog  (elCell, oRecord, oColumn, oData)
    {
        var id = oRecord.getData("id");
        var icon = '<i class="fa fa-eye"></i> ';
        elCell.innerHTML = '<a class="open-viewlog" data-cron-id="' + id + '">' + icon + ' View Log</a>';
    };

    onDOMReady ()
    {
        SCHLIX.Event.delegate('schlix-core-cronscheduler-admin', 'change', this.resetCronString, 'select.reset-cron', this, true);
        SCHLIX.Event.delegate('schlix-core-cronscheduler-admin', 'click', this.onShowViewLogDialog, 'a.open-viewlog', this, true);
    }; // end func
    ///////////////////////////////////////////////////////////
    resetCronString (e)
    {
        var el = SCHLIX.Dom.get(e.target.id);
        var id = el.getAttribute('data-cron-id');
        var value = el.selectedIndex; // getAttribute('data-value');

        var oRecord = (id == "new") ? "new" : 'i' + id;
        var cronstring = _common_cron_settings[value].value ;
        var postData = "_csrftoken=" + _csrftoken + '&id=' + oRecord + '&field=cron&value=' + cronstring;
        //this.ajaxRequestPOST(this.reportPOSTOperation, this.getUpdateFieldURL(), postData, 'cronscheduler');   


        var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/" + this.app_name + "?action=updatefield",
                {success: this.onCronStringReset, failure: this.handleFailure, scope: this}, postData);


    }; // end func
    onCronStringReset(o)
    {
        var response = ajax_parse(o.responseText);
        if (response === 'OK')
        {
            SCHLIX.Alert.info('CRON string updated');
        }
        else
            alert(response);
        
    }; // end func
///////////////////////////////////////////////////////////
    onReceiveLog (o)
    {
        var log = ajax_parse(o.responseText);

        var obj = SCHLIX.CMS.getObject('schlix-cms-logviewer-dialog');
        var message_content = SCHLIX.Dom.get('message-content');
        message_content.innerHTML = this.formatTable(log);
        message_content.style.maxHeight = '300px';
        message_content.style.overflow = 'scroll';
        obj.show();
    }; // end func
    onShowViewLogDialog (e)
    {
        var el = SCHLIX.Dom.get(e.target.id);
        var tgt_cron_id = el.getAttribute('data-cron-id');
        //this.ajaxRequestGET(this.receiveLog, "action=getcronlog&id=" + tgt_cron_id);
        var request = SCHLIX.Ajax.GET( site_httpbase + "/admin/app/" + this.app_name + "?action=getcronlog&id=" + tgt_cron_id,
                {success: this.onReceiveLog, failure: this.handleFailure, scope: this}
        );
    }; // end func
    formatTable (objArray, theme, enableHeader)
    {
        // set optional theme parameter
        if (theme === undefined) {
            theme = 'table'; //default theme
        }

        if (enableHeader === undefined) {
            enableHeader = true; //default enable headers
        }

        // If the returned data is an object do nothing, else try to parse
        var array = typeof objArray != 'object' ? JSON.parse(objArray) : objArray;

        var str = '<table class="' + theme + '">';

        // table head
        if (enableHeader) {
            str += '<thead><tr>';
            for (var index in array[0]) {
                str += '<th scope="col">' + index + '</th>';
            }
            str += '</tr></thead>';
        }

        // table body
        str += '<tbody>';
        for (var i = 0; i < array.length; i++) {
            str += (i % 2 == 0) ? '<tr class="alt">' : '<tr>';
            for (var index in array[i]) {
                str += '<td>' + array[i][index] + '</td>';
            }
            str += '</tr>';
        }
        str += '</tbody>';
        str += '</table>';
        return str;
    }; // end func
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'new-item':
                this.cms_control.insertNewItem();
                break;
            case 'config':
                this.redirectToCMSCommand("editconfig");
                break;
                
            default:
                return super.runCommand(command, evt);
        }
    } // end func
}; // end class
