<?php
namespace App;

/**
 * Core: Composer - Admin class
 * 
 * Core - Composer
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_Composer_Admin extends \SCHLIX\cmsAdmin_List {

    /**
     *
     * @var \App\Core_Composer 
     */
    protected $app;
    /**
     * Constructor
     * @global \SCHLIX\cmsDatabase $SystemDB
     */    
    public function __construct() {
        global $SystemDB;
        
        // Data: Item
        parent::__construct(true, array());
        // You can enable more items here                
        $this->setItemFieldNamesForAjaxListing('id', 'title',  'date_created','status','sort_order');
    }
    
    /**
     * Modify data before save item
     * @global \App\Users $CurrentUser
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues) {
        global $CurrentUser;
        
        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);
        
        $current_admin_id = $CurrentUser->getCurrentUserID();
        $field_admin_id = ($datavalues['id'] == 'new') ? 'created_by_id' : 'modified_by_id';
        $datavalues[$field_admin_id] = isset($datavalues[$field_admin_id]) ? (int) $datavalues[$field_admin_id] : 0;
        if (!($datavalues[$field_admin_id] > 0 && $datavalues[$field_admin_id] != $current_admin_id))
            $datavalues[$field_admin_id] = $current_admin_id;
        $datavalues['virtual_filename'] = convert_into_sef_friendly_title($datavalues['virtual_filename'], true);
        if (empty($datavalues['meta_description']))
            $datavalues['meta_description'] = $datavalues['title'];
        if (empty($datavalues['virtual_filename']) || ($datavalues['virtual_filename'] == 'index'))
            $datavalues['virtual_filename'] = 'item' . $datavalues[$this->field_id];

        $datavalues['options'] = serialize($datavalues['options']);
        $datavalues['featured'] = intval($datavalues['featured']);

        
        return $datavalues;
    }
    
    public function viewIframeComposerProgress()
    {
        $count = $this->app->countOfPendingInstall();
        if ($count > 0)
        {            
            require_once('view.install.progress.template.php');
            
        }
        return false;
        
    }
    
    /**
     * Call this from your view.main.admin if you expect composer install
     */
    public static function displayComposerInstallProgress()
    {
            $app = new Core_Composer_Admin();            
            $app->viewComposerInstall();
    }
    
    /**
     * View composer install iframe window
     * @return boolean
     */
    public function viewComposerInstall()
    {

        $count = $this->app->countOfPendingInstall();
        if ($count > 0)
        {
            $this->loadTemplateFile('view.install.placeholder' , null);
            
        }
    }
    
    public function Run()
    {
        switch (fget_alphanumeric('action'))
        {
            case 'installprogress': 
                return $this->viewIframeComposerProgress();
            default:return parent::Run();
        }
        
    }
    
}
