<?php
namespace App;

/**
 * Core: BannedIP - Admin class
 * 
 * Core - BannedIP
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_BannedIP_Admin extends \SCHLIX\cmsAdmin_List {

    /**
     *
     * @var Core_BannedIP
     */
    protected $app;
    
    /**
     * Constructor
     */
    public function __construct() {
        // Data: Item
        parent::__construct(true, array());
        // You can enable more items here        
        $this->setItemFieldNamesForAjaxListing('id', 'ip_address', 'reason', 'date_created', 'date_expiry');
    }

    //_________________________________________________________________________//
    public function createNewBan() {
        $banning_myself = (get_user_real_ip_address() == fpost_string('ip_address'));
        if ($banning_myself) {
            return ajax_reply(100, 'Cannot ban yourself!');
        } else {
            $result = $this->app->banIP(fpost_string('ip_address'), fpost_string('reason')); // no need to check sql injection here - already in the app
            return ($result == true) ? ajax_reply(200, 'OK') : ajax_reply(100, 'Cannot ban this IP address - invalid IPv4/IPv6/hostname');
        }
    }
    
    public function ajxp_Ban()
    {
        $error_list = [];
        $ip_addr = trim(fpost_string('ip_address'));
        $reason = trim(fpost_string('reason'));
        $hours = fpost_int('hours');
        $banning_myself = (get_user_real_ip_address() == $ip_addr);
        $valid_ip = filter_var($ip_addr, FILTER_VALIDATE_IP);
        if (!$valid_ip)
            $error_list[] = ___('Invalid IP address');
        if ($hours <= 0 || $hours > 999999)
            $error_list[] = ___('Ban length must be between 1 and 999999 hours');
        
        if (empty($error_list))            
        {
            $result = $this->app->banIP($ip_addr, $reason, $hours); // no need to check sql injection here - already in the app
            
            return ($result == true) ? ajax_reply_ok('OK') : ajax_reply_error('Cannot ban this IP address e');
        } else 
        {
            return ajax_reply_error($error_list);
        }
        /*
        if ($banning_myself) {
            return ajax_reply(100, 'Cannot ban yourself!');
        } else {
            $
            return ($result == true) ? ajax_reply(200, 'OK') : ajax_reply(100, 'Cannot ban this IP address - invalid IPv4/IPv6/hostname');
        }
        */
    }

    //_________________________________________________________________________//
    public function Run() {
        switch (fget_alphanumeric('action')) {
            case 'xban':return ajax_echo($this->createNewBan());
                break;
            default:return parent::Run();
        }
    }
    
}
