<?php
/**
 * Core: Application Manager - Main admin view template
 * 
 * Core - Application Manager
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();
?>
<?php $app = alpha_numeric_with_dash_underscore($this->app->getOriginalFullApplicationAlias());

$custom_apps = [['label'=> ___('Extension Gallery'), 'title' => 'core.extgallery']];
?>
<div class="schlix-explorer">
    <schlix-data-explorer-blank id="schlix-<?= $app ?>-admin" class="schlix-data-explorer"  data-schlix-controller="SCHLIX.CMS.Core_ApplicationManagerAdminController" data-main-app-description="<?= $this->app->getOriginalApplicationDescription() ?>" data-app="<?= $this->app->getOriginalApplicationDescription() ?>" data-model="<?= $this->getDataModelURL() ?>">
 
        <x-ui:schlix-explorer-toolbar>
            <x-ui:schlix-explorer-toolbar-menu data-position="left">    
                
                <x-ui:schlix-explorer-menu-command data-schlix-command="config" data-schlix-app-action="editconfig"  fonticon="fas fa-cog text-slategray" label="<?= ___('Configuration') ?>" />
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
                <x-ui:schlix-explorer-menu-command data-schlix-command="install" fonticon="fa fa-upload" label="<?= ___('Install a package') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="other-application" application="core.extgallery" fonticon="fas fa-puzzle-piece text-purple" open-new-window="1"  label="<?= ___('Download more extensions') ?>" />
            </x-ui:schlix-explorer-toolbar-menu>
            <x-ui:schlix-explorer-toolbar-menu data-position="right">
                <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                    <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
                </x-ui:schlix-explorer-menu-folder>
            </x-ui:schlix-explorer-toolbar-menu>

            
        </x-ui:schlix-explorer-toolbar>              
     <?php \App\Core_Composer_Admin::displayComposerInstallProgress() ?>

        <!-- Begin Data Viewer -->
        <x-ui:row schlix-id="main-data-container" class="schlix-cms-data-gallery-row">
            <?php foreach ($custom_apps as $plugin_app): ?>
                <x-ui:column xs="6" sm="3" md="2" lg="2" class="schlix-cms-data-gallery-column">                    
                     <div class="text-center schlix-app-old" >
                         <a href="<?= SCHLIX_SITE_HTTPBASE.'/admin/app/'.$plugin_app['title'] ?>">
                             <img src="<?= \App\Core_ApplicationManager::getApplicationIcon($plugin_app['title']) ?>" border="0" alt="<?= ___h($plugin_app['title']) ?>" /><br />
                            <?= ___h($plugin_app['label']) ?>

                         </a>
                     </div>                    
                </x-ui:column>
            
            <?php endforeach ?>
                <?php $apps = $this->app->getAllItems('*','show_in_app_menu = 1'); ?>
                <?php foreach ($apps as $plugin_app): ?>
                    <?php $css_class = time_difference($plugin_app['date_modified'], get_current_datetime()) < 30000 ? 'schlix-app-new' : 'schlix-app-old'; // indicate old/newly installed app ?>
                    <x-ui:column xs="6" sm="3" md="2" lg="2" class="schlix-cms-data-gallery-column">                    
                         <div class="text-center <?= $css_class ?>" >
                             <a href="<?= SCHLIX_SITE_HTTPBASE.'/admin/app/'.$plugin_app['title'] ?>">
                                 <img src="<?= \App\Core_ApplicationManager::getApplicationIcon($plugin_app['title']) ?>" border="0" alt="<?= ___h($plugin_app['title']) ?>" /><br />
                                <?= ___h($plugin_app['title']) ?>
                                 
                             </a>
                         </div>                    
                    </x-ui:column>
                <?php endforeach; ?>
                
        </x-ui:row>
        <!-- End Data Viewer -->
        </schlix-data-explorer-blank>
</div>

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~ Install Dialog ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<x-ui:schlix-cms-common-dialog id="schlix-cms-package-installer" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.Core_ApplicationManagerAdminController" header-label="<?= ___('Install a package') ?>" data-button-submit-id="btn-install-ok" data-button-cancel-id="btn-install-cancel" data-action="action=install" form-method="post" >
    <!-- form -->
    <x-ui:csrf />
    <x-ui:alert type="warning">
        <p><?= ___('Please ensure that the application you are about to upload is from a trusted source') ?>.</p>
        <p><?= ___('SCHLIX is not responsible for any damage/security vulnerability/errors caused by 3rd party plugins') ?>.</p>
        <p><?= ___('Maximum file size') . ': ' . ' ' . round(get_real_max_upload_size() / (1024.0 * 1024.0), 2) . ' ' . ___('Mb') ?></p>
    </x-ui:alert>

    <x-ui:schlix-file-upload id="zipfileupload"  name="zipfileupload" accept=".zip" required="required" fonticon="far fa-folder-open" label="<?= ___('Select a ZIP file') ?>" />

    <x-ui:clearboth />
    <x-ui:checkbox name="install_sample_data" id="install_sample_data" value="1" label="<?= ___('Install sample data if available') ?>" />
    <hr />
    <x-ui:textbox type="password" name="password" id="password" label="<?= ___('Please enter your password to authenticate this request') ?>" fonticon="fas fa-lock" />
    <x-ui:schlix-cms-dialog-button-submit id="btn-install-ok" fonticon="fa fa-upload" label="<?= ___('Go') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-install-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>