<?php
namespace App;
/**
 * Core: Application Manager - Main Class
 * 
 * Core - Application Manager
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_ApplicationManager extends \SCHLIX\cmsApplication_List {

    /**
     * Constructor
     * @global \SCHLIX\cmsDatabase $SystemDB
     */
    public function __construct()
    {
		parent::__construct( ___('Application Manager'), 'gk_app_items','');
                $this->disable_frontend_runtime = true;
    }
    //_________________________________________________________________________//

    public function viewMainPage()
	{
		return false;
	}
    /**
     * Returns full application info by app name
     * @param string $app_name
     * @return array
     */
    public function getItemByAppName($app_name)
    {
        $sanitized_app_name = sanitize_string($app_name);

        $items = $this->getAllItems('*', "title = {$sanitized_app_name}");
        return (is_array($items) && (___c($items) === 1)) ? $items[0] : null;
    }
    /**
     * Returns application list which can be shown in the backend
     * @return array
     */
    public function get3rdPartyApplicationList()
    {
            return $this->getAllItems('*','has_backend = 1 AND show_in_app_menu = 1', 0, 1000, 'app_description');
    }
    
    /**
     * Returns the application icon URL path
     * @param string $app
     * @return string
     */
    public static function getApplicationIcon($app)
    {
        $master_app = $sub_app = '';
        $search_icons = [];
        if ((str_contains($app, ".")))
        {
            $appparts = explode('.', $app);
            $master_app = strtolower(alpha_numeric_with_dash_underscore($appparts[0])); 
            $sub_app = strtolower(alpha_numeric_with_dash_underscore($appparts[1]));
            $search_icons =  [
                        "/apps/{$master_app}/{$sub_app}/{$sub_app}_logo.png",
                        "/apps/{$master_app}/{$master_app}_logo.png"
                    ];
        } else 
        {
            $master_app = $app;
            $search_icons = ["/apps/{$master_app}/{$master_app}_logo.png"];
        }
        $search_folders = [CURRENT_SUBSITE_PATH => CURRENT_SUBSITE_URL_PATH, SCHLIX_SYSTEM_PATH => SCHLIX_SYSTEM_URL_PATH];                
        foreach ($search_folders as $folder => $url) foreach ($search_icons as $app_icon) if (is_file($folder.$app_icon)) return $url.$app_icon;        
        return null;
        
    }
    
    /**
     * Returns package info for a package, where type can be macro, block, or app
     * @param string $type
     * @param string $app
     * @return array
     */
    public static function getPackageInfo($type,$app)
    {
        $app_package_info = $type.'s/'.$app.'/packageinfo.inc.php';
        if (file_exists (CURRENT_SUBSITE_PATH.'/'.$app_package_info))
                $app_package_info_file = CURRENT_SUBSITE_PATH.'/'.$app_package_info;
        elseif (file_exists (SCHLIX_SYSTEM_PATH.'/'.$app_package_info))
                $app_package_info_file = SCHLIX_SYSTEM_PATH.'/'.$app_package_info;
        else
            return NULL;
        // file size must be small, no more than 2KB
        if (filesize($app_package_info_file) <= 2048)
        {
            $package_info = [];
            $file_content = file ($app_package_info_file);
            foreach ($file_content as $line)
            {
                if ($line)
                {
                    preg_match_all('#\$((?:[a-z][a-z0-9_]*))\s?=\s?\'(.*)\';#iU', $line, $matches);
                    $match_count = ___c($matches[0]);                    
                    if ($match_count > 0) 
                    {
                        $package_info[$matches[1][0]] = $matches[2][0];
                    }                    
                }
            }
            return $package_info;
        }
            
        return null;
    }
    //_________________________________________________________________________//
    public function getAllApplicationList()
    {        
        return $this->getAllItems('*','has_backend = 1 ');
    }

    /**
     * Returns a list of possible sub-application for an application
     * @param string $app
     * @return array
     */
    public function getAllSubApplications($app)
    {
        $sub_apps = [];
        $itm = $this->getItemByAppName($app);
        if ($itm)
        {
            $app_name = strtolower($app);
            $main_dirs = [SCHLIX_SYSTEM_PATH . '/apps/'. $app_name.'/' , SCHLIX_SITE_PATH . '/apps/' . $app_name.'/'];
            foreach ($main_dirs as $main_dir)
            {                
                $dirs = \SCHLIX\cmsDirectoryFilter::getDirectoryIterator($main_dir, \SCHLIX\cmsDirectoryFilter::FILTER_DIR_ONLY);
                if ($dirs)
                {
                    foreach ($dirs as $d)
                    {
                        $full_path =  $d->getPathName();
                        $class_name = $app_name.'.'.$d->getFileName().'.class.php';
                        
                        if (file_exists($full_path.'/'.$class_name))                            
                        {
                            $sub_apps[] = $d->getFileName();
                        }
                    }                    
                }
                $files = \SCHLIX\cmsDirectoryFilter::getDirectoryIterator($main_dir, \SCHLIX\cmsDirectoryFilter::FILTER_FILE_ONLY);
                if ($files)
                foreach ($files as $file)
                {
                    $filename = $file->getFileName();
                    if (str_starts_with($filename, $app_name.'.') && str_ends_with($filename, '.class.php'))
                    {
                        $str_app_len = strlen($app_name);
                        $str_fn_len = strlen($filename);
                        $tmp_subclass_name = substr($filename, $str_app_len + 1, $str_fn_len - $str_app_len);
                        
                        $pos = strpos($tmp_subclass_name, '.class.php');
                        if ($pos > 0)
                        {
                            $tmp_subclass_name = substr($tmp_subclass_name,0, $pos);
                            if(ctype_alnum($tmp_subclass_name) && $tmp_subclass_name != 'admin')
                            {
                                $sub_apps[] = $tmp_subclass_name;
                            }
                        }
                    }
                }
                if (___c($sub_apps) > 0)
                {
                    return array_unique($sub_apps);
                }
            }
        }
        return null;
    }
    
	
    //_________________________________________________________________________//
    public function setApplicationItemField($app_name, $field, $value)
    {
        global $SystemDB;

        $app_item = $this->getItemByAppName($app_name);
        $sanitized_app_name = sanitize_string($app_name);
        $sanitized_value= sanitize_string($value);
        $sanitized_field = alpha_numeric_with_dash_underscore($field);
        if ($app_item != null)
        {
            // update
            $sql = "UPDATE {$this->table_items} SET `{$sanitized_field}` = {$sanitized_value} WHERE title = {$sanitized_app_name}";
            $SystemDB->query($sql);
        } else
        {
            // insert
            if ( get_system_or_user_file("/apps/{$app_name}/{$app_name}.class.php") )
            {
                // update
                $sql = "INSERT INTO {$this->table_items} (title,`{$sanitized_field}`) VALUES ({$sanitized_app_name},{$sanitized_value})";
                $SystemDB->query($sql);
            }
        }

    }
    //_________________________________________________________________________//
    public function getApplicationAliasThatDoesNotConflictWithFileSystem($app_name,$alias)
    {
        $all_files_in_main_directory = scandir(SCHLIX_SITE_PATH);
        $i = 1;
        $final_alias = $alias;
        while (in_array($final_alias, $all_files_in_main_directory))
        {
            $final_alias = $alias.$i;
        }
        return ($app_name === $alias) ? $alias : $final_alias;
    }

    //_________________________________________________________________________//
    public function setApplicationAlias($app_name, $alias)
    {        
        $alias = trim ($alias);
        $app_name = trim ($app_name);
        if (empty($alias)) $alias = $app_name;
        
        $alias = convert_to_safe_basename($alias,63);        
        $final_name = $this->getApplicationAliasThatDoesNotConflictWithFileSystem($app_name,$alias);        
        $this->setApplicationItemField($app_name,'app_alias', $final_name);
        return $final_name;
    }
    //_________________________________________________________________________//
    public function setApplicationDescription($app_name, $description)
    {
        $description = trim ($description);
        $app_name = trim ($app_name);
        if (empty($description)) $description = ucwords ($app_name);
        $this->setApplicationItemField($app_name,'app_description', $description);
    }


}
