/**
 * Core: Application Manager - Javascript admin controller class
 * 
 * Core - Application Manager 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.Core_ApplicationManagerAdminController = class extends SCHLIX.CMS.BaseController
{
    constructor()
    {
        super("core.applicationmanager");
    };


    /**
     * Show Edit Category Dialog
     * @param {type} event
     * @returns {undefined}
     */
    showInstallerWindow ()
    {
        var obj = SCHLIX.CMS.getObject('schlix-cms-package-installer');
        obj.show();
    }; // end func
    
    
    submitForm ()
    {
        /* var obj = SCHLIX.CMS.getObject('schlix-cms-package-installer');
         var form = obj.__getFirstFoundForm();
         console.log(form);*/
        return RESOLVE_TO_PARENT;
    }; // end func

    onDOMReady (event)
    {
        //SCHLIX.Event.on('zipfileupload', 'change', this.previewFile, this, true);
    }; // end func
    ////////////////////////////////////////////////////////////
    
    previewFile ()
    {
        var file_input = document.getElementById('zipfileupload');
        var file_info = file_input.files[0];
        var file_name_placeholder = document.getElementById('zip_filename');
        var file_size_placeholder = document.getElementById('__file_size');
        var file_size_display=  document.getElementById('zip_filesize');
        
        file_size_placeholder.value = file_info.size;
        file_name_placeholder.innerHTML = '<i class="far fa-file-archive"></i> ' + file_info.name;
        
        var max_file_size = parseInt(document.getElementById('__max_file_size').value, 10);
        if (file_info.size > max_file_size)
        {
            var max_file_size_formatted = this.formatFileSize(max_file_size);
            SCHLIX.Alert.warning('File upload will fail since the file is larger than the maximum upload size on this server (' +max_file_size_formatted + ')');
        }
        
        file_size_display.innerHTML = '<strong>File size</strong>: ' + format_file_size(file_info.size);
    }; // end func
    /**
     * Run command
     * @param {type} command
     * @returns {unresolved}
     */
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'install':
                this.showInstallerWindow();
                break;
            case 'config':
                this.redirectToCMSCommand("editconfig");
                break;
            case 'form-submit-ok':
                location.reload();
                break;
            case 'dialog-submit':
                return this.submitForm();
                break;
            default:
                return super.runCommand(command, evt);
                break;
        }

    }
};

