<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

if (!defined('SCHLIX_VERSION'))
    die();

global $HTMLHeader;

$preset_name = fcookie_string('schlixcontact-name', 127); 
$preset_email = fcookie_string('schlixcontact-email', 255);  
$HTMLHeader->JAVASCRIPT_SCHLIX_UI();
$HTMLHeader->JAVASCRIPT_SCHLIX_CMS();
$this->JAVASCRIPT('contacts.js');
/**
 * Note: you can customize this contact form by copying the file to your theme
 * folder. e.g. /web/<your-subsite>/themes/<your-theme-name>/apps/contacts/
 * Please keep the field ID and name the same, otherwise it won't work
 */
?>
<div id="schlix-contact-form-id-<?= (int) $item['id'] ?>">    
    
    <x-ui:row>
        <x-ui:column sm="8">
            <div class="schlix-ajax-output"></div>
        </x-ui:column>
    </x-ui:row>
    
    
    <x-ui:form-simple-ajax data-action="<?= $this->createFriendlyURL('action=submitmessage') ?>" id="schlix-contact-form" class="contact_form" enctype="multipart/form-data">    
        
        <x-ui:csrf />
        <x-ui:hidden name="submitmessage" value="1" />
        <x-ui:hidden name="contact_id" id="schlixcontact-id" value="<?= ___h($item['id']) ?>" />

        <x-ui:container>
            <x-ui:row>
                <x-ui:column sm="8">

                    <x-ui:well size="sm">
                        <x-ui:row>
                            <x-ui:column sm="6">
                                
                                <x-ui:textbox id="schlixcontact-name" name="name" fonticon="fa fa-user" placeholder="<?= ___('Name') ?>" required="required" label="<?= ___('Name') ?>" value="<?= ___h($preset_name) ?>" />
                                <x-ui:textbox id="schlixcontact-email" name="email" fonticon="fa fa-envelope" placeholder="<?= ___('E-mail') ?>" required="required" label="<?= ___('E-mail') ?>" value="<?= ___h($preset_email) ?>" />                            
                                <x-ui:textbox id="schlixcontact-phone" name="phone" fonticon="fa fa-phone" placeholder="<?= ___('Phone') . ' (' . ___('optional') . ')' ?>" label="<?= ___('Phone') ?>" />
                                <?php 
                                /* NOTE to web designers: you don't actually need this code below, it's just as an example, you can 
                                 * simply edit this file, add the field name (that starts with xcf_ prefix itself, e.g.
                                 * <x-ui:textbox id="xcf_field_name" name="xcf_field_name" ..... />
                                 */ ?>
                                <?= \App\Core_CustomField::displayAllCustomFieldFormInput('gk_contact_messages'); ?>        

                            </x-ui:column>
                            <x-ui:column sm="6">
                                <x-ui:textbox id="schlixcontact-subject" name="subject" fonticon="fa fa-comment" placeholder="<?= ___('Subject') ?>" required="required" label="<?= ___('Subject') ?>" />
                                <x-ui:textarea id="schlixcontact-message" name="message" rows="5" placeholder="<?= ___('Type your message here') ?>" required="required" label="<?= ___('Message') ?>" />

                            </x-ui:column>
                        </x-ui:row>
                        <x-ui:row>
                            <x-ui:column sm="6">

                                <?php if ( $this->enable_captcha): ?>
                                    <x-ui:captcha id="verification_code" name="verification_code" required="required" title="<?= ___('Please enter a valid captcha') ?>" fonticon="far fa-hand-paper" input-group-size="large" data-no-label="1" />
                                <?php endif; ?>

                                
                            </x-ui:column>
                            <x-ui:column sm="6">
                                <x-ui:button button-type="ok" type="submit" data-form-submit="1" name="sendmail" id="schlixcontact-submit-button" value="Submit" label="<?= ___('Send') ?>" fonticon="fa fa-paper-plane" />
                            </x-ui:column>
                        </x-ui:row>
                    </x-ui:well>
                </x-ui:column>
            </x-ui:row>
        </x-ui:container>        
    </x-ui:form-simple-ajax>

</div>