////++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

class SCHLIXContactForm
{
    constructor()
    {
        SCHLIX.Event.onDOMReady(this.onDOMReady, this, true);
    };

    onDOMReady()
    {
        if (SCHLIX.Dom.get('s_c_h_l_i_x_contact_form'))
        {
            // for backward compatibility only, this is no longer in use
            SCHLIX.Event.on('s_c_h_l_i_x_contact_form','submit', this.submitMessage, this, true);
            console.warn('Warning - still using the old contact form template');
        }
    };

    //----------------------------------------------------------------------------------------------------------//
    /**
     * Parse SCHLIX CMS Ajax Reply
     */
    json_decode(jsonstr)
    {
        if (jsonstr.replace(/\s/g, "") != "")
        {
            //  var data = eval('('+jsonstr+')'); // no more
            try
            {
                var data = JSON.parse(jsonstr);
                return data;
            }
            catch (exc)
            {
                alert('JSON Decode error: ' + exc);
                return null;
            }
        } else
        {
            alert('SCHLIX AJAX Communication Error.\nServer returns an empty string. Please take a screenshot and e-mail technical support');
            return false;
        }
    };
    
    refreshWindow()
    {
        window.location.reload(true);
    }
    

    onMessageSubmitted(o)
    {
        var response = this.json_decode(o.responseText);
        if (response.status == 200)
        {
            var data = response.data;
            var err = SCHLIX.Dom.get('s_c_h_l_i_x_contact_result');
            err.className = '';
            err.classList.add('alert');
            err.classList.add('alert-success');
            err.innerHTML = '<p><i class="fa fa-check"></i> ' + data + '</p>';
            document.getElementById('s_c_h_l_i_x_contact_form').style.display = 'none';
            setTimeout(this.refreshWindow, 4000);
     
        } else if (response.status == 300)
        {
            
            var data = response.data;
            var err = SCHLIX.Dom.get('s_c_h_l_i_x_contact_result');
            err.className = '';
            err.classList.add('alert');
            err.classList.add('alert-danger');
            var str = '';
            for (var i =0;i < data.length;i++)
            {
                str+= '<p><i class="fa fa-exclamation-circle"></i> ' + data[i] + '</p>';
            }
            err.innerHTML = str;
        } else  
        {
            alert('Ajax error');
        }        
        
    }; // end func
///////////////////////////////////////////////////////////
    onMessageRejected (o)
    {
            var err = SCHLIX.Dom.get('s_c_h_l_i_x_contact_result');
            err.className = '';
            err.classList.add('alert');
            err.classList.add('alert-danger');
            err.innerHTML = '<p><i class="fa fa-exclamation-circle"></i> Message cannot be submitted</p>';        
    }; // end func
    
    submitMessage(e)
    {
        var valid = false;
        var form = SCHLIX.Dom.get('s_c_h_l_i_x_contact_form');
        if(!form.checkValidity()) {
            e.preventDefault();
            e.stopPropagation();
            return false;
            // show validation errors
        } else
        {
            var input_name = document.getElementById('schlixcontact-name').value;
            var input_email = document.getElementById('schlixcontact-email').value;
            var input_subject = document.getElementById('schlixcontact-subject').value;
            var input_phone = document.getElementById('schlixcontact-phone').value;
            var input_message = document.getElementById('schlixcontact-message').value;
            var input_contact_id = document.getElementById('schlixcontact-id').getAttribute('data-value');            
            
        var postData = "_csrftoken=" + _csrftoken + 
            '&submitmessage=1' +
            '&name=' + encodeURIComponent(input_name) + 
            '&email=' + encodeURIComponent(input_email) +
            '&subject=' + encodeURIComponent(input_subject) + 
            '&phone=' + encodeURIComponent(input_phone) + 
            '&contact_id=' + encodeURIComponent(input_contact_id) + 
            '&message=' + encodeURIComponent(input_message);
            
            if (input_verification_el)
            {
                var input_verification_el = document.getElementById('schlixcontact-verification');
                
                postData += '&verification_code=' + encodeURIComponent(input_verification_el.value);
            }
            SCHLIX.Cookie.set('schlixcontact-name', input_name);
            SCHLIX.Cookie.set('schlixcontact-email', input_email);
        var request = SCHLIX.Ajax.POST( site_httpbase + "/contacts/action/sm",
                {success: this.onMessageSubmitted, failure: this.onMessageRejected, scope: this}, postData);
            e.preventDefault();
            e.stopPropagation();
            return false;
        }
        
    }
        
};

/**
 * Old method to init map. Kept for backward compatibility
 * @param {type} item_title
 * @param {type} item_complete_address
 * @param {type} item_zoom
 * @returns {initMap}
 * @deprecated since version 2.2.0
 */
function deprecated_initMap(item_title, item_complete_address, item_zoom)
{
    var latlng;
    var place_lat = document.getElementById('latitude');
    var place_lng = document.getElementById('longitude');   
    if (place_lat !== null && place_lng !== null)
    {
        var latvalue = place_lat.content;
        var longvalue = place_lng.content;
        var the_map = new L.Map('contact_map_canvas', {preferCanvas:true, scrollWheelZoom: false});
        
        the_map.attributionControl.setPrefix('&copy; <a href="https://openstreetmap.org">OpenStreetMap</a> contributors.');
        //var osm = new L.TileLayer('', {minZoom: 8, maxZoom: 17});
        var osm = new L.TileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {minZoom: 8, maxZoom: 19});
        the_map.setView(new L.LatLng(latvalue, longvalue), item_zoom);
        var the_marker = L.marker([latvalue, longvalue], {draggable: true}).addTo(the_map);
        the_marker.bindPopup("<h3>" + item_title + "</h3>" + "<p>" + item_complete_address + "</p>").openPopup();
        the_map.addLayer(osm);
        
    }    
};

function initMap(el)
{
    var map_el_id = el.id;
    var place_lat = parseFloat(el.getAttribute('data-latitude'));
    var place_lng = parseFloat(el.getAttribute('data-longitude'));   
    var item_zoom = parseInt(el.getAttribute('data-zoom'), 10);
    var item_title = el.getAttribute('data-title');
    var item_complete_address = el.getAttribute('data-address');
    if (place_lat !== null && place_lng !== null)
    {
        var latvalue = place_lat;
        var longvalue = place_lng;
        var the_map = new L.Map(map_el_id, {preferCanvas:true, scrollWheelZoom: false});
        the_map.attributionControl.setPrefix('&copy; <a href="https://openstreetmap.org">OpenStreetMap</a> contributors.');
        //var osm = new L.TileLayer('', {minZoom: 8, maxZoom: 17});
        var osm = new L.TileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {minZoom: 8, maxZoom: 19});
        the_map.setView(new L.LatLng(latvalue, longvalue), item_zoom);
        var the_marker = L.marker([latvalue, longvalue], {draggable: true}).addTo(the_map);
        the_marker.bindPopup("<h3>" + item_title + "</h3>" + "<p>" + item_complete_address + "</p>").openPopup();
        the_map.addLayer(osm);
        
    }    
}

function view_contact_map()
{
    if (SCHLIX.Dom.get('contact_map_canvas'))
    {
        // backward compatibility
        deprecated_initMap(canvas_map_title, canvas_map_address, canvas_map_zoom);
    } else 
    {
        var all_maps = SCHLIX.Dom.get('{.schlix-contact-map}');
        if (all_maps)
        {
        var count = all_maps.length;
        if (count > 0)
            for (var i = 0; i < count;i++)
                initMap(all_maps[i]);
        }
    }
};


SCHLIX.Event.onDOMReady(view_contact_map);
var __schlix_contact = new SCHLIXContactForm();