<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION')) die('No Access');
?>
<?php
    $field_cid = $this->getFieldCategoryID();
    $field_id = $this->getFieldID();
    
    $str_mainpage_title =  $this->getConfig('str_mainpage_title') ? $this->getConfig('str_mainpage_title') : $this->getApplicationDescription();
    $str_mainpage_text =  $this->getConfig('str_mainpage_text');
     // OPTIONAL - feel free to uncomment
     // $this->processDataOutputWithMacro($str_mainpage_text, 'viewMainPage');
?>
<div class="app-page-main app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-main">
    <?php if ($blog_view_mode == 'main') : ?>
        <h1 class="main title"><?= ___h($str_mainpage_title); ?></h1>
        <?php if ($pg < 2) : ?>
            <?= $str_mainpage_text ?>
        <?php endif ?>
    <?php elseif ($blog_view_mode == 'archive'): ?>
    <?php endif ?>
    <?php if ($items):  ?>
    <!-- ########################################################################### -->
    <!-- ########################## child items #################################### -->
    <!-- ########################################################################### -->
       <div class="main items">
            <?php foreach ($items as $child_item): ?>
                <?php if ($child_item['status'] > 0): ?>            
                <section class="child-item" itemscope="1" itemtype="http://schema.org/<?= $this->schema_org_type_item; ?>" >    
                    <?= isset($child_item['macro_processed_text_outside_article_top']) ? $child_item['macro_processed_text_outside_article_top'] : null ?>
                    <?php 
                        $child_item_id = $child_item[$field_id];
                        $this->processDataOutputWithMacro($child_item, 'viewMainPageItem', array('main_meta_options' => $main_meta_options));
                        $link = $this->createFriendlyURL("action=viewitem&id={$child_item_id}");
                        $child_item_title = ___h($child_item['title']);
                        $child_item_title_text = ($child_item != null) && ($main_meta_options['display_child_item_read_more_link']==false || $main_meta_options['display_link_title']==true) ? 
                            \__HTML::A($child_item_title,$link) : $child_item_title;
                        $image_size = 'image_large';  // $main_meta_options['image_display_size'] ? 'image_medium' : 'image_small';
                        
                    ?>
                    <?php if ($child_item_title_text): ?>
                        <h2 class="item title"><?= $child_item_title_text; ?></h2>
                    <?php endif ?>
                    
                    <?php if ($child_item['summary_secondary_headline']): ?>
                        <div class="secondary-headline">
                            <?= $child_item['summary_secondary_headline'] ?>
                        </div>
                    <?php endif ?>
                    <!-- Macro - Pre -->
                    <?php if ($child_item['macro_processed_text_before_article']): ?>        
                        <div class="meta before-article">        
                            <?= $child_item['macro_processed_text_before_article'] ?>            
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->
                    <!-- intro image -->
                    <?php if ($main_meta_options['display_item_summary_intro_image'] && is_file($this->getDataFileFullPath($image_size, $child_item['summary_intro_image']))): ?>
                        <div class="intro-image">
                            <figure>
                              <a href="<?= $link ?>"><img class="intro-image" src="<?= $this->getDataFileURLPath($image_size, $child_item['summary_intro_image']) ?>" alt="<?= ___h($child_item['summary_intro_image_caption']) ?>"></a>
                              <?php if ($main_meta_options['display_item_summary_intro_image_caption'] && $child_item['summary_intro_image_caption']): ?>
                              <div class="intro-image"><?= $child_item['summary_intro_image_caption'] ?></div>
                              <?php endif ?>
                            </figure>                                             
                        </div>
                    <?php endif ?>                    
                    <!-- end intro image -->
                    <!-- text -->
                    <?php if ($main_meta_options['display_item_summary']): ?>
                        <div class="text">
                            <?= $child_item['summary'] ?>
                        </div>
                    <?php endif; ?>
                    <!-- end text -->

                    <!-- Macro - Post -->   
                    <?php if (isset($child_item['macro_processed_text_after_article'])): ?>                
                        <div class="meta after-article">
                            <?= $child_item['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post -->     
                    <?= $child_item['macro_processed_text_outside_article_bottom'] ?>
                </section>
                <hr class="article-separator" />
                <?php endif ?>
            <?php endforeach ?>       
        </div>     
    <!-- ########################################################################### -->
    <!-- ####################### end child items ################################### -->
    <!-- ########################################################################### -->
    <?php endif; ?>
    
    <!-- pagination begin -->
    <?php $pagination_str = $this->displayItemPagination($pg,$pagination['total'],$pagination_url_action); ?>
    <?php if ($pagination_str): ?>
        <div class="pagination"><?= $pagination_str; ?></div>
    <?php endif; ?>
    <!-- end pagination -->
</div> 