<?php
if (!defined('SCHLIX_VERSION')) die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
global $SystemConfig;
$copyright = ___('Copyright').' &copy; '.'SCHLIX Web Inc';
$seo_hidden = $SystemConfig->get('system','int_search_engine_hidden');
?>
<?php global $CurrentUser, $SchlixSessionHandler, $HTMLHeader; ?>
<?php //$app_js_script = $this->getAjaxControllerScript();  ?>
<?php $this->JAVASCRIPT('admin.admin.js') ?>


<schlix-data-explorer-blank id="schlix-admin-admin" class="schlix-data-editor" data-app="<?= $this->app_name ?>" data-main-app-description="<?= ___('Main') ?>"  data-schlix-controller="SCHLIX.CMS.AdminAdmin" data-model="<?= $this->getDataModelURL() ?>" data-field-id="id" data-cancel-warning="true">
    
<?php if (SCHLIX_SITE_OFFLINE) : ?>
        <x-ui:alert type="danger">
            <i class="fas fa-exclamation-circle "></i>&nbsp; <?= ___('Your website is currently offline') ?>
        </x-ui:alert>
<?php endif ?>    
<?php if ($seo_hidden) : ?>
        <x-ui:alert type="warning">
            <i class="fas fa-exclamation-circle "></i>&nbsp; <?= ___('Search engine indexing is currently disabled on your website') ?>
        </x-ui:alert>
<?php endif ?>    
    
        <x-ui:schlix-explorer-toolbar>
            <x-ui:schlix-explorer-toolbar-menu data-position="left">    
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
                <x-ui:schlix-explorer-menu-command data-schlix-command="global-config" data-schlix-app-action="editglobalconfig"  fonticon="fas fa-cog text-slategray" label="<?= ___('Global Configuration') ?>" />
            </x-ui:schlix-explorer-toolbar-menu>

        </x-ui:schlix-explorer-toolbar>
    <?php \App\Core_Composer_Admin::displayComposerInstallProgress() ?>
    
    <div class="content"> 
        <!-- check latest version -->
        <?php if ($latest_version): ?>
        <x-ui:row>
            <x-ui:column sm="12">
                <x-ui:schlix-stat-box class="bg-yellow-gradient" fonticon="fa fa-laptop" header="<?= 'v'.$latest_version['version'] ?>" text="<?= ___('A new update for SCHLIX CMS has been released on').' '.date('Y-m-d', strtotime($latest_version['date_created'])) ?>"  link-url="<?= $this->createFriendlyUrl("app=core.schlixupdater") ?>" />
            </x-ui:column>
        </x-ui:row>
        <?php endif ?>
          <!-- Small boxes (Stat box) -->
          <x-ui:row>
            <x-ui:column xs="6" md="3">
                <x-ui:schlix-stat-box class="bg-orange" fonticon="fa fa-desktop" header="<?= $SchlixSessionHandler->getCountWithinSeconds(600) ?>" text="<?= ___('Active Sessions') ?>"  link-url="<?= $this->createFriendlyUrl("active-sessions") ?>" />
            </x-ui:column>
            <x-ui:column xs="6" md="3">
                <x-ui:schlix-stat-box class="bg-purple-gradient" fonticon="fa fa-user" header="<?= $CurrentUser->getRegisteredUsersCount() ?>" text="<?= ___('Registered users') ?>"  link-url="<?= $this->createFriendlyUrl("app=users") ?>" />               
            </x-ui:column>
            <x-ui:column xs="6" md="3">
                <x-ui:schlix-stat-box class="bg-light-blue-gradient" fonticon="fa fa-map-pin" header="<?= $SchlixSessionHandler->getUniqueIPAddressWithinDay(1) ?>" text="<?= ___('Unique IP addresses today') ?>"  link-url="<?= $this->createFriendlyUrl("active-sessions") ?>" />
               
            </x-ui:column>
            <x-ui:column xs="6" md="3">
                 <x-ui:schlix-stat-box class="bg-green-gradient" fonticon="fa fa-envelope" header="<?= $this->getCountOfIncomingMessagesWithinDays(30) ?>" text="<?= ___('New messages within 30 days') ?>"  link-url="<?= $this->createFriendlyUrl("app=contacts") ?>" />
            </x-ui:column>
          </x-ui:row><!-- /.row -->
          <!-- Main row -->
        <x-ui:row>
            <x-ui:column md="7">

              <!-- Latest News -->
              <?= $this->viewIncomingMessages(); ?>

              <p class="alert bg-black"><i class="far fa-question-circle"></i> 
               <?= sprintf(___('For community support, please visit %s to ask questions, report bugs, etc'), 
                   \__HTML::A(___('our forum'), 'https://www.schlix.com/forum/',array('target' => '_blank', 'rel' => 'nofollow') )) ?> </p>
            </x-ui:column><!-- /.Left col -->
            <!-- right col (We are only adding the ID to make the widgets sortable)-->
            <x-ui:column md="5">

              <!-- Latest News -->
              <div class="nav-tabs-custom" id="tabs-whatsnew">
                <!-- Tabs within a box -->
                <ul class="nav nav-tabs pull-right">
                  
                  <li><a href="#schlix_news_themes" data-toggle="tab"><i class="fas fa-tv"></i> <?= ___('Themes') ?></a></li>
                  <li><a href="#schlix_news_ext" data-toggle="tab"><i class="fa fa-puzzle-piece"></i> <?= ___('Extensions') ?></a></li>
                  <li class="active"><a href="#schlix_news_main" data-toggle="tab"><i class="far fa-newspaper"></i> <?= ___('News') ?></a></li>
                  <li class="pull-left header" id="whatsnew_schlix"><img src="https://logo.schlix.com/images/schlix_tiny_icon.png" alt="<?= ___('SCHLIX News') ?>" id="schlix_news_logo" onerror="this.style.display='none';"/> <?= ___('What\'s New?') ?></li>
                </ul>
                <div class="tab-content no-padding">
                  
                  <div class="tab-pane" id="schlix_news_themes" style="position: relative"></div>
                  <div class="tab-pane" id="schlix_news_ext" style="position: relative"></div>
                  <div class="tab-pane active" id="schlix_news_main" style="position: relative"></div>
                </div>
              </div><!-- /.nav-tabs-custom -->
              
              <!-- /.box -->              
              <!-- System Info -->
              <x-ui:schlix-info-box class="box-solid bg-gray" fonticon="fa fa-desktop" label="<?= ___('System Info') ?>" no-padding="1" >
                  <?php $this->viewSystemInfo(); ?>
              </x-ui:schlix-info-box>
              
              
            </x-ui:column><!-- right col -->
        </x-ui:row><!-- /.row (main row) -->

        </div><!-- /.content -->
</schlix-data-explorer-blank>        