//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

//----------------------------------------------------------------------------------------------------------//
function setApplicationBusyState(state)
{
    var busy_indicator = document.getElementById('global-busy-indicator');
    if (busy_indicator)
    {
        busy_indicator.style.display = (state === true) ? 'block' : 'none';
    }

};


function ajaxTestDatabase() {
    if (document.getElementById('db_host').value == '' || document.getElementById('db_database').value == '' || document.getElementById('db_username').value == '' || document.getElementById('db_password').value == '')
    {
        var msg_container = document.getElementById('db_test_msg');
        msg_container.innerHTML = '<div class="alert alert-danger"><i class="fas fa-times-circle"></i> ' + 'Please complete the fields' + '</div>';

        return false;
    }
    setApplicationBusyState(true);
    var use_ssl = document.getElementById('db_use_ssl').checked ? 1 : 0;
    var postData = 'db_host=' + document.getElementById('db_host').value + '&db_database=' + document.getElementById('db_database').value + 
            '&db_username=' + document.getElementById('db_username').value + 
            '&db_password=' + document.getElementById('db_password').value +
            '&db_port=' + document.getElementById('db_port').value +
            '&db_socket=' + document.getElementById('db_socket').value +
            '&db_use_ssl=' + use_ssl +
            '&db_ssl_ca=' + document.getElementById('db_ssl_ca').value;
    
    var callback = {success: testDatabaseSuccess, failure: testFailure};
    var request = SCHLIX.Ajax.request('POST', 'index.php?action=testdatabase', callback, postData);
};
//----------------------------------------------------------------------------------------------------------//
function notifyChangeURL ()
{
    document.getElementById('continue_to_next_step').style.display = 'none';

};
//----------------------------------------------------------------------------------------------------------//

function ajaxTestSiteURL() {
    if (document.getElementById('admin_password').value == '') {
        alert('Admin password is empty');
        return false
    }
    if (document.getElementById('admin_password_verify').value == '') {
        alert('Please verify admin password');
        return false
    }
    if (document.getElementById('admin_password').value != document.getElementById('admin_password_verify').value) {
        alert('Admin password does not match its verification');
        return false
    }
    return true;
};

//----------------------------------------------------------------------------------------------------------//
function testDatabaseSuccess (o)
{
    var response = ajax_parse(o.responseText);
    if (response)
    {
        var msg_container = document.getElementById('db_test_msg');
        if (response == 'OK')
        {

            msg_container.innerHTML = '<div class="alert alert-success">' + '<i class="fas fa-check-circle"></i> Connected to the database server successfully!'+ '</div>';
            document.getElementById('continue_to_next_step').style.display = 'inline-block';
        } else
        {

            msg_container.innerHTML = '<div class="alert alert-danger"><i class="fas fa-times-circle"></i> ' + response + '</div>';
            document.getElementById('continue_to_next_step').style.display = 'none';
        }
        setApplicationBusyState(false);
    }
};
//----------------------------------------------------------------------------------------------------------//

function testFailure (o)
{
    if (o.responseText !== undefined)
    {
        alert('Error ' + o.tId + ': ' + o.status + ', ' + o.statusText);
    } else
        alert('Data Error');
    document.getElementById('continue_to_next_step').style.display = 'none';
    setApplicationBusyState(false);
};
//----------------------------------------------------------------------------------------------------------//
function json_decode(jsonstr) {
//if (jsonstr.length > 0)
    if (jsonstr.replace(/\s/g, "") != "")
    {
        var data = eval('(' + jsonstr + ')');

        return data;
    } else
    {
        alert('SCHLIX AJAX Communication Error.\nServer returns an empty string. Please take a screenshot and e-mail technical support');
        return false;
    }
};
//----------------------------------------------------------------------------------------------------------//

function ajax_parse(reply_from_server)
{
    var the_reply = json_decode(reply_from_server);
    if (the_reply != false)
    {
        if (the_reply['status'] != '200')
        {
            if (the_reply['data'])
                alert('Error: ' + the_reply['data']);
            else
                alert('Error: AJAX Communication error with the server.\nPlease log out and try again.');
        } else
            return the_reply['data'];
    }
};

function check_wildcard_option()
{
    var use_wildcard = SCHLIX.Dom.get('use_wildcard');
    var use_www = SCHLIX.Dom.get('use_www');
    if (use_wildcard && use_www)
    {
        if (use_wildcard.checked)
        {
            use_www.checked = false;
            use_www.disabled = true;
        } else
        {
            use_www.disabled = false;
        }

        if (use_www.checked)
        {
            use_wildcard.checked = false;
            use_wildcard.disabled = true;
        } else
        {
            use_wildcard.disabled = false;
        }
        
    }
};

function onFormSubmit()
{
    setApplicationBusyState(true);
}

function domready_script()
{
    if (SCHLIX.Dom.get('use_wildcard') && SCHLIX.Dom.get('use_www'))
    {
        SCHLIX.Event.on('use_wildcard','change',check_wildcard_option);
        SCHLIX.Event.on('use_www','change',check_wildcard_option);
    }
    if (SCHLIX.Dom.get ('testdatabasebutton'))
    {
        SCHLIX.Event.on('testdatabasebutton','click',ajaxTestDatabase);
        
    }
    SCHLIX.Event.on('{.form-install}', 'submit', onFormSubmit);
    SCHLIX.Event.on('btn-print', 'click', window.print);
};

SCHLIX.Event.onDOMReady(domready_script);
