<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_cns
 */

/**
 * Hook class.
 */
class Hook_profiles_tabs_about
{
    /**
     * Find whether this hook is active.
     *
     * @param  MEMBER $member_id_of The ID of the member who is being viewed
     * @param  MEMBER $member_id_viewing The ID of the member who is doing the viewing
     * @return boolean Whether this hook is active
     */
    public function is_active($member_id_of, $member_id_viewing)
    {
        return true;
    }

    /**
     * Render function for profile tab hooks.
     *
     * @param  MEMBER $member_id_of The ID of the member who is being viewed
     * @param  MEMBER $member_id_viewing The ID of the member who is doing the viewing
     * @param  boolean $leave_to_ajax_if_possible Whether to leave the tab contents NULL, if tis hook supports it, so that AJAX can load it later
     * @return array A tuple: The tab title, the tab contents, the suggested tab order, the icon
     */
    public function render_tab($member_id_of, $member_id_viewing, $leave_to_ajax_if_possible = false)
    {
        $title = do_lang_tempcode('PROFILE');

        $order = 10;

        if (!$GLOBALS['FORUM_DB']->table_is_locked('f_members')) {
            $GLOBALS['FORUM_DB']->query('UPDATE ' . $GLOBALS['FORUM_DB']->get_table_prefix() . 'f_members SET m_profile_views=m_profile_views+1 WHERE id=' . strval($member_id_of), 1);
        }

        $privacy_ok = true;
        if (addon_installed('content_privacy')) {
            require_code('content_privacy');
            $privacy_ok = has_privacy_access('_photo', strval($member_id_of), $member_id_viewing, '', $member_id_of);
        }

        $photo_url = $GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_photo_url');
        if (($photo_url != '') && (addon_installed('cns_member_photos')) && ((has_privilege($member_id_viewing, 'view_member_photos')) || ($member_id_viewing == $member_id_of)) && ($privacy_ok)) {
            require_code('images');
            $photo_thumb_url = $GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_photo_thumb_url');
            $photo_thumb_url = ensure_thumbnail($photo_url, $photo_thumb_url, (strpos($photo_url, 'uploads/photos') !== false) ? 'photos' : 'cns_photos', 'f_members', $member_id_of, 'm_photo_thumb_url');
            if (url_is_local($photo_url)) {
                $photo_url = get_complex_base_url($photo_url) . '/' . $photo_url;
            }
            if (url_is_local($photo_thumb_url)) {
                $photo_thumb_url = get_complex_base_url($photo_thumb_url) . '/' . $photo_thumb_url;
            }
        } else {
            $photo_url = '';
            $photo_thumb_url = '';
        }

        $avatar_url = $GLOBALS['FORUM_DRIVER']->get_member_avatar_url($member_id_of);
        $username = $GLOBALS['FORUM_DRIVER']->get_username($member_id_of);

        // Things staff can do with this user
        $modules = array();
        if ((has_privilege($member_id_viewing, 'warn_members')) && (has_actual_page_access($member_id_viewing, 'warnings')) && (addon_installed('cns_warnings'))) {
            $redir_url = get_self_url(true);
            $modules[] = array('audit', do_lang_tempcode('WARN_MEMBER'), build_url(array('page' => 'warnings', 'type' => 'add', 'member_id' => $member_id_of, 'redirect' => $redir_url), get_module_zone('warnings')), 'links/warning_add');
            $modules[] = array('audit', do_lang_tempcode('WARN_MEMBER_AS_SPAMMER'), build_url(array('page' => 'warnings', 'type' => 'add', 'member_id' => $member_id_of, 'spam' => 1, 'redirect' => $redir_url), get_module_zone('warnings')), 'buttons/report');
            $modules[] = array('audit', do_lang_tempcode('PUNITIVE_HISTORY'), build_url(array('page' => 'warnings', 'type' => 'history', 'id' => $member_id_of), get_module_zone('warnings')), 'tabs/member_account/warnings');
        }
        if ((addon_installed('actionlog')) && (has_privilege($member_id_viewing, 'view_revisions')) && (has_actual_page_access($member_id_viewing, 'admin_revisions'))) {
            $modules[] = (!addon_installed('cns_forum')) ? null : array('audit', do_lang_tempcode('actionlog:REVISIONS'), build_url(array('page' => 'admin_revisions', 'type' => 'browse', 'username' => $username), get_module_zone('admin_revisions')), 'buttons/revisions');
        }
        if ((addon_installed('securitylogging')) && (has_actual_page_access($member_id_viewing, 'admin_lookup'))) {
            require_lang('lookup');
            $modules[] = array('audit', do_lang_tempcode('INVESTIGATE_USER'), build_url(array('page' => 'admin_lookup', 'param' => $member_id_of), get_module_zone('admin_lookup')), 'menu/adminzone/tools/users/investigate_user');
        }
        if ((addon_installed('securitylogging')) && (has_actual_page_access($member_id_viewing, 'admin_security'))) {
            require_lang('security');
            $modules[] = array('audit', do_lang_tempcode('SECURITY_LOG'), build_url(array('page' => 'admin_security', 'member_id' => $member_id_of), get_module_zone('admin_security')), 'menu/adminzone/audit/security_log');
        }
        if (addon_installed('actionlog')) {
            if (has_actual_page_access($member_id_viewing, 'admin_actionlog')) {
                require_lang('actionlog');
                $modules[] = array('audit', do_lang_tempcode('VIEW_ACTIONLOGS'), build_url(array('page' => 'admin_actionlog', 'type' => 'list', 'id' => $member_id_of), get_module_zone('admin_actionlog')), 'menu/adminzone/audit/actionlog');
            }
        }
        if ((has_privilege($member_id_viewing, 'assume_any_member')) && (get_member() != $member_id_of)) {
            $modules[] = array('views', do_lang_tempcode('MASQUERADE_AS_MEMBER'), build_url(array('page' => '', 'keep_su' => $username), ''), 'menu/site_meta/user_actions/login');
        }
        if ((has_actual_page_access($member_id_viewing, 'search')) && (addon_installed('search'))) {
            $modules[] = array('content', do_lang_tempcode('SEARCH'), build_url(array('page' => 'search', 'type' => 'results', 'author' => $username), get_module_zone('search')), 'buttons/search', 'search');
        }
        if (addon_installed('authors')) {
            $author = $GLOBALS['SITE_DB']->query_value_if_there('SELECT author FROM ' . get_table_prefix() . 'authors WHERE (member_id=' . strval($member_id_of) . ') OR (member_id IS NULL AND ' . db_string_equal_to('author', $username) . ')');
            if ((has_actual_page_access($member_id_viewing, 'authors')) && (!is_null($author))) {
                $modules[] = array('content', do_lang_tempcode('AUTHOR'), build_url(array('page' => 'authors', 'type' => 'browse', 'id' => $author), get_module_zone('authors')), 'menu/rich_content/authors', 'me');
            }
        }
        require_code('cns_members2');
        if ((cns_may_make_private_topic()) && (cns_may_whisper($member_id_of)) && ($member_id_viewing != $member_id_of)) {
            $modules[] = (!addon_installed('cns_forum')) ? null : array('contact', do_lang_tempcode('ADD_PRIVATE_TOPIC'), build_url(array('page' => 'topics', 'type' => 'new_pt', 'id' => $member_id_of), get_module_zone('topics')), 'buttons/send', 'reply');
        }
        $extra_sections = array();
        $extra_info_details = array();
        $extra_tracking_details = array();
        $hooks = find_all_hooks('modules', 'members');
        foreach (array_keys($hooks) as $hook) {
            require_code('hooks/modules/members/' . filter_naughty_harsh($hook));
            $object = object_factory('Hook_members_' . filter_naughty_harsh($hook), true);
            if (is_null($object)) {
                continue;
            }
            if (method_exists($object, 'run')) {
                $hook_result = $object->run($member_id_of);
                $modules = array_merge($modules, $hook_result);
            }
            if (method_exists($object, 'get_info_details')) {
                $hook_result = $object->get_info_details($member_id_of);
                $extra_info_details = array_merge($extra_info_details, $hook_result);
            }
            if (method_exists($object, 'get_tracking_details')) {
                $hook_result = $object->get_tracking_details($member_id_of);
                $extra_tracking_details = array_merge($extra_tracking_details, $hook_result);
            }
            if (method_exists($object, 'get_sections')) {
                $hook_result = $object->get_sections($member_id_of);
                $extra_sections = array_merge($extra_sections, $hook_result);
            }
        }
        if (addon_installed('cns_contact_member')) {
            if ((($GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_allow_emails') == 1) || (get_option('allow_email_disable') == '0')) && ($GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_email_address') != '') && (!is_guest($member_id_of)) && (has_actual_page_access($member_id_viewing, 'contact_member')) && ($member_id_viewing != $member_id_of)) {
                $redirect = get_self_url(true);
                $modules[] = array('contact', do_lang_tempcode('_EMAIL_MEMBER'), build_url(array('page' => 'contact_member', 'redirect' => $redirect, 'id' => $member_id_of), get_module_zone('contact_member')), 'links/contact_member', 'reply nofollow');
            }
        }
        require_lang('menus');
        $sections = array('contact' => do_lang_tempcode('CONTACT'), 'profile' => do_lang_tempcode('EDIT_PROFILE'), 'views' => do_lang_tempcode('ACCOUNT'), 'audit' => do_lang_tempcode('AUDIT'), 'content' => do_lang_tempcode('CONTENT'));
        $actions = array();
        sort_maps_by($modules, 1);
        foreach ($sections as $section_code => $section_title) {
            $links = new Tempcode();

            foreach ($modules as $mi => $module) {
                if ($module === null) {
                    continue;
                }

                if (count($module) == 4) {
                    list($_section_code, $lang, $url, $icon) = $module;
                    $rel = null;
                } else {
                    list($_section_code, $lang, $url, $icon, $rel) = $module;
                }

                if ($section_code == $_section_code) {
                    $links->attach(do_template('CNS_MEMBER_ACTION', array(
                        '_GUID' => '67b2a640a368c6f53f1b1fa10f922fd0',
                        'ID' => strval($member_id_of),
                        'URL' => $url,
                        'LANG' => $lang,
                        'REL' => $rel,
                        'ICON' => $icon,
                    )));

                    unset($modules[$mi]);
                }
            }
            $actions[$section_code] = $links;
        }

        // Custom fields
        $_custom_fields = cns_get_all_custom_fields_match_member(
            $member_id_of, // member
            (($member_id_viewing != $member_id_of) && (!has_privilege($member_id_viewing, 'view_any_profile_field'))) ? 1 : null, // public view
            (($member_id_viewing == $member_id_of) && (!has_privilege($member_id_viewing, 'view_any_profile_field'))) ? 1 : null // owner view
        );
        $custom_fields = array();
        $custom_fields_sections = array();
        require_code('encryption');
        $value = mixed();
        $fields_map = array();
        foreach ($_custom_fields as $name => $_value) {
            $value = $_value['RAW'];
            $rendered_value = $_value['RENDERED'];

            $encrypted_value = '';
            if (is_data_encrypted($value)) {
                $encrypted_value = remove_magic_encryption_marker($value);
            } elseif (is_integer($value)) {
                $value = strval($value);
            } elseif (is_float($value)) {
                $value = float_to_raw_string($value, 30);
            }

            if ((get_option('show_empty_cpfs') == '1') || (((!is_object($value)) && ($value != '')) || ((is_object($value)) && (!$value->is_empty())))) {
                $custom_field = array(
                    'RAW_VALUE' => $value,
                    'VALUE' => $rendered_value,
                    'ENCRYPTED_VALUE' => $encrypted_value,
                    'FIELD_ID' => $_value['FIELD_ID'],
                    'FIELD_TYPE' => $_value['TYPE'],
                    'EDITABILITY' => $_value['EDITABILITY'],
                    'EDIT_TYPE' => $_value['EDIT_TYPE'],
                );

                if (strpos($name, ': ') !== false) {
                    $parts = explode(': ', $name, 2);
                    if (!isset($custom_fields_sections[$parts[0]])) {
                        $custom_fields_sections[$parts[0]] = array('CUSTOM_FIELDS_SECTION' => array());
                    }

                    $custom_field['NAME'] = $parts[1];

                    $custom_fields_sections[$parts[0]]['CUSTOM_FIELDS_SECTION'][] = $custom_field;
                } else {
                    $custom_field['NAME'] = $name;

                    $custom_fields[] = $custom_field;
                }

                if ($name == do_lang('KEYWORDS')) {
                    $GLOBALS['SEO_KEYWORDS'] = is_object($value) ? $value->evaluate() : $value;
                }
                if ($name == do_lang('DESCRIPTION')) {
                    $GLOBALS['SEO_DESCRIPTION'] = is_object($value) ? $value->evaluate() : $value;
                }
            }

            $field_codename = strtoupper(trim(preg_replace('#[^\w]+#', '_', $name), '_'));
            $fields_map['FIELD__' . $field_codename . '__RENDERED'] = $rendered_value;
            $fields_map['FIELD__' . $field_codename . '__RAW'] = $value;
        }

        // Birthday
        $day = $GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_dob_day');
        $month = $GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_dob_month');
        $year = $GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_dob_year');
        $dob = '';
        $_dob = null;
        $_dob_censored = null;
        if (($day !== null) && ($month !== null) && ($year !== null)) {
            $_dob = mktime(12, 0, 0, $month, $day, $year);
            $_dob_censored = mktime(12, 0, 0, $month, $day);
            if ($GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_reveal_age') == 1) {
                if (@strftime('%Y', @mktime(0, 0, 0, 1, 1, 1963)) != '1963') {
                    $dob = strval($year) . '-' . str_pad(strval($month), 2, '0', STR_PAD_LEFT) . '-' . str_pad(strval($day), 2, '0', STR_PAD_LEFT);
                    $_dob = $_dob_censored; // Have to use censored as other is broken
                } else {
                    $dob = get_timezoned_date($_dob, false, false, true);
                    $_dob_censored = $_dob; // No censoring needed
                }
            } else {
                if (@strftime('%Y', @mktime(0, 0, 0, 1, 1, 1963)) != '1963') {
                    $_dob = $_dob_censored;
                }
                $dob = cms_strftime(do_lang('date_no_year'), $_dob_censored);
            }
        }

        // Find forum with most posts
        $forums = $GLOBALS['FORUM_DB']->query('SELECT id,f_name FROM ' . $GLOBALS['FORUM_DB']->get_table_prefix() . 'f_forums WHERE f_cache_num_posts>0');
        $best_yet_forum = 0; // Initialise to integer type
        $best_yet_forum = null;
        $most_active_forum = null;
        $_best_yet_forum = $GLOBALS['FORUM_DB']->query_select('f_posts', array('COUNT(*) as cnt', 'p_cache_forum_id'), array('p_poster' => $member_id_of), 'GROUP BY p_cache_forum_id ORDER BY COUNT(*) DESC', 1); // order by and limit have been added since original code, makes it run a bit faster
        $_best_yet_forum = collapse_2d_complexity('p_cache_forum_id', 'cnt', $_best_yet_forum);
        foreach ($forums as $forum) {
            if (((array_key_exists($forum['id'], $_best_yet_forum)) && ((is_null($best_yet_forum)) || ($_best_yet_forum[$forum['id']] > $best_yet_forum)))) {
                $most_active_forum = has_category_access($member_id_viewing, 'forums', strval($forum['id'])) ? protect_from_escaping(escape_html($forum['f_name'])) : do_lang_tempcode('PROTECTED_FORUM');
                $best_yet_forum = $_best_yet_forum[$forum['id']];
            }
        }
        $post_count = $GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_cache_num_posts');
        $best_post_fraction = ($post_count == 0) ? do_lang_tempcode('NA_EM') : make_string_tempcode(integer_format(100 * $best_yet_forum / $post_count));
        $most_active_forum = is_null($best_yet_forum) ? new Tempcode() : do_lang_tempcode('_MOST_ACTIVE_FORUM', $most_active_forum, make_string_tempcode(integer_format($best_yet_forum)), array($best_post_fraction));
        $users_timezone = get_users_timezone($member_id_of);
        require_code('temporal2');
        $time_for_them_raw = tz_time(time(), $users_timezone);
        $time_for_them = get_timezoned_time(time(), true, $member_id_of);

        $is_banned = ($GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_is_perm_banned') == 1);
        $banned = do_lang_tempcode($is_banned ? 'YES' : 'NO');

        $last_submit_time = $GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_last_submit_time');
        $submit_days_ago = intval(floor(floatval(time() - $last_submit_time) / 60.0 / 60.0 / 24.0));

        require_code('cns_groups');
        $primary_group_id = cns_get_member_primary_group($member_id_of);
        $primary_group = cns_get_group_link($primary_group_id, $member_id_of != $member_id_viewing);

        $member_row = $GLOBALS['FORUM_DRIVER']->get_member_row($member_id_of);
        $just_member_row = db_map_restrict($member_row, array('id', 'm_signature'));
        $signature = get_translated_tempcode('f_members', $just_member_row, 'm_signature', $GLOBALS['FORUM_DB']);
        if (($is_banned) && (!$GLOBALS['FORUM_DRIVER']->is_super_admin($member_id_viewing))) {
            $signature = new Tempcode(); // Spammers may use signatures as a way to justify even accounts that will get banned
        }

        $last_visit_time = $GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_last_visit_time');
        require_code('users2');
        if (member_is_online($member_id_of)) {
            $online_now = do_lang_tempcode('YES');
            $_online_now = true;
        } else {
            $_online_now = false;
            $minutes_ago = intval(floor((floatval(time() - $last_visit_time) / 60.0)));
            $hours_ago = intval(floor((floatval(time() - $last_visit_time) / 60.0 / 60.0)));
            $days_ago = intval(floor((floatval(time() - $last_visit_time) / 60.0 / 60.0 / 24.0)));
            $months_ago = intval(floor((floatval(time() - $last_visit_time) / 60.0 / 60.0 / 24.0 / 31.0)));
            if ($minutes_ago < 180) {
                $online_now = do_lang_tempcode('_ONLINE_NOW_NO_MINUTES', escape_html(integer_format($minutes_ago)));
            } elseif ($hours_ago < 72) {
                $online_now = do_lang_tempcode('_ONLINE_NOW_NO_HOURS', escape_html(integer_format($hours_ago)));
            } elseif ($days_ago < 93) {
                $online_now = do_lang_tempcode('_ONLINE_NOW_NO_DAYS', escape_html(integer_format($days_ago)));
            } else {
                $online_now = do_lang_tempcode('_ONLINE_NOW_NO_MONTHS', escape_html(integer_format($months_ago)));
            }
        }

        $join_time = $GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_join_time');
        $days_joined = intval(round((time() - $join_time) / 60 / 60 / 24));
        $total_posts = $GLOBALS['FORUM_DRIVER']->get_num_forum_posts();
        $join_date = ($join_time == 0) ? '' : get_timezoned_date($join_time, false);
        $count_posts = do_lang_tempcode('_COUNT_POSTS', escape_html(integer_format($post_count)), escape_html(float_format(floatval($post_count) / floatval(($days_joined == 0) ? 1 : $days_joined))), array(escape_html(float_format(floatval(100 * $post_count) / floatval(($total_posts == 0) ? 1 : $total_posts)))));

        $a = ($avatar_url == '') ? 0 : cns_get_member_best_group_property($member_id_of, 'max_avatar_width');
        $b = ($photo_thumb_url == '') ? 0 : intval(get_option('thumb_width'));
        $right_margin = (max($a, $b) == 0) ? 'auto' : (strval(max($a, $b) + 6) . 'px');

        if ((has_privilege($member_id_viewing, 'see_ip')) || ($member_id_viewing == $member_id_of)) {
            $ip_address = $GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_ip_address');
        } else {
            $ip_address = '';
        }

        $secondary_groups = cns_get_members_groups($member_id_of, true, false);
        unset($secondary_groups[$primary_group_id]);
        if (count($secondary_groups) > 0) {
            $_secondary_groups = array();
            $all_groups = $GLOBALS['FORUM_DRIVER']->get_usergroup_list($member_id_of != $member_id_viewing, false, false, array_keys($secondary_groups), $member_id_of);
            foreach (array_keys($secondary_groups) as $key) {
                $_secondary_groups[$key] = $all_groups[$key];
            }
            $secondary_groups = $_secondary_groups;
        }

        if (addon_installed('points')) {
            require_code('points');
            $count_points = integer_format(total_points($member_id_of));
        } else {
            $count_points = '';
        }

        $user_agent = null;
        $operating_system = null;
        if (((has_privilege($member_id_viewing, 'show_user_browsing')) || ($member_id_viewing == $member_id_of)) && (addon_installed('stats'))) {
            $last_stats = $GLOBALS['SITE_DB']->query_select('stats', array('browser', 'operating_system'), array('member_id' => $member_id_of), 'ORDER BY date_and_time DESC', 1);
            if (array_key_exists(0, $last_stats)) {
                $user_agent = $last_stats[0]['browser'];
                $operating_system = $last_stats[0]['operating_system'];
            }
        }

        $_on_probation = $GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_on_probation_until');
        if ((is_null($_on_probation)) || ($_on_probation <= time())) {
            $on_probation = null;
        } else {
            $on_probation = strval($_on_probation);
        }

        // Look up member's clubs
        $clubs = array();
        if (addon_installed('cns_clubs')) {
            $club_ids = $GLOBALS['FORUM_DRIVER']->get_members_groups($member_id_of, true);
            $club_rows = list_to_map('id', $GLOBALS['FORUM_DB']->query_select('f_groups', array('*'), array('g_is_private_club' => 1), '', 200));
            if (count($club_rows) == 200) {
                $club_rows = null;
            }
            foreach ($club_ids as $club_id) {
                if (is_null($club_rows)) {
                    $club_rows = list_to_map('id', $GLOBALS['FORUM_DB']->query_select('f_groups', array('*'), array('g_is_private_club' => 1, 'id' => $club_id), '', 200));
                    if (!array_key_exists($club_id, $club_rows)) {
                        continue;
                    }
                    $club_row = $club_rows[$club_id];
                    $club_rows = null;
                } else {
                    if (!array_key_exists($club_id, $club_rows)) {
                        continue;
                    }
                    $club_row = $club_rows[$club_id];
                }

                $group_name = get_translated_text($club_row['g_name'], $GLOBALS['FORUM_DB']);
                $forum_where = array('f_name' => $group_name, 'f_forum_grouping_id' => intval(get_option('club_forum_parent_forum_grouping')), 'f_parent_forum' => intval(get_option('club_forum_parent_forum')));
                $forum_id = $GLOBALS['FORUM_DB']->query_select_value_if_there('f_forums', 'id', $forum_where);

                $clubs[] = array(
                    'CLUB_NAME' => $group_name,
                    'CLUB_ID' => strval($club_row['id']),
                    'CLUB_FORUM' => is_null($forum_id) ? '' : strval($forum_id),
                );
            }
        }

        if ($on_probation !== null) {
            $probation_group = get_option('probation_usergroup');
            if (is_numeric($probation_group)) {
                $_probation_group = $GLOBALS['FORUM_DB']->query_select_value_if_there('f_groups', 'g_name', array('id' => intval($probation_group)));
                if ($_probation_group !== null) {
                    $probation_group = get_translated_text($_probation_group);
                } else {
                    $probation_group = null;
                }
            }
        } else {
            $probation_group = null;
        }

        $content = do_template('CNS_MEMBER_PROFILE_ABOUT', array(
            '_GUID' => 'fodfjdsfjsdljfdls',
            'CLUBS' => $clubs,
            'RIGHT_MARGIN' => $right_margin,
            'AVATAR_WIDTH' => strval($a) . 'px',
            'PHOTO_WIDTH' => strval($b) . 'px',
            'MOST_ACTIVE_FORUM' => $most_active_forum,
            'TIME_FOR_THEM' => $time_for_them,
            'TIME_FOR_THEM_RAW' => strval($time_for_them_raw),
            'USERS_TIMEZONE' => make_nice_timezone_name($users_timezone),
            'USERS_TIMEZONE_RAW' => $users_timezone,
            'SUBMIT_DAYS_AGO' => integer_format($submit_days_ago),
            'SUBMIT_TIME_RAW' => strval($last_submit_time),
            'LAST_VISIT_TIME_RAW' => strval($last_visit_time),
            'ONLINE_NOW' => $online_now,
            '_ONLINE_NOW' => $_online_now,
            'BANNED' => $banned,
            'USER_AGENT' => $user_agent,
            'OPERATING_SYSTEM' => $operating_system,
            'DOB' => $dob,
            '_DOB' => strval($_dob),
            '_DOB_CENSORED' => strval($_dob_censored),
            'IP_ADDRESS' => $ip_address,
            'COUNT_POSTS' => $count_posts,
            'COUNT_POINTS' => $count_points,
            'PRIMARY_GROUP' => $primary_group,
            'PRIMARY_GROUP_ID' => strval($primary_group_id),
            'PHOTO_URL' => $photo_url,
            'PHOTO_THUMB_URL' => $photo_thumb_url,
            'EMAIL_ADDRESS' => $GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_email_address'),
            'AVATAR_URL' => $avatar_url,
            'SIGNATURE' => $signature,
            'JOIN_DATE' => $join_date,
            'JOIN_DATE_RAW' => strval($join_time),
            'CUSTOM_FIELDS' => $custom_fields,
            'CUSTOM_FIELDS_SECTIONS' => $custom_fields_sections,
            'ACTIONS_contact' => $actions['contact'],
            'ACTIONS_profile' => $actions['profile'],
            'ACTIONS_views' => $actions['views'],
            'ACTIONS_audit' => $actions['audit'],
            'ACTIONS_content' => $actions['content'],
            'USERNAME' => $username,
            'MEMBER_ID' => strval($member_id_of),
            'SECONDARY_GROUPS' => $secondary_groups,
            'VIEW_PROFILES' => $member_id_viewing == $member_id_of || has_privilege($member_id_viewing, 'view_profiles'),
            'ON_PROBATION' => $on_probation,
            'PROBATION_GROUP' => $probation_group,
            'EXTRA_INFO_DETAILS' => $extra_info_details,
            'EXTRA_TRACKING_DETAILS' => $extra_tracking_details,
            'EXTRA_SECTIONS' => $extra_sections,
            'VIEWS' => strval($GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_profile_views')),
            'TOTAL_SESSIONS' => strval($GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id_of, 'm_total_sessions')),
        ) + $fields_map);

        return array($title, $content, $order, 'tabs/member_account/profile');
    }
}
