<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    news
 */

/**
 * Hook class.
 */
class Hook_page_groupings_news
{
    /**
     * Run function for do_next_menu hooks. They find links to put on standard navigation menus of the system.
     *
     * @param  ?MEMBER $member_id Member ID to run as (null: current member)
     * @param  boolean $extensive_docs Whether to use extensive documentation tooltips, rather than short summaries
     * @return array List of tuple of links (page grouping, icon, do-next-style linking data), label, help (optional) and/or nulls
     */
    public function run($member_id = null, $extensive_docs = false)
    {
        if (!addon_installed('news')) {
            return array();
        }

        $cnt = @intval($GLOBALS['SITE_DB']->query_select_value_if_there('news', 'COUNT(*)', null, '', true));
        $cnt_blogs = $cnt - @intval($GLOBALS['SITE_DB']->query_select_value_if_there('news n LEFT JOIN ' . get_table_prefix() . 'news_categories c ON c.id=n.news_category', 'COUNT(*)', array('nc_owner' => null), '', true));

        return array(
            has_privilege(get_member(), 'submit_highrange_content', 'cms_news') ? array('cms', 'menu/rich_content/news', array('cms_news', array('type' => 'browse'), get_module_zone('cms_news')), do_lang_tempcode('ITEMS_HERE', do_lang_tempcode('NEWS'), make_string_tempcode(escape_html(integer_format($cnt)))), 'news:DOC_NEWS') : null,
            has_privilege(get_member(), 'submit_highrange_content', 'cms_blogs') ? array('cms', 'tabs/member_account/blog', array('cms_blogs', array('type' => 'browse'), get_module_zone('cms_blogs')), do_lang_tempcode('ITEMS_HERE', do_lang_tempcode('news:BLOGS'), make_string_tempcode(escape_html(integer_format($cnt_blogs)))), 'news:DOC_BLOGS') : null,
            array('rich_content', 'menu/rich_content/news', array('news', array(), get_module_zone('news')), do_lang_tempcode('NEWS')),
        );
    }
}
