<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core
 */

/**
 * Hook class.
 */
class Hook_cron_dynamic_firewall
{
    /**
     * Run function for CRON hooks. Searches for tasks to perform.
     */
    public function run()
    {
        if (get_option('dynamic_firewall') == '0') {
            return;
        }

        $last_time = intval(get_value('dynamic_firewall_time', null, true));
        if (time() >= $last_time + 60 * 60 * 6) {
            $rules_path = get_custom_file_base() . '/data_custom/firewall_rules.txt';

            if (is_writable_wrap($rules_path)) {
                require_code('version2');

                $new_contents = @http_download_file('https://compo.sr/data_custom/firewall_rules.txt?version=' . urlencode(get_version_dotted()), null, false);

                if (!empty($new_contents)) {
                    require_code('files');
                    cms_file_put_contents_safe($rules_path, $new_contents, FILE_WRITE_FIX_PERMISSIONS | FILE_WRITE_SYNC_FILE);
                }

                set_value('dynamic_firewall_time', strval(time()), true);
            }
        }
    }
}
