<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    commandr
 */

/**
 * Hook class.
 */
class Hook_commandr_command_ls
{
    /**
     * Run function for Commandr hooks.
     *
     * @param  array $options The options with which the command was called
     * @param  array $parameters The parameters with which the command was called
     * @param  object $commandr_fs A reference to the Commandr filesystem object
     * @return array Array of stdcommand, stdhtml, stdout, and stderr responses
     */
    public function run($options, $parameters, &$commandr_fs)
    {
        if ((array_key_exists('h', $options)) || (array_key_exists('help', $options))) {
            return array('', do_command_help('ls', array('h'), array(true)), '', '');
        } else {
            if (!array_key_exists(0, $parameters)) {
                $dir = $commandr_fs->print_working_directory(true);
            } else {
                $dir = $commandr_fs->_pwd_to_array($parameters[0]);

                if ((!$commandr_fs->_is_dir($dir)) && (strpos($parameters[0], '*') === false)) {
                    return array('', '', '', do_lang('NOT_A_DIR', '1'));
                }
            }

            $listing = $commandr_fs->listing($dir);

            return array(
                '',
                do_template('COMMANDR_LS', array(
                    '_GUID' => '705c3382e34e3d73479521bb8d05902f',
                    'DIRECTORY' => $commandr_fs->pwd_to_string($dir),
                    'DIRECTORIES' => $commandr_fs->prepare_dir_contents_for_listing($listing[0]),
                    'FILES' => $commandr_fs->prepare_dir_contents_for_listing($listing[1]),
                )),
                '',
                ''
            );
        }
    }
}
