<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    tickets
 */

/**
 * Hook class.
 */
class Hook_change_detection_tickets
{
    /**
     * Run function for change_detection hooks. They see if their own something has changed in comparison to sample data.
     *
     * @param  string $data The sample data, serialised and then MD5'd
     * @return boolean Whether the something has changed
     */
    public function run($data)
    {
        if (get_param_string('type', 'browse') == 'browse') {
            require_code('tickets');
            require_code('tickets2');
            $ticket_type_id = get_param_integer('ticket_type_id', null);
            $tickets = get_tickets(get_member(), $ticket_type_id);
            return md5(serialize($tickets)) != $data;
        }

        $id = get_param_string('id', null);
        require_code('tickets');
        require_code('tickets2');
        $forum = 0;
        $topic_id = 0;
        $ticket_type_id = 0;
        require_lang('tickets');
        $_comments = get_ticket_posts($id, $forum, $topic_id, $ticket_type_id);

        return md5(serialize(is_array($_comments) ? count($_comments) : 0)) != $data;
    }
}
