<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    unvalidated
 */

/**
 * Hook class.
 */
class Hook_addon_registry_unvalidated
{
    /**
     * Get a list of file permissions to set
     *
     * @param  boolean $runtime Whether to include wildcards represented runtime-created chmoddable files
     * @return array File permissions to set
     */
    public function get_chmod_array($runtime = false)
    {
        return array();
    }

    /**
     * Get the version of Composr this addon is for
     *
     * @return float Version number
     */
    public function get_version()
    {
        return cms_version_number();
    }

    /**
     * Get the description of the addon
     *
     * @return string Description of the addon
     */
    public function get_description()
    {
        return 'Subject member\'s to validation (approval) of their content submissions, and enable/disable content.';
    }

    /**
     * Get a list of tutorials that apply to this addon
     *
     * @return array List of tutorials
     */
    public function get_applicable_tutorials()
    {
        return array(
            'tut_censor',
        );
    }

    /**
     * Get a mapping of dependency types
     *
     * @return array File permissions to set
     */
    public function get_dependencies()
    {
        return array(
            'requires' => array(),
            'recommends' => array(),
            'conflicts_with' => array(),
            'previously_in_addon' => array('core_unvalidated'),
        );
    }

    /**
     * Explicitly say which icon should be used
     *
     * @return URLPATH Icon
     */
    public function get_default_icon()
    {
        return 'themes/default/images/icons/48x48/menu/adminzone/audit/unvalidated.png';
    }

    /**
     * Get a list of files that belong to this addon
     *
     * @return array List of files
     */
    public function get_file_list()
    {
        return array(
            'themes/default/images/icons/24x24/menu/adminzone/audit/unvalidated.png',
            'themes/default/images/icons/48x48/menu/adminzone/audit/unvalidated.png',
            'sources/hooks/systems/notifications/content_validated.php',
            'sources/hooks/systems/notifications/needs_validation.php',
            'sources/hooks/systems/addon_registry/unvalidated.php',
            'themes/default/templates/UNVALIDATED_SCREEN.tpl',
            'themes/default/templates/UNVALIDATED_SECTION.tpl',
            'themes/default/text/VALIDATION_REQUEST_MAIL.txt',
            'adminzone/pages/modules/admin_unvalidated.php',
            'lang/EN/unvalidated.ini',
            'sources/hooks/blocks/main_staff_checklist/unvalidated.php',
            'sources/hooks/modules/admin_unvalidated/.htaccess',
            'sources_custom/hooks/modules/admin_unvalidated/.htaccess',
            'sources/hooks/modules/admin_unvalidated/index.html',
            'sources_custom/hooks/modules/admin_unvalidated/index.html',
            'sources/hooks/systems/page_groupings/unvalidated.php',
        );
    }

    /**
     * Get mapping between template names and the method of this class that can render a preview of them
     *
     * @return array The mapping
     */
    public function tpl_previews()
    {
        return array(
            'templates/UNVALIDATED_SECTION.tpl' => 'administrative__unvalidated_screen',
            'templates/UNVALIDATED_SCREEN.tpl' => 'administrative__unvalidated_screen',
            'text/VALIDATION_REQUEST_MAIL.txt' => 'administrative__validation_request_mail'
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__validation_request_mail()
    {
        return array(
            lorem_globalise(do_lorem_template('VALIDATION_REQUEST_MAIL', array(
                'USERNAME' => lorem_word(),
                'TYPE' => lorem_phrase(),
                'ID' => placeholder_id(),
                'URL' => placeholder_url(),
            ), null, false, null, '.txt', 'text'), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__unvalidated_screen()
    {
        $section = do_lorem_template('UNVALIDATED_SECTION', array(
            'TITLE' => lorem_phrase(),
            'CONTENT' => lorem_phrase(),
        ));
        return array(
            lorem_globalise(do_lorem_template('UNVALIDATED_SCREEN', array(
                'TITLE' => lorem_title(),
                'SECTIONS' => $section,
            )), null, '', true)
        );
    }
}
