<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    ecommerce
 */

/**
 * Hook class.
 */
class Hook_addon_registry_ecommerce
{
    /**
     * Get a list of file permissions to set
     *
     * @param  boolean $runtime Whether to include wildcards represented runtime-created chmoddable files
     * @return array File permissions to set
     */
    public function get_chmod_array($runtime = false)
    {
        return array();
    }

    /**
     * Get the version of Composr this addon is for
     *
     * @return float Version number
     */
    public function get_version()
    {
        return cms_version_number();
    }

    /**
     * Get the description of the addon
     *
     * @return string Description of the addon
     */
    public function get_description()
    {
        return 'eCommerce infrastructure, with support for digital purchase and usergroup subscriptions. Accounting functionality.';
    }

    /**
     * Get a list of tutorials that apply to this addon
     *
     * @return array List of tutorials
     */
    public function get_applicable_tutorials()
    {
        return array(
            'tut_ecommerce',
        );
    }

    /**
     * Get a mapping of dependency types
     *
     * @return array File permissions to set
     */
    public function get_dependencies()
    {
        return array(
            'requires' => array(),
            'recommends' => array(),
            'conflicts_with' => array(),
        );
    }

    /**
     * Explicitly say which icon should be used
     *
     * @return URLPATH Icon
     */
    public function get_default_icon()
    {
        return 'themes/default/images/icons/48x48/menu/adminzone/audit/ecommerce/ecommerce.png';
    }

    /**
     * Get a list of files that belong to this addon
     *
     * @return array List of files
     */
    public function get_file_list()
    {
        return array(
            'themes/default/images/icons/24x24/menu/adminzone/audit/ecommerce/ecommerce.png',
            'themes/default/images/icons/48x48/menu/adminzone/audit/ecommerce/ecommerce.png',
            'themes/default/images/icons/24x24/menu/adminzone/audit/ecommerce/subscriptions.png',
            'themes/default/images/icons/48x48/menu/adminzone/audit/ecommerce/subscriptions.png',
            'themes/default/images/icons/24x24/menu/rich_content/ecommerce/purchase.png',
            'themes/default/images/icons/48x48/menu/rich_content/ecommerce/purchase.png',
            'themes/default/images/icons/24x24/menu/adminzone/audit/ecommerce/cash_flow.png',
            'themes/default/images/icons/24x24/menu/adminzone/audit/ecommerce/invoices.png',
            'themes/default/images/icons/24x24/menu/adminzone/audit/ecommerce/profit_loss.png',
            'themes/default/images/icons/24x24/menu/adminzone/audit/ecommerce/transactions.png',
            'themes/default/images/icons/48x48/menu/adminzone/audit/ecommerce/cash_flow.png',
            'themes/default/images/icons/48x48/menu/adminzone/audit/ecommerce/invoices.png',
            'themes/default/images/icons/48x48/menu/adminzone/audit/ecommerce/profit_loss.png',
            'themes/default/images/icons/48x48/menu/adminzone/audit/ecommerce/transactions.png',
            'themes/default/images/icons/24x24/menu/adminzone/audit/ecommerce/create_invoice.png',
            'themes/default/images/icons/24x24/menu/adminzone/audit/ecommerce/outstanding_invoices.png',
            'themes/default/images/icons/24x24/menu/adminzone/audit/ecommerce/undelivered_invoices.png',
            'themes/default/images/icons/48x48/menu/adminzone/audit/ecommerce/create_invoice.png',
            'themes/default/images/icons/48x48/menu/adminzone/audit/ecommerce/outstanding_invoices.png',
            'themes/default/images/icons/48x48/menu/adminzone/audit/ecommerce/undelivered_invoices.png',
            'themes/default/images/icons/24x24/menu/adminzone/audit/ecommerce/index.html',
            'themes/default/images/icons/24x24/menu/rich_content/ecommerce/index.html',
            'themes/default/images/icons/48x48/menu/adminzone/audit/ecommerce/index.html',
            'themes/default/images/icons/48x48/menu/rich_content/ecommerce/index.html',
            'sources/hooks/systems/config_categories/ecommerce.php',
            'sources/hooks/systems/resource_meta_aware/usergroup_subscription.php',
            'sources/hooks/systems/commandr_fs/usergroup_subscriptions.php',
            'sources/hooks/systems/config/callback_password.php',
            'sources/hooks/systems/config/currency.php',
            'sources/hooks/systems/config/currency_api_key.php',
            'sources/hooks/systems/config/ecommerce_test_mode.php',
            'sources/hooks/systems/config/ipn.php',
            'sources/hooks/systems/config/ipn_digest.php',
            'sources/hooks/systems/config/ipn_password.php',
            'sources/hooks/systems/config/ipn_test.php',
            'sources/hooks/systems/config/payment_gateway.php',
            'sources/hooks/systems/config/pd_address.php',
            'sources/hooks/systems/config/pd_email.php',
            'sources/hooks/systems/config/pd_number.php',
            'sources/hooks/systems/config/use_local_payment.php',
            'sources/hooks/systems/config/vpn_password.php',
            'sources/hooks/systems/config/vpn_username.php',
            'sources/hooks/systems/realtime_rain/ecommerce.php',
            'sources/hooks/systems/addon_registry/ecommerce.php',
            'sources/hooks/modules/admin_import_types/ecommerce.php',
            'themes/default/templates/ECOM_CASH_FLOW_SCREEN.tpl',
            'themes/default/templates/ECOM_INVOICES_SCREEN.tpl',
            'themes/default/templates/ECOM_OUTSTANDING_INVOICES_SCREEN.tpl',
            'themes/default/templates/ECOM_SUBSCRIPTIONS_SCREEN.tpl',
            'themes/default/templates/PURCHASE_WIZARD_SCREEN.tpl',
            'themes/default/templates/PURCHASE_WIZARD_STAGE_CHOOSE.tpl',
            'themes/default/templates/PURCHASE_WIZARD_STAGE_DETAILS.tpl',
            'themes/default/templates/PURCHASE_WIZARD_STAGE_FINISH.tpl',
            'themes/default/templates/PURCHASE_WIZARD_STAGE_GUEST.tpl',
            'themes/default/templates/PURCHASE_WIZARD_STAGE_TERMS.tpl',
            'themes/default/templates/PURCHASE_WIZARD_STAGE_MESSAGE.tpl',
            'themes/default/templates/PURCHASE_WIZARD_STAGE_PAY.tpl',
            'themes/default/templates/PURCHASE_WIZARD_STAGE_SUBSCRIBE.tpl',
            'themes/default/templates/PURCHASE_WIZARD_STAGE_TRANSACT.tpl',
            'themes/default/templates/ECOM_BUTTON_VIA_PAYPAL.tpl',
            'themes/default/templates/ECOM_BUTTON_VIA_SECPAY.tpl',
            'themes/default/templates/ECOM_BUTTON_VIA_WORLDPAY.tpl',
            'themes/default/templates/ECOM_BUTTON_VIA_CCBILL.tpl',
            'themes/default/templates/ECOM_CANCEL_BUTTON_VIA_PAYPAL.tpl',
            'themes/default/templates/ECOM_CANCEL_BUTTON_VIA_SECPAY.tpl',
            'themes/default/templates/ECOM_CANCEL_BUTTON_VIA_WORLDPAY.tpl',
            'themes/default/templates/ECOM_CANCEL_BUTTON_VIA_CCBILL.tpl',
            'themes/default/templates/ECOM_LOGOS_WORLDPAY.tpl',
            'themes/default/templates/ECOM_SUBSCRIPTION_BUTTON_VIA_PAYPAL.tpl',
            'themes/default/templates/ECOM_SUBSCRIPTION_BUTTON_VIA_SECPAY.tpl',
            'themes/default/templates/ECOM_SUBSCRIPTION_BUTTON_VIA_WORLDPAY.tpl',
            'themes/default/templates/ECOM_SUBSCRIPTION_BUTTON_VIA_CCBILL.tpl',
            'themes/default/templates/ECOM_TRANSACTION_LOGS_MANUAL_TRIGGER.tpl',
            'themes/default/templates/ECOM_TRANSACTION_LOGS_SCREEN.tpl',
            'themes/default/templates/ECOM_VIEW_MANUAL_TRANSACTIONS_LINE.tpl',
            'themes/default/templates/ECOM_VIEW_MANUAL_TRANSACTIONS_SCREEN.tpl',
            'themes/default/templates/MEMBER_SUBSCRIPTION_STATUS.tpl',
            'sources/hooks/systems/cron/manual_subscription_notification.php',
            'sources/hooks/systems/cron/subscription_mails.php',
            'adminzone/pages/modules/admin_ecommerce.php',
            'adminzone/pages/modules/admin_ecommerce_logs.php',
            'adminzone/pages/modules/admin_invoices.php',
            'themes/default/css/ecommerce.css',
            'data/ecommerce.php',
            'lang/EN/ecommerce.ini',
            'sources/hooks/systems/notifications/paid_subscription_messages.php',
            'sources/hooks/systems/notifications/payment_received.php',
            'sources/hooks/systems/notifications/invoice.php',
            'sources/hooks/systems/notifications/subscription_cancelled_staff.php',
            'sources/hooks/systems/notifications/service_cancelled_staff.php',
            'sources/hooks/systems/notifications/service_paid_for_staff.php',
            'sources/ecommerce.php',
            'sources/ecommerce2.php',
            'sources/ecommerce_subscriptions.php',
            'sources/hooks/systems/config/manual_subscription_expiry_notice.php',
            'sources/hooks/modules/members/ecommerce.php',
            'sources/hooks/systems/page_groupings/ecommerce.php',
            'sources/hooks/systems/ecommerce/.htaccess',
            'sources_custom/hooks/systems/ecommerce/.htaccess',
            'sources/hooks/systems/ecommerce/index.html',
            'sources_custom/hooks/systems/ecommerce/index.html',
            'sources/hooks/systems/ecommerce/interest.php',
            'sources/hooks/systems/ecommerce/other.php',
            'sources/hooks/systems/ecommerce/tax.php',
            'sources/hooks/systems/ecommerce/usergroup.php',
            'sources/hooks/systems/ecommerce/wage.php',
            'sources/hooks/systems/ecommerce/work.php',
            'sources/hooks/systems/ecommerce_via/.htaccess',
            'sources_custom/hooks/systems/ecommerce_via/.htaccess',
            'sources/hooks/systems/ecommerce_via/index.html',
            'sources_custom/hooks/systems/ecommerce_via/index.html',
            'sources/hooks/systems/ecommerce_via/paypal.php',
            'sources/hooks/systems/ecommerce_via/secpay.php',
            'sources/hooks/systems/ecommerce_via/worldpay.php',
            'sources/hooks/systems/ecommerce_via/ccbill.php',
            'sources/hooks/systems/cns_cpf_filter/ecommerce.php',
            'site/pages/modules/purchase.php',
            'site/pages/modules/subscriptions.php',
            'site/pages/modules/invoices.php',
            'sources/currency.php',
            'sources/hooks/systems/config/primary_paypal_email.php',
            'sources/hooks/systems/config/max_ip_addresses_per_subscriber.php',
            'sources/hooks/systems/notifications/ip_address_sharing.php',
            'sources/hooks/systems/cron/ip_address_sharing.php',
            'sources/hooks/systems/symbols/CURRENCY_SYMBOL.php',
            'sources/hooks/systems/commandr_fs_extended_member/invoices.php',
            'sources/hooks/systems/commandr_fs_extended_member/subscriptions.php',
        );
    }

    /**
     * Get mapping between template names and the method of this class that can render a preview of them
     *
     * @return array The mapping
     */
    public function tpl_previews()
    {
        return array(
            'templates/ECOM_OUTSTANDING_INVOICES_SCREEN.tpl' => 'administrative__ecom_outstanding_invoices_screen',
            'templates/ECOM_TRANSACTION_LOGS_MANUAL_TRIGGER.tpl' => 'ecom_subscriptions_screen',
            'templates/ECOM_TRANSACTION_LOGS_SCREEN.tpl' => 'administrative__ecom_transaction_logs_screen',
            'templates/ECOM_CASH_FLOW_SCREEN.tpl' => 'administrative__ecom_cash_flow_screen',
            'templates/PURCHASE_WIZARD_STAGE_TRANSACT.tpl' => 'purchase_wizard_stage_transact',
            'templates/PURCHASE_WIZARD_SCREEN.tpl' => 'purchase_wizard_screen',
            'templates/ECOM_LOGOS_WORLDPAY.tpl' => 'ecom_logos_worldpay',
            'templates/ECOM_BUTTON_VIA_WORLDPAY.tpl' => 'ecom_button_via_worldpay',
            'templates/ECOM_SUBSCRIPTION_BUTTON_VIA_WORLDPAY.tpl' => 'ecom_subscription_button_via_worldpay',
            'templates/ECOM_CANCEL_BUTTON_VIA_WORLDPAY.tpl' => 'ecom_cancel_button_via_worldpay',
            'templates/ECOM_BUTTON_VIA_PAYPAL.tpl' => 'ecom_button_via_paypal',
            'templates/ECOM_SUBSCRIPTION_BUTTON_VIA_PAYPAL.tpl' => 'ecom_subscription_button_via_paypal',
            'templates/ECOM_CANCEL_BUTTON_VIA_PAYPAL.tpl' => 'ecom_cancel_button_via_paypal',
            'templates/ECOM_BUTTON_VIA_SECPAY.tpl' => 'ecom_button_via_secpay',
            'templates/ECOM_SUBSCRIPTION_BUTTON_VIA_SECPAY.tpl' => 'ecom_subscription_button_via_secpay',
            'templates/ECOM_CANCEL_BUTTON_VIA_SECPAY.tpl' => 'ecom_cancel_button_via_secpay',
            'templates/ECOM_BUTTON_VIA_CCBILL.tpl' => 'ecom_button_via_ccbill',
            'templates/ECOM_SUBSCRIPTION_BUTTON_VIA_CCBILL.tpl' => 'ecom_subscription_button_via_ccbill',
            'templates/ECOM_CANCEL_BUTTON_VIA_CCBILL.tpl' => 'ecom_cancel_button_via_ccbill',
            'templates/PURCHASE_WIZARD_STAGE_GUEST.tpl' => 'purchase_wizard_stage_guest',
            'templates/PURCHASE_WIZARD_STAGE_CHOOSE.tpl' => 'purchase_wizard_stage_choose',
            'templates/PURCHASE_WIZARD_STAGE_MESSAGE.tpl' => 'purchase_wizard_stage_message',
            'templates/PURCHASE_WIZARD_STAGE_TERMS.tpl' => 'purchase_wizard_stage_terms',
            'templates/PURCHASE_WIZARD_STAGE_DETAILS.tpl' => 'purchase_wizard_stage_details',
            'templates/PURCHASE_WIZARD_STAGE_FINISH.tpl' => 'purchase_wizard_stage_finish',
            'templates/ECOM_INVOICES_SCREEN.tpl' => 'ecom_invoices_screen',
            'templates/ECOM_SUBSCRIPTIONS_SCREEN.tpl' => 'ecom_subscriptions_screen',
            'templates/PURCHASE_WIZARD_STAGE_SUBSCRIBE.tpl' => 'purchase_wizard_stage_subscribe',
            'templates/PURCHASE_WIZARD_STAGE_PAY.tpl' => 'purchase_wizard_stage_pay',
            'templates/ECOM_VIEW_MANUAL_TRANSACTIONS_LINE.tpl' => 'ecom_view_manual_transactions_screen',
            'templates/ECOM_VIEW_MANUAL_TRANSACTIONS_SCREEN.tpl' => 'ecom_view_manual_transactions_screen',
            'templates/MEMBER_SUBSCRIPTION_STATUS.tpl' => 'member_subscription_status_screen',
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__ecom_outstanding_invoices_screen()
    {
        $invoices = array();
        foreach (placeholder_array() as $invoice) {
            $invoices[] = array(
                'INVOICE_TITLE' => lorem_word(),
                'PROFILE_URL' => placeholder_url(),
                'USERNAME' => lorem_word_2(),
                'ID' => placeholder_id(),
                'STATE' => lorem_phrase(),
                'AMOUNT' => placeholder_number(),
                'TIME' => placeholder_date(),
                'NOTE' => lorem_phrase(),
                'TYPE_CODE' => lorem_phrase(),
            );
        }

        return array(
            lorem_globalise(do_lorem_template('ECOM_OUTSTANDING_INVOICES_SCREEN', array(
                'TITLE' => lorem_title(),
                'FROM' => lorem_phrase(),
                'INVOICES' => $invoices,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__ecom_transaction_logs_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('ECOM_TRANSACTION_LOGS_SCREEN', array(
                'TITLE' => lorem_title(),
                'PRODUCTS' => placeholder_options(),
                'URL' => placeholder_url(),
                'RESULTS_TABLE' => placeholder_table(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__ecom_cash_flow_screen()
    {
        $types = array();
        foreach (placeholder_array() as $v) {
            $types[] = array(
                'TYPE' => lorem_word(),
                'AMOUNT' => placeholder_number(),
                'SPECIAL' => placeholder_number(),
            );
        }
        return array(
            lorem_globalise(do_lorem_template('ECOM_CASH_FLOW_SCREEN', array(
                'TITLE' => lorem_title(),
                'TYPES' => $types,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__purchase_wizard_stage_transact()
    {
        return array(
            lorem_globalise(do_lorem_template('PURCHASE_WIZARD_STAGE_TRANSACT', array(
                'FIELDS' => placeholder_fields(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__purchase_wizard_screen()
    {
        $fields = do_lorem_template('PURCHASE_WIZARD_STAGE_TRANSACT', array(
            'FIELDS' => placeholder_fields(),
        ));

        return array(
            lorem_globalise(do_lorem_template('PURCHASE_WIZARD_SCREEN', array(
                'TITLE' => lorem_title(),
                'CONTENT' => $fields,
                'URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ecom_logos_worldpay()
    {
        return array(
            lorem_globalise(do_lorem_template('ECOM_LOGOS_WORLDPAY', array(
                'INST_ID' => placeholder_id(),
                'PD_ADDRESS' => lorem_phrase(),
                'PD_EMAIL' => lorem_word(),
                'PD_NUMBER' => placeholder_number(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ecom_button_via_worldpay()
    {
        return array(
            lorem_globalise(do_lorem_template('ECOM_BUTTON_VIA_WORLDPAY', array(
                'TYPE_CODE' => lorem_phrase(),
                'ITEM_NAME' => lorem_word(),
                'DIGEST' => lorem_phrase(),
                'TEST_MODE' => lorem_phrase(),
                'PURCHASE_ID' => placeholder_id(),
                'AMOUNT' => placeholder_number(),
                'CURRENCY' => lorem_phrase(),
                'USERNAME' => lorem_word(),
                'IPN_URL' => placeholder_url(),
                'EMAIL_ADDRESS' => lorem_word(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ecom_subscription_button_via_worldpay()
    {
        return array(
            lorem_globalise(do_lorem_template('ECOM_SUBSCRIPTION_BUTTON_VIA_WORLDPAY', array(
                'TYPE_CODE' => lorem_phrase(),
                'DIGEST' => lorem_phrase(),
                'TEST' => lorem_phrase(),
                'LENGTH' => lorem_phrase(),
                'LENGTH_UNITS_2' => lorem_phrase(),
                'ITEM_NAME' => lorem_word(),
                'PURCHASE_ID' => placeholder_id(),
                'AMOUNT' => placeholder_number(),
                'FIRST_REPEAT' => lorem_phrase(),
                'CURRENCY' => lorem_phrase(),
                'USERNAME' => lorem_word(),
                'IPN_URL' => placeholder_url(),
                'TEST_MODE' => true,
                'EMAIL_ADDRESS' => lorem_word(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ecom_cancel_button_via_worldpay()
    {
        return array(
            lorem_globalise(do_lorem_template('ECOM_CANCEL_BUTTON_VIA_WORLDPAY', array(
                'CANCEL_URL' => placeholder_url(),
                'PURCHASE_ID' => placeholder_id(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ecom_button_via_paypal()
    {
        return array(
            lorem_globalise(do_lorem_template('ECOM_BUTTON_VIA_PAYPAL', array(
                'TYPE_CODE' => lorem_phrase(),
                'ITEM_NAME' => lorem_word(),
                'PURCHASE_ID' => placeholder_id(),
                'AMOUNT' => placeholder_number(),
                'CURRENCY' => lorem_phrase(),
                'PAYMENT_ADDRESS' => lorem_word(),
                'IPN_URL' => placeholder_url(),
                'MEMBER_ADDRESS' => placeholder_array(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ecom_subscription_button_via_paypal()
    {
        return array(
            lorem_globalise(do_lorem_template('ECOM_SUBSCRIPTION_BUTTON_VIA_PAYPAL', array(
                'TYPE_CODE' => lorem_phrase(),
                'ITEM_NAME' => lorem_phrase(),
                'LENGTH' => lorem_phrase(),
                'LENGTH_UNITS' => lorem_phrase(),
                'PURCHASE_ID' => placeholder_id(),
                'AMOUNT' => placeholder_number(),
                'CURRENCY' => lorem_phrase(),
                'PAYMENT_ADDRESS' => lorem_word(),
                'IPN_URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ecom_cancel_button_via_paypal()
    {
        return array(
            lorem_globalise(do_lorem_template('ECOM_CANCEL_BUTTON_VIA_PAYPAL', array(
                'PURCHASE_ID' => placeholder_id(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ecom_button_via_secpay()
    {
        return array(
            lorem_globalise(do_lorem_template('ECOM_BUTTON_VIA_SECPAY', array(
                'TYPE_CODE' => lorem_phrase(),
                'DIGEST' => lorem_phrase(),
                'TEST' => lorem_phrase(),
                'TRANS_ID' => placeholder_id(),
                'ITEM_NAME' => lorem_phrase(),
                'PURCHASE_ID' => placeholder_id(),
                'AMOUNT' => placeholder_number(),
                'CURRENCY' => lorem_phrase(),
                'USERNAME' => lorem_word(),
                'IPN_URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ecom_subscription_button_via_secpay()
    {
        return array(
            lorem_globalise(do_lorem_template('ECOM_SUBSCRIPTION_BUTTON_VIA_SECPAY', array(
                'TYPE_CODE' => lorem_phrase(),
                'DIGEST' => lorem_phrase(),
                'TEST' => lorem_phrase(),
                'TRANS_ID' => placeholder_id(),
                'FIRST_REPEAT' => lorem_phrase(),
                'LENGTH' => lorem_phrase(),
                'LENGTH_UNITS_2' => lorem_phrase(),
                'ITEM_NAME' => lorem_phrase(),
                'PURCHASE_ID' => placeholder_id(),
                'AMOUNT' => placeholder_number(),
                'CURRENCY' => lorem_phrase(),
                'USERNAME' => lorem_word(),
                'IPN_URL' => placeholder_url(),
                'PRICE' => placeholder_number(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ecom_cancel_button_via_secpay()
    {
        return array(
            lorem_globalise(do_lorem_template('ECOM_CANCEL_BUTTON_VIA_SECPAY', array(
                'CANCEL_URL' => placeholder_url(),
                'PURCHASE_ID' => placeholder_id(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ecom_button_via_ccbill()
    {
        return array(
            lorem_globalise(do_lorem_template('ECOM_BUTTON_VIA_CCBILL', array(
                'TYPE_CODE' => lorem_phrase(),
                'ITEM_NAME' => lorem_phrase(),
                'PURCHASE_ID' => placeholder_id(),
                'AMOUNT' => placeholder_number(),
                'CURRENCY' => lorem_phrase(),
                'PAYMENT_ADDRESS' => lorem_paragraph(),
                'IPN_URL' => placeholder_url(),
                'TRANS_ID' => placeholder_id(),
                'MEMBER_ADDRESS' => placeholder_array(),
                'ACCOUNT_NUM' => placeholder_id(),
                'SUBACCOUNT_NUM' => placeholder_id(),
                'FORM_NAME' => placeholder_id(),
                'FORM_PERIOD' => placeholder_id(),
                'DIGEST' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ecom_subscription_button_via_ccbill()
    {
        return array(
            lorem_globalise(do_lorem_template('ECOM_SUBSCRIPTION_BUTTON_VIA_CCBILL', array(
                'TYPE_CODE' => lorem_phrase(),
                'ITEM_NAME' => lorem_phrase(),
                'LENGTH' => lorem_phrase(),
                'LENGTH_UNITS_2' => lorem_phrase(),
                'PURCHASE_ID' => placeholder_id(),
                'AMOUNT' => placeholder_number(),
                'CURRENCY' => lorem_phrase(),
                'PAYMENT_ADDRESS' => lorem_paragraph(),
                'IPN_URL' => placeholder_url(),
                'TRANS_ID' => placeholder_id(),
                'MEMBER_ADDRESS' => placeholder_array(),
                'ACCOUNT_NUM' => placeholder_id(),
                'SUBACCOUNT_NUM' => placeholder_id(),
                'FORM_NAME' => placeholder_id(),
                'FORM_PERIOD' => placeholder_id(),
                'DIGEST' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ecom_cancel_button_via_ccbill()
    {
        return array(
            lorem_globalise(do_lorem_template('ECOM_CANCEL_BUTTON_VIA_CCBILL', array(
                'CANCEL_URL' => placeholder_url(),
                'PURCHASE_ID' => placeholder_id(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__purchase_wizard_stage_guest()
    {
        require_lang('cns');

        return array(
            lorem_globalise(do_lorem_template('PURCHASE_WIZARD_STAGE_GUEST', array(
                'TEXT' => lorem_sentence_html(),
                'JAVASCRIPT' => '',
                'FORM' => placeholder_form(),
                'HIDDEN' => '',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__purchase_wizard_stage_choose()
    {
        return array(
            lorem_globalise(do_lorem_template('PURCHASE_WIZARD_STAGE_CHOOSE', array(
                'FIELDS' => placeholder_fields(),
                'TITLE' => lorem_title(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__purchase_wizard_stage_message()
    {
        return array(
            lorem_globalise(do_lorem_template('PURCHASE_WIZARD_STAGE_MESSAGE', array(
                'TITLE' => lorem_title(),
                'TEXT' => lorem_sentence_html(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__purchase_wizard_stage_terms()
    {
        require_lang('installer');

        return array(
            lorem_globalise(do_lorem_template('PURCHASE_WIZARD_STAGE_TERMS', array(
                'TITLE' => lorem_title(),
                'URL' => placeholder_url(),
                'TERMS' => lorem_paragraph(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__purchase_wizard_stage_details()
    {
        return array(
            lorem_globalise(do_lorem_template('PURCHASE_WIZARD_STAGE_DETAILS', array(
                'TEXT' => lorem_sentence_html(),
                'FIELDS' => placeholder_fields(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__purchase_wizard_stage_finish()
    {
        return array(
            lorem_globalise(do_lorem_template('PURCHASE_WIZARD_STAGE_FINISH', array(
                'TITLE' => lorem_title(),
                'MESSAGE' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ecom_invoices_screen()
    {
        $invoices = array();
        foreach (placeholder_array() as $k => $v) {
            $invoices[] = array(
                'TRANSACTION_BUTTON' => placeholder_button(),
                'INVOICE_TITLE' => lorem_phrase(),
                'INVOICE_ID' => placeholder_id(),
                'AMOUNT' => placeholder_number(),
                'TIME' => placeholder_date(),
                'STATE' => lorem_word(),
                'DELIVERABLE' => true,
                'PAYABLE' => lorem_word(),
                'NOTE' => lorem_phrase(),
                'TYPE_CODE' => lorem_word(),
            );
        }

        return array(
            lorem_globalise(do_lorem_template('ECOM_INVOICES_SCREEN', array(
                'TITLE' => lorem_title(),
                'CURRENCY' => lorem_phrase(),
                'INVOICES' => $invoices,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ecom_subscriptions_screen()
    {
        $button = do_lorem_template('ECOM_TRANSACTION_LOGS_MANUAL_TRIGGER', array(
            'STATUS' => lorem_phrase(),
            'TRIGGER_URL' => placeholder_url(),
        ));

        $subscriptions = array();
        foreach (placeholder_array() as $k => $v) {
            $subscriptions[] = array(
                'ITEM_NAME' => lorem_phrase(),
                'SUBSCRIPTION_ID' => placeholder_id(),
                'PER' => lorem_word(),
                'LENGTH' => placeholder_number(),
                'LENGTH_UNITS' => 'm',
                'AMOUNT' => placeholder_number(),
                '_START_TIME' => placeholder_date_raw(),
                '_TERM_START_TIME' => placeholder_date_raw(),
                '_TERM_END_TIME' => placeholder_date_raw(),
                '_EXPIRY_TIME' => placeholder_date_raw(),
                'START_TIME' => placeholder_date(),
                'TERM_START_TIME' => placeholder_date(),
                'TERM_END_TIME' => placeholder_date(),
                'EXPIRY_TIME' => placeholder_date(),
                'STATE' => lorem_word(),
                '_STATE' => lorem_word(),
                'TYPE_CODE' => lorem_word(),
                'CANCEL_BUTTON' => $button,
                'USERGROUP_SUBSCRIPTION_TITLE' => lorem_phrase(),
                'USERGROUP_SUBSCRIPTION_DESCRIPTION' => lorem_paragraph_html(),
                'USERGROUP_SUBSCRIPTION_ID' => placeholder_id(),
                'USERGROUP_ID' => placeholder_id(),
                'USERGROUP_NAME' => lorem_phrase(),
                '_VIA' => 'manual',
                'VIA' => lorem_word(),
            );
        }

        return array(
            lorem_globalise(do_lorem_template('ECOM_SUBSCRIPTIONS_SCREEN', array(
                'TITLE' => lorem_title(),
                'SUBSCRIPTIONS' => $subscriptions,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__purchase_wizard_stage_subscribe()
    {
        return array(
            lorem_globalise(do_lorem_template('PURCHASE_WIZARD_STAGE_SUBSCRIBE', array(
                'LOGOS' => placeholder_image(),
                'TRANSACTION_BUTTON' => placeholder_button(),
                'CURRENCY' => placeholder_number(),
                'ITEM_NAME' => lorem_word(),
                'TITLE' => lorem_phrase(),
                'LENGTH' => '3',
                'LENGTH_UNITS' => '$',
                'PURCHASE_ID' => placeholder_id(),
                'PRICE' => '123.45',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__purchase_wizard_stage_pay()
    {
        return array(
            lorem_globalise(do_lorem_template('PURCHASE_WIZARD_STAGE_PAY', array(
                'LOGOS' => placeholder_image(),
                'TRANSACTION_BUTTON' => placeholder_button(),
                'CURRENCY' => placeholder_number(),
                'ITEM_NAME' => lorem_word(),
                'TITLE' => lorem_phrase(),
                'LENGTH' => '3',
                'LENGTH_UNITS' => '$',
                'PURCHASE_ID' => placeholder_id(),
                'PRICE' => '123.45',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ecom_view_manual_transactions_screen()
    {
        $lines = do_lorem_template('ECOM_VIEW_MANUAL_TRANSACTIONS_LINE', array(
            'ID' => placeholder_id(),
            'SUBSCRIPTION' => lorem_title(),
            'ROWSPAN' => '1',
            'MEMBER' => placeholder_link(),
            'EXPIRY' => lorem_title(),
            'CANCEL_URL' => placeholder_url(),
        ));

        return array(
            lorem_globalise(do_lorem_template('ECOM_VIEW_MANUAL_TRANSACTIONS_SCREEN', array(
                'TITLE' => lorem_title(),
                'CONTENT' => $lines,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__member_subscription_status_screen()
    {
        $button = do_lorem_template('ECOM_TRANSACTION_LOGS_MANUAL_TRIGGER', array(
            'STATUS' => lorem_phrase(),
            'TRIGGER_URL' => placeholder_url(),
        ));

        $subscriptions = array();
        foreach (placeholder_array() as $k => $v) {
            $subscriptions[] = array(
                'ITEM_NAME' => lorem_phrase(),
                'SUBSCRIPTION_ID' => placeholder_id(),
                'PER' => lorem_word(),
                'LENGTH' => placeholder_number(),
                'LENGTH_UNITS' => 'm',
                'AMOUNT' => placeholder_number(),
                '_START_TIME' => placeholder_date_raw(),
                '_TERM_START_TIME' => placeholder_date_raw(),
                '_TERM_END_TIME' => placeholder_date_raw(),
                '_EXPIRY_TIME' => placeholder_date_raw(),
                'START_TIME' => placeholder_date(),
                'TERM_START_TIME' => placeholder_date(),
                'TERM_END_TIME' => placeholder_date(),
                'EXPIRY_TIME' => placeholder_date(),
                'STATE' => lorem_word(),
                '_STATE' => lorem_word(),
                'TYPE_CODE' => lorem_word(),
                'CANCEL_BUTTON' => $button,
                'USERGROUP_SUBSCRIPTION_TITLE' => lorem_phrase(),
                'USERGROUP_SUBSCRIPTION_DESCRIPTION' => lorem_paragraph_html(),
                'USERGROUP_SUBSCRIPTION_ID' => placeholder_id(),
                'USERGROUP_ID' => placeholder_id(),
                'USERGROUP_NAME' => lorem_phrase(),
                '_VIA' => 'manual',
                'VIA' => lorem_word(),
            );
        }

        return array(
            lorem_globalise(do_lorem_template('MEMBER_SUBSCRIPTION_STATUS', array(
                'MEMBER_ID' => placeholder_id(),
                'SUBSCRIPTIONS' => $subscriptions,
            )), null, '', true)
        );
    }
}
