<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_comcode_pages
 */

/**
 * Hook class.
 */
class Hook_addon_registry_core_comcode_pages
{
    /**
     * Get a list of file permissions to set
     *
     * @param  boolean $runtime Whether to include wildcards represented runtime-created chmoddable files
     * @return array File permissions to set
     */
    public function get_chmod_array($runtime = false)
    {
        return array();
    }

    /**
     * Get the version of Composr this addon is for
     *
     * @return float Version number
     */
    public function get_version()
    {
        return cms_version_number();
    }

    /**
     * Get the description of the addon
     *
     * @return string Description of the addon
     */
    public function get_description()
    {
        return 'Manage new pages on the website, known as Comcode pages.';
    }

    /**
     * Get a list of tutorials that apply to this addon
     *
     * @return array List of tutorials
     */
    public function get_applicable_tutorials()
    {
        return array(
            'tut_comcode_pages',
            'tut_adv_comcode_pages',
            'tut_information',
        );
    }

    /**
     * Get a mapping of dependency types
     *
     * @return array File permissions to set
     */
    public function get_dependencies()
    {
        return array(
            'requires' => array(),
            'recommends' => array(),
            'conflicts_with' => array(),
        );
    }

    /**
     * Explicitly say which icon should be used
     *
     * @return URLPATH Icon
     */
    public function get_default_icon()
    {
        return 'themes/default/images/icons/48x48/menu/cms/comcode_page_edit.png';
    }

    /**
     * Get a list of files that belong to this addon
     *
     * @return array List of files
     */
    public function get_file_list()
    {
        return array(
            'themes/default/images/icons/24x24/menu/cms/comcode_page_edit.png',
            'themes/default/images/icons/48x48/menu/cms/comcode_page_edit.png',
            'sources/hooks/systems/config/points_COMCODE_PAGE_ADD.php',
            'sources/hooks/systems/addon_registry/core_comcode_pages.php',
            'themes/default/templates/COMCODE_PAGE_EDIT_ACTIONS.tpl',
            'themes/default/templates/COMCODE_PAGE_BOX.tpl',
            'themes/default/templates/GENERATE_PAGE_SITEMAP.tpl',
            'themes/default/templates/GENERATE_PAGE_SITEMAP_SCREEN.tpl',
            'sources/hooks/modules/search/comcode_pages.php',
            'sources/hooks/systems/content_meta_aware/comcode_page.php',
            'sources/hooks/systems/commandr_fs/comcode_pages.php',
            'themes/default/templates/COMCODE_PAGE_SCREEN.tpl',
            'sources/hooks/systems/rss/comcode_pages.php',
            'sources/hooks/systems/cleanup/comcode_pages.php',
            'cms/pages/modules/cms_comcode_pages.php',
            'sources/hooks/systems/preview/comcode_page.php',
            'sources/hooks/systems/attachments/comcode_page.php',
            'sources/hooks/modules/admin_unvalidated/comcode_pages.php',
            'sources/hooks/modules/admin_newsletter/comcode_pages.php',
            'sources/hooks/systems/config/comcode_page_default_review_freq.php',
            'sources/hooks/systems/config/is_on_comcode_page_children.php',
            'sources/hooks/systems/sitemap/comcode_page.php',
            'themes/default/templates/COMCODE_PAGE_MANAGE_SCREEN.tpl',
            'data/modules/cms_comcode_pages/.htaccess',
            'data/modules/cms_comcode_pages/index.html',
            'data/modules/cms_comcode_pages/EN/.htaccess',
            'data/modules/cms_comcode_pages/EN/index.html',
            'data/modules/cms_comcode_pages/EN/about_us.txt',
            'data/modules/cms_comcode_pages/EN/advertise.txt',
            'data/modules/cms_comcode_pages/EN/article.txt',
            'data/modules/cms_comcode_pages/EN/competitor_comparison.txt',
            'data/modules/cms_comcode_pages/EN/contact_us.txt',
            'data/modules/cms_comcode_pages/EN/donate.txt',
            'data/modules/cms_comcode_pages/EN/guestbook.txt',
            'data/modules/cms_comcode_pages/EN/press_release.txt',
            'data/modules/cms_comcode_pages/EN/pricing.txt',
            'data/modules/cms_comcode_pages/EN/landing_page.txt',
            'data/modules/cms_comcode_pages/EN/two_column_layout.txt',
            'data/modules/cms_comcode_pages/EN/under_construction.txt',
            'data/modules/cms_comcode_pages/EN/rules_balanced.txt',
            'data/modules/cms_comcode_pages/EN/rules_corporate.txt',
            'data/modules/cms_comcode_pages/EN/rules_liberal.txt',
            'data_custom/modules/cms_comcode_pages/.htaccess',
            'data_custom/modules/cms_comcode_pages/index.html',
            'themes/default/images/under_construction_animated.gif',
            'themes/default/images/icons/24x24/menu/pages/guestbook.png',
            'themes/default/images/icons/48x48/menu/pages/guestbook.png',
            'themes/default/images/icons/24x24/menu/pages/advertise.png',
            'themes/default/images/icons/24x24/menu/pages/donate.png',
            'themes/default/images/icons/48x48/menu/pages/donate.png',
            'themes/default/images/icons/48x48/menu/pages/advertise.png',
            'themes/default/images/icons/24x24/contact_methods/address.png',
            'themes/default/images/icons/24x24/contact_methods/email.png',
            'themes/default/images/icons/24x24/contact_methods/index.html',
            'themes/default/images/icons/24x24/contact_methods/telephone.png',
            'themes/default/images/icons/48x48/contact_methods/address.png',
            'themes/default/images/icons/48x48/contact_methods/email.png',
            'themes/default/images/icons/48x48/contact_methods/index.html',
            'themes/default/images/icons/48x48/contact_methods/telephone.png',
            'themes/default/images/icons/24x24/links/google_plus.png',
            'themes/default/images/icons/24x24/links/skype.png',
            'themes/default/images/icons/24x24/links/xmpp.png',
            'themes/default/images/icons/48x48/links/google_plus.png',
            'themes/default/images/icons/48x48/links/skype.png',
            'themes/default/images/icons/48x48/links/xmpp.png',
            'themes/default/images/icons/24x24/tiers/bronze.png',
            'themes/default/images/icons/24x24/tiers/gold.png',
            'themes/default/images/icons/24x24/tiers/index.html',
            'themes/default/images/icons/24x24/tiers/platinum.png',
            'themes/default/images/icons/24x24/tiers/silver.png',
            'themes/default/images/icons/48x48/tiers/bronze.png',
            'themes/default/images/icons/48x48/tiers/gold.png',
            'themes/default/images/icons/48x48/tiers/index.html',
            'themes/default/images/icons/48x48/tiers/platinum.png',
            'themes/default/images/icons/48x48/tiers/silver.png',
        );
    }

    /**
     * Get mapping between template names and the method of this class that can render a preview of them
     *
     * @return array The mapping
     */
    public function tpl_previews()
    {
        return array(
            'templates/COMCODE_PAGE_SCREEN.tpl' => 'comcode_page_screen',
            'templates/COMCODE_PAGE_EDIT_ACTIONS.tpl' => 'comcode_page_edit_actions',
            'templates/COMCODE_PAGE_BOX.tpl' => 'comcode_page_preview',
            'templates/GENERATE_PAGE_SITEMAP.tpl' => 'administrative__comcode_page_sitemap',
            'templates/GENERATE_PAGE_SITEMAP_SCREEN.tpl' => 'administrative__comcode_page_sitemap',
            'templates/COMCODE_PAGE_MANAGE_SCREEN.tpl' => 'administrative__comcode_page_manage_screen'
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__comcode_page_manage_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_PAGE_MANAGE_SCREEN', array(
                'TITLE' => lorem_title(),
                'TABLE' => placeholder_table(),
                'SUBMIT_NAME' => lorem_word(),
                'URL' => placeholder_url(),
                'TEXT' => lorem_paragraph_html(),
                'LINKS' => array(array(
                    'LINK_IMAGE' => placeholder_image_url(),
                    'LINK_URL' => placeholder_url(),
                    'LINK_TEXT' => lorem_phrase(),
                )),
                'FILTER' => '',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_page_edit_actions()
    {
        require_lang('zones');

        return array(
            lorem_globalise(do_lorem_template('COMCODE_PAGE_EDIT_ACTIONS', array(
                'EDIT_URL' => placeholder_url(),
                'CLONE_URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_page_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_PAGE_SCREEN', array(
                'BEING_INCLUDED' => false,
                'IS_PANEL' => false,
                'SUBMITTER' => placeholder_id(),
                'TAGS' => lorem_word_html(),
                'WARNING_DETAILS' => '',
                'EDIT_DATE_RAW' => placeholder_date_raw(),
                'SHOW_AS_EDIT' => lorem_phrase(),
                'CONTENT' => lorem_phrase(),
                'EDIT_URL' => placeholder_url(),
                'ADD_CHILD_URL' => placeholder_url(),
                'NAME' => placeholder_id(),
                'NATIVE_ZONE' => lorem_word(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_page_preview()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_PAGE_BOX', array(
                'GIVE_CONTEXT' => true,
                'PAGE' => lorem_phrase(),
                'ZONE' => lorem_phrase(),
                'URL' => placeholder_url(),
                'SUMMARY' => lorem_paragraph_html(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__comcode_page_sitemap()
    {
        require_lang('zones');

        $menu_paths = array();
        $menu_paths[] = array(
            'MENU' => lorem_phrase(),
            'MENU_URL' => placeholder_url(),
            'MENU_PATH_COMPONENTS' => array(lorem_phrase()),
        );

        $_page_structure = array();
        $_page_structure[] = array(
            'EDIT_URL' => placeholder_url(),
            'ZONE_NAME' => lorem_phrase(),
            'PAGE_NAME' => lorem_phrase(),
            'PAGE_TITLE' => lorem_phrase(),
            'VALIDATED' => false,
            'TODO' => false,
            'MENU_PATHS' => $menu_paths,
            'CHILDREN' => '',
        );

        $page_structure = do_lorem_template('GENERATE_PAGE_SITEMAP', array(
            'PAGE_STRUCTURE' => $_page_structure,
        ));

        return array(
            lorem_globalise(do_lorem_template('GENERATE_PAGE_SITEMAP_SCREEN', array(
                'TITLE' => lorem_title(),
                'ZONES' => array(lorem_phrase() => lorem_phrase()),
                'PAGE_STRUCTURE' => $page_structure,
            )), null, '', true)
        );
    }
}
