<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    cns_forum
 */

/**
 * Hook class.
 */
class Hook_addon_registry_cns_forum
{
    /**
     * Get a list of file permissions to set
     *
     * @param  boolean $runtime Whether to include wildcards represented runtime-created chmoddable files
     * @return array File permissions to set
     */
    public function get_chmod_array($runtime = false)
    {
        return array();
    }

    /**
     * Get the version of Composr this addon is for
     *
     * @return float Version number
     */
    public function get_version()
    {
        return cms_version_number();
    }

    /**
     * Get the description of the addon
     *
     * @return string Description of the addon
     */
    public function get_description()
    {
        return 'The Conversr forum- a modern advanced forum for members to interact on.';
    }

    /**
     * Get a list of tutorials that apply to this addon
     *
     * @return array List of tutorials
     */
    public function get_applicable_tutorials()
    {
        return array(
            'tut_forums',
            'tut_forum_tracking',
            'tut_moderation',
            'tut_information',
        );
    }

    /**
     * Get a mapping of dependency types
     *
     * @return array File permissions to set
     */
    public function get_dependencies()
    {
        return array(
            'requires' => array(
                'polls',
            ),
            'recommends' => array(),
            'conflicts_with' => array(),
        );
    }

    /**
     * Explicitly say which icon should be used
     *
     * @return URLPATH Icon
     */
    public function get_default_icon()
    {
        return 'themes/default/images/icons/48x48/menu/social/forum/forums.png';
    }

    /**
     * Get a list of files that belong to this addon
     *
     * @return array List of files
     */
    public function get_file_list()
    {
        return array(
            'themes/default/images/icons/24x24/menu/social/forum/inline_personal_posts.png',
            'themes/default/images/icons/48x48/menu/social/forum/inline_personal_posts.png',
            'themes/default/images/icons/24x24/menu/adminzone/audit/statistics/posting_rates.png',
            'themes/default/images/icons/48x48/menu/adminzone/audit/statistics/posting_rates.png',
            'themes/default/images/icons/24x24/menu/social/forum/forums.png',
            'themes/default/images/icons/48x48/menu/social/forum/forums.png',
            'themes/default/images/icons/24x24/buttons/new_topic.png',
            'themes/default/images/icons/48x48/buttons/new_topic.png',
            'themes/default/images/icons/24x24/menu/social/forum/vforums/involved_topics.png',
            'themes/default/images/icons/24x24/menu/social/forum/vforums/posts_since_last_visit.png',
            'themes/default/images/icons/24x24/menu/social/forum/vforums/recently_read_topics.png',
            'themes/default/images/icons/24x24/menu/social/forum/vforums/unanswered_topics.png',
            'themes/default/images/icons/24x24/menu/social/forum/vforums/unread_topics.png',
            'themes/default/images/icons/48x48/menu/social/forum/vforums/involved_topics.png',
            'themes/default/images/icons/48x48/menu/social/forum/vforums/posts_since_last_visit.png',
            'themes/default/images/icons/48x48/menu/social/forum/vforums/recently_read_topics.png',
            'themes/default/images/icons/48x48/menu/social/forum/vforums/unanswered_topics.png',
            'themes/default/images/icons/48x48/menu/social/forum/vforums/unread_topics.png',
            'themes/default/images/icons/24x24/buttons/mark_read.png',
            'themes/default/images/icons/24x24/buttons/mark_unread.png',
            'themes/default/images/icons/48x48/buttons/mark_read.png',
            'themes/default/images/icons/48x48/buttons/mark_unread.png',
            'themes/default/images/icons/24x24/buttons/forum.png',
            'themes/default/images/icons/48x48/buttons/forum.png',
            'themes/default/images/icons/24x24/buttons/linear.png',
            'themes/default/images/icons/48x48/buttons/linear.png',
            'themes/default/images/icons/24x24/buttons/threaded.png',
            'themes/default/images/icons/48x48/buttons/threaded.png',
            'themes/default/images/icons/24x24/buttons/whisper.png',
            'themes/default/images/icons/48x48/buttons/whisper.png',
            'themes/default/images/icons/24x24/buttons/new_quote.png',
            'themes/default/images/icons/48x48/buttons/new_quote.png',
            'themes/default/images/icons/24x24/menu/adminzone/structure/forum/index.html',
            'themes/default/images/icons/24x24/menu/social/forum/index.html',
            'themes/default/images/icons/24x24/menu/social/forum/vforums/index.html',
            'themes/default/images/icons/48x48/menu/adminzone/structure/forum/index.html',
            'themes/default/images/icons/48x48/menu/social/forum/index.html',
            'themes/default/images/icons/48x48/menu/social/forum/vforums/index.html',
            'sources/hooks/systems/cns_cpf_filter/notifications.php',
            'sources/hooks/systems/resource_meta_aware/forum_grouping.php',
            'sources/hooks/systems/commandr_fs/forum_groupings.php',
            'sources/blocks/main_cns_involved_topics.php',
            'sources/hooks/systems/notifications/cns_topic_invite.php',
            'sources/hooks/systems/notifications/cns_new_pt.php',
            'sources/hooks/systems/notifications/cns_topic.php',
            'sources/hooks/systems/content_meta_aware/forum.php',
            'sources/hooks/systems/commandr_fs/forums.php',
            'sources/hooks/modules/admin_stats/cns_posting_rates.php',
            'sources/hooks/systems/sitemap/topic.php',
            'sources/hooks/systems/sitemap/forum.php',
            'themes/default/templates/CNS_FORUM_INTRO_QUESTION_POPUP.tpl',
            'themes/default/templates/CNS_MEMBER_PT_RULES_SCREEN.tpl',
            'themes/default/templates/CNS_PT_BETWEEN.tpl',
            'themes/default/javascript/cns_forum.js',
            'themes/default/templates/BLOCK_MAIN_CNS_INVOLVED_TOPICS.tpl',
            'themes/default/templates/CNS_VFORUM_FILTERING.tpl',
            'forum/rules.php',
            'themes/default/images/cns_general/redirect.png',
            'sources/hooks/modules/search/cns_within_topic.php',
            'sources/hooks/systems/addon_registry/cns_forum.php',
            'sources/hooks/systems/page_groupings/cns_forum.php',
            'sources/hooks/modules/admin_themewizard/cns_forum.php',
            'sources/hooks/modules/admin_import_types/cns_forum.php',
            'sources/hooks/systems/profiles_tabs/posts.php',
            'sources/hooks/systems/profiles_tabs/pts.php',
            'themes/default/templates/CNS_EDIT_FORUM_SCREEN.tpl',
            'themes/default/templates/CNS_EDIT_FORUM_SCREEN_GROUPING.tpl',
            'themes/default/templates/CNS_EDIT_FORUM_SCREEN_FORUM.tpl',
            'themes/default/templates/CNS_FORUM.tpl',
            'themes/default/templates/CNS_FORUM_SCREEN.tpl',
            'themes/default/templates/CNS_FORUM_GROUPING.tpl',
            'themes/default/templates/CNS_FORUM_INTRO_QUESTION_SCREEN.tpl',
            'themes/default/templates/CNS_FORUM_IN_GROUPING.tpl',
            'themes/default/templates/CNS_FORUM_LATEST.tpl',
            'themes/default/templates/CNS_FORUM_TOPIC_ROW.tpl',
            'themes/default/templates/CNS_FORUM_TOPIC_ROW_LAST_POST.tpl',
            'themes/default/templates/CNS_FORUM_TOPIC_WRAPPER.tpl',
            'themes/default/templates/CNS_GUEST_BAR.tpl',
            'themes/default/templates/CNS_GUEST_DETAILS.tpl',
            'themes/default/templates/CNS_POST_BOX.tpl',
            'themes/default/templates/CNS_MEMBER_BAR.tpl',
            'themes/default/templates/MEMBER_BAR_SEARCH.tpl',
            'themes/default/templates/CNS_NOTIFICATION.tpl',
            'themes/default/templates/BLOCK_MAIN_PT_NOTIFICATIONS.tpl',
            'themes/default/templates/CNS_MEMBER_PROFILE_PTS.tpl',
            'themes/default/templates/CNS_PINNED_DIVIDER.tpl',
            'themes/default/templates/CNS_POSTER_GUEST.tpl',
            'themes/default/templates/CNS_POSTER_MEMBER.tpl',
            'themes/default/templates/CNS_POSTING_SCREEN_POSTS.tpl',
            'themes/default/text/CNS_QUOTE_FCOMCODE.txt',
            'themes/default/templates/BLOCK_MAIN_BOTTOM_BAR.tpl',
            'themes/default/templates/CNS_TOPIC_FIRST_UNREAD.tpl',
            'themes/default/templates/CNS_TOPIC_MARKER.tpl',
            'themes/default/templates/CNS_TOPIC_POLL.tpl',
            'themes/default/templates/CNS_TOPIC_POLL_ANSWER.tpl',
            'themes/default/templates/CNS_TOPIC_POLL_ANSWER_RADIO.tpl',
            'themes/default/templates/CNS_TOPIC_POLL_ANSWER_RESULTS.tpl',
            'themes/default/templates/CNS_TOPIC_POLL_BUTTON.tpl',
            'themes/default/templates/CNS_TOPIC_POLL_VIEW_RESULTS.tpl',
            'themes/default/templates/CNS_TOPIC_POST.tpl',
            'themes/default/templates/CNS_TOPIC_SCREEN.tpl',
            'themes/default/templates/CNS_WHISPER_CHOICE_SCREEN.tpl',
            'themes/default/templates/BLOCK_SIDE_CNS_PRIVATE_TOPICS.tpl',
            'themes/default/templates/CNS_TOPIC_POST_LAST_EDITED.tpl',
            'themes/default/templates/CNS_FORUM_LIST_LINE.tpl',
            'themes/default/templates/CNS_FORUM_TOPIC_LIST_LINE.tpl',
            'themes/default/templates/CNS_VFORUM_SCREEN.tpl',
            'forum/index.php',
            'forum/pages/comcode/.htaccess',
            'forum/pages/comcode/EN/.htaccess',
            'forum/pages/comcode/EN/index.html',
            'forum/pages/comcode/EN/panel_right.txt',
            'forum/pages/comcode/index.html',
            'forum/pages/comcode_custom/.htaccess',
            'forum/pages/comcode_custom/EN/.htaccess',
            'forum/pages/comcode_custom/EN/index.html',
            'forum/pages/comcode_custom/index.html',
            'forum/pages/html/.htaccess',
            'forum/pages/html/EN/.htaccess',
            'forum/pages/html/EN/index.html',
            'forum/pages/html/index.html',
            'forum/pages/html_custom/EN/.htaccess',
            'forum/pages/html_custom/EN/index.html',
            'forum/pages/html_custom/index.html',
            'forum/pages/index.html',
            'forum/pages/minimodules/.htaccess',
            'forum/pages/minimodules/index.html',
            'forum/pages/minimodules_custom/.htaccess',
            'forum/pages/minimodules_custom/index.html',
            'forum/pages/modules/.htaccess',
            'forum/pages/modules/forumview.php',
            'forum/pages/modules/index.html',
            'forum/pages/modules/topics.php',
            'forum/pages/modules/topicview.php',
            'forum/pages/modules/vforums.php',
            'forum/pages/modules_custom/.htaccess',
            'forum/pages/modules_custom/index.html',
            'adminzone/pages/modules/admin_cns_forum_groupings.php',
            'adminzone/pages/modules/admin_cns_forums.php',
            'themes/default/images/cns_general/index.html',
            'themes/default/images/cns_general/new_posts.png',
            'themes/default/images/cns_general/new_posts_redirect.png',
            'themes/default/images/cns_general/no_new_posts.png',
            'themes/default/images/cns_general/no_new_posts_redirect.png',
            'themes/default/images/icons/14x14/cns_topic_modifiers/announcement.png',
            'themes/default/images/icons/14x14/cns_topic_modifiers/closed.png',
            'themes/default/images/icons/14x14/cns_topic_modifiers/hot.png',
            'themes/default/images/icons/14x14/cns_topic_modifiers/index.html',
            'themes/default/images/icons/14x14/cns_topic_modifiers/involved.png',
            'themes/default/images/icons/14x14/cns_topic_modifiers/pinned.png',
            'themes/default/images/icons/14x14/cns_topic_modifiers/poll.png',
            'themes/default/images/icons/14x14/cns_topic_modifiers/sunk.png',
            'themes/default/images/icons/14x14/cns_topic_modifiers/unread.png',
            'themes/default/images/icons/14x14/cns_topic_modifiers/unvalidated.png',
            'themes/default/images/icons/28x28/cns_topic_modifiers/announcement.png',
            'themes/default/images/icons/28x28/cns_topic_modifiers/closed.png',
            'themes/default/images/icons/28x28/cns_topic_modifiers/hot.png',
            'themes/default/images/icons/28x28/cns_topic_modifiers/index.html',
            'themes/default/images/icons/28x28/cns_topic_modifiers/involved.png',
            'themes/default/images/icons/28x28/cns_topic_modifiers/pinned.png',
            'themes/default/images/icons/28x28/cns_topic_modifiers/poll.png',
            'themes/default/images/icons/28x28/cns_topic_modifiers/sunk.png',
            'themes/default/images/icons/28x28/cns_topic_modifiers/unread.png',
            'themes/default/images/icons/28x28/cns_topic_modifiers/unvalidated.png',
            'sources/blocks/side_cns_private_topics.php',
            'sources/hooks/systems/cleanup/cns_topics.php',
            'sources/hooks/modules/admin_newsletter/cns_forumview.php',
            'sources/hooks/modules/admin_unvalidated/cns_posts.php',
            'sources/hooks/modules/admin_unvalidated/cns_topics.php',
            'sources/hooks/modules/search/cns_own_pt.php',
            'sources/hooks/modules/search/cns_posts.php',
            'sources/hooks/systems/attachments/cns_post.php',
            'sources/hooks/systems/preview/cns_post.php',
            'sources/hooks/systems/rss/cns_forumview.php',
            'sources/hooks/systems/rss/cns_topicview.php',
            'sources/blocks/main_bottom_bar.php',
            'sources/blocks/main_member_bar.php',
            'sources/blocks/main_pt_notifications.php',
            'themes/default/templates/BLOCK_MAIN_MEMBER_BAR.tpl',
            'sources/cns_forumview.php',
            'sources/cns_forumview_pt.php',
            'sources/cns_topicview.php',
            'sources/hooks/modules/topicview/.htaccess',
            'sources_custom/hooks/modules/topicview/.htaccess',
            'sources/hooks/modules/topicview/index.html',
            'sources_custom/hooks/modules/topicview/index.html',
            'sources/hooks/systems/ajax_tree/choose_topic.php',
            'sources/hooks/systems/ajax_tree/choose_forum.php',
            'sources/hooks/systems/rss/cns_unread_topics.php',
            'sources/hooks/systems/rss/cns_private_topics.php',
            'themes/default/templates/CNS_PRIVATE_TOPIC_LINK.tpl',
            'themes/default/templates/CNS_PT_FILTERS.tpl',
            'themes/default/templates/CNS_MEMBER_PROFILE_POSTS.tpl',
            'sources/hooks/systems/cleanup/cns.php',
            'sources/hooks/systems/config/edit_time_limit.php',
            'sources/hooks/systems/config/delete_time_limit.php',
            'sources/hooks/systems/config/enable_add_topic_btn_in_topic.php',
            'sources/hooks/systems/config/enable_forum_dupe_buttons.php',
            'sources/hooks/systems/config/enable_mark_forum_read.php',
            'sources/hooks/systems/config/enable_mark_topic_unread.php',
            'sources/hooks/systems/config/enable_multi_quote.php',
            'sources/hooks/systems/config/enable_post_emphasis.php',
            'sources/hooks/systems/config/enable_pt_filtering.php',
            'sources/hooks/systems/config/enable_pt_restrict.php',
            'sources/hooks/systems/config/enable_sunk.php',
            'sources/hooks/systems/config/inline_pp_advertise.php',
            'sources/hooks/systems/config/intro_forum_id.php',
            'sources/hooks/systems/config/is_on_show_online.php',
            'sources/hooks/systems/config/max_forum_detail.php',
            'sources/hooks/systems/config/max_forum_inspect.php',
            'sources/hooks/systems/config/private_topics_per_page.php',
            'sources/hooks/systems/config/seq_post_ids.php',
            'sources/hooks/systems/config/threaded_buttons.php',
            'sources/hooks/systems/config/overt_whisper_suggestion.php',
            'sources/hooks/systems/config/post_read_history_days.php',
            'sources/hooks/systems/config/is_on_topic_descriptions.php',
            'sources/hooks/systems/config/is_on_topic_emoticons.php',
            'sources/hooks/systems/config/is_on_post_titles.php',
            'sources/hooks/systems/config/is_on_anonymous_posts.php',
            'sources/hooks/systems/config/force_guest_names.php',
            'sources/hooks/systems/config/forum_posts_per_page.php',
            'sources/hooks/systems/config/forum_topics_per_page.php',
            'sources/hooks/systems/config/delete_trashed_pts.php',
            'sources/hooks/systems/tasks/cns_recache.php',
            'sources/hooks/systems/tasks/cns_topics_recache.php',
            'sources/hooks/systems/tasks/notify_topics_moved.php',
        );
    }

    /**
     * Get mapping between template names and the method of this class that can render a preview of them
     *
     * @return array The mapping
     */
    public function tpl_previews()
    {
        return array(
            'templates/CNS_TOPIC_POST_AVATAR.tpl' => 'cns_topic_not_voted_checkboxes_wrap',
            'templates/CNS_FORUM_TOPIC_WRAPPER.tpl' => 'cns_forum',
            'templates/CNS_EDIT_FORUM_SCREEN_GROUPING.tpl' => 'administrative__cns_edit_forum_screen',
            'templates/CNS_USER_MEMBER.tpl' => 'cns_topic_not_voted_checkboxes_wrap',
            'templates/CNS_MEMBER_BOX.tpl' => 'cns_topic_not_voted_checkboxes_wrap',
            'templates/CNS_EDIT_FORUM_SCREEN_FORUM.tpl' => 'administrative__cns_edit_forum_screen',
            'templates/CNS_EDIT_FORUM_SCREEN.tpl' => 'administrative__cns_edit_forum_screen',
            'templates/CNS_RANK_IMAGE.tpl' => 'cns_rank_image',
            'templates/CNS_POST_BOX.tpl' => 'cns_isolated_post',
            'templates/BLOCK_MAIN_CNS_INVOLVED_TOPICS.tpl' => 'block_main_cns_involved_topics',
            'templates/BLOCK_SIDE_CNS_PRIVATE_TOPICS.tpl' => 'block_side_cns_private_topics',
            'templates/BLOCK_MAIN_PT_NOTIFICATIONS.tpl' => 'block_pt_notifications',
            'templates/CNS_NOTIFICATION.tpl' => 'block_pt_notifications',
            'templates/CNS_FORUM_TOPIC_ROW_LAST_POST.tpl' => 'cns_forum',
            'templates/CNS_PT_BETWEEN.tpl' => 'cns_forum',
            'templates/CNS_TOPIC_MARKER.tpl' => 'cns_forum',
            'templates/CNS_FORUM_TOPIC_ROW.tpl' => 'cns_forum',
            'templates/CNS_FORUM_TOPIC_LIST_LINE.tpl' => 'cns_forum_topic_list_line',
            'templates/CNS_FORUM_LIST_LINE.tpl' => 'cns_forum_list_line',
            'templates/CNS_FORUM_INTRO_QUESTION_POPUP.tpl' => 'cns_forum_intro_question_popup',
            'templates/CNS_MEMBER_BOX_CUSTOM_FIELD.tpl' => 'cns_topic_not_voted_checkboxes_wrap',
            'templates/CNS_POSTER_MEMBER.tpl' => 'cns_topic_not_voted_checkboxes_wrap',
            'templates/CNS_GUEST_DETAILS.tpl' => 'cns_topic_not_voted_checkboxes_wrap',
            'templates/CNS_POSTER_GUEST.tpl' => 'cns_isolated_post',
            'templates/CNS_TOPIC_POST_LAST_EDITED.tpl' => 'cns_topic_not_voted_checkboxes_wrap',
            'templates/CNS_TOPIC_POST.tpl' => 'cns_topic_not_voted_checkboxes_wrap',
            'templates/CNS_MEMBER_BAR.tpl' => 'block_main_member_bar_member',
            'templates/MEMBER_BAR_SEARCH.tpl' => 'block_main_member_bar_search',
            'templates/CNS_GUEST_BAR.tpl' => 'block_main_member_bar_guest',
            'templates/BLOCK_MAIN_MEMBER_BAR.tpl' => 'block_main_member_bar_member',
            'templates/BLOCK_MAIN_BOTTOM_BAR.tpl' => 'block_main_bottom_bar',
            'templates/CNS_FORUM_INTRO_QUESTION_SCREEN.tpl' => 'cns_forum_intro_question_screen',
            'templates/CNS_FORUM_LATEST.tpl' => 'cns_forum',
            'templates/CNS_FORUM_IN_GROUPING.tpl' => 'cns_forum',
            'templates/CNS_FORUM_GROUPING.tpl' => 'cns_forum',
            'templates/CNS_PINNED_DIVIDER.tpl' => 'cns_forum',
            'templates/CNS_FORUM.tpl' => 'cns_forum',
            'templates/CNS_FORUM_SCREEN.tpl' => 'cns_forum',
            'templates/CNS_VFORUM_SCREEN.tpl' => 'cns_vforum',
            'templates/CNS_WHISPER_CHOICE_SCREEN.tpl' => 'cns_whisper_choice_screen',
            'text/CNS_QUOTE_FCOMCODE.txt' => 'cns_quote_fcomcode',
            'templates/CNS_MEMBER_PT_RULES_SCREEN.tpl' => 'cns_member_pt_rules_screen',
            'templates/CNS_POSTING_SCREEN_POSTS.tpl' => 'cns_posting_screen_posts',
            'templates/CNS_TOPIC_FIRST_UNREAD.tpl' => 'cns_topic_not_voted_checkboxes_wrap',
            'templates/CNS_TOPIC_POLL_BUTTON.tpl' => 'cns_topic_not_voted_checkboxes_wrap',
            'templates/CNS_TOPIC_POLL_ANSWER_RESULTS.tpl' => 'cns_topic_voted_wrap',
            'templates/CNS_TOPIC_POLL_ANSWER.tpl' => 'cns_topic_not_voted_checkboxes_wrap',
            'templates/CNS_TOPIC_POLL_ANSWER_RADIO.tpl' => 'cns_topic_not_voted_radio_wrap',
            'templates/CNS_TOPIC_POLL.tpl' => 'cns_topic_not_voted_checkboxes_wrap',
            'templates/CNS_TOPIC_SCREEN.tpl' => 'cns_topic_not_voted_checkboxes_wrap',
            'templates/NOTIFICATION_BUTTONS.tpl' => 'cns_topic_not_voted_checkboxes_wrap',
            'templates/CNS_TOPIC_POLL_VIEW_RESULTS.tpl' => 'cns_topic_voted_wrap',
            'templates/CNS_PRIVATE_TOPIC_LINK.tpl' => 'cns_private_topic_link',
            'templates/CNS_PT_FILTERS.tpl' => 'cns_forum',
            'templates/CNS_MEMBER_PROFILE_POSTS.tpl' => 'cns_member_profile_posts',
            'templates/CNS_MEMBER_PROFILE_PTS.tpl' => 'cns_member_profile_pts',
            'templates/CNS_VFORUM_FILTERING.tpl' => 'cns_vforum_filtering',
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_vforum_filtering()
    {
        $filtering = do_lorem_template('CNS_VFORUM_FILTERING', array());

        $content = do_lorem_template('CNS_FORUM', array(
            'BREADCRUMBS' => placeholder_breadcrumbs(),
            'FILTERS' => '',
            'FILTERING' => $filtering,
            'FORUM_NAME' => lorem_word_html(),
            'STARTER_TITLE' => lorem_phrase(),
            'BUTTONS' => '',
            'TOPIC_WRAPPER' => '',
            'FORUM_GROUPINGS' => '',
            'ID' => placeholder_id(),
            'DESCRIPTION' => lorem_phrase(),
        ));

        $screen = do_lorem_template('CNS_FORUM_SCREEN', array(
            'TITLE' => lorem_title(),
            'CONTENT' => $content,
        ));

        return array(
            lorem_globalise($screen, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_private_topic_link()
    {
        require_css('cns');

        return array(
            lorem_globalise(do_lorem_template('CNS_PRIVATE_TOPIC_LINK', array(
                'TOPIC_URL' => placeholder_url(),
                'TITLE' => lorem_phrase(),
                'DATE' => placeholder_date(),
                'DATE_RAW' => placeholder_date_raw(),
                'LAST_POST_BY_POSTER_URL' => placeholder_url(),
                'LAST_POST_BY_USERNAME' => lorem_word(),
                'WITH_POSTER_URL' => placeholder_url(),
                'WITH_USERNAME' => lorem_word(),
                'WITH_POSTER_ID' => placeholder_id(),
                'BY_POSTER_URL' => placeholder_url(),
                'BY_USERNAME' => lorem_word(),
                'BY_POSTER_ID' => placeholder_id(),
                'TO_POSTER_URL' => placeholder_url(),
                'TO_USERNAME' => lorem_word(),
                'TO_POSTER_ID' => placeholder_id(),
                'POSTER_ID' => placeholder_id(),
                'NUM_POSTS' => placeholder_number(),
                'HAS_READ' => false,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__cns_edit_forum_screen()
    {
        require_css('cns');
        require_css('cns_editor');

        require_lang('cns');

        $orderings = '<option>1</option><option>2</option><option>3</option>';

        $orderings = '<label for="order_' . strval(1) . '">' . do_lang('SORT') . ' <select id="order_' . strval(1) . '" name="order_' . strval(1) . '">' . $orderings . '</select></label>';

        $forum_groupings = do_lorem_template('CNS_EDIT_FORUM_SCREEN_GROUPING', array(
            'ORDERINGS' => $orderings,
            'GROUPING' => lorem_word_2(),
            'SUBFORUMS' => lorem_phrase(),
        ));

        $root_forum = do_lorem_template('CNS_EDIT_FORUM_SCREEN_FORUM', array(
            'ID' => placeholder_id(),
            'ORDERINGS' => lorem_phrase(),
            'FORUM_GROUPINGS' => $forum_groupings,
            'CLASS' => lorem_phrase(),
            'FORUM' => lorem_phrase(),
            'VIEW_URL' => placeholder_url(),
            'EDIT_URL' => placeholder_url(),
        ));

        return array(
            lorem_globalise(do_lorem_template('CNS_EDIT_FORUM_SCREEN', array(
                'REORDER_URL' => placeholder_url(),
                'TITLE' => lorem_title(),
                'ROOT_FORUM' => $root_forum,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_rank_image()
    {
        require_css('cns');

        return array(
            lorem_globalise(do_lorem_template('CNS_RANK_IMAGE', array(
                'GROUP_NAME' => lorem_word(),
                'USERNAME' => lorem_word(),
                'IMG' => placeholder_img_code(''),
                'IS_LEADER' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_isolated_post()
    {
        require_css('cns');

        require_lang('cns');

        $first_unread = do_lorem_template('CNS_TOPIC_FIRST_UNREAD');

        $last_edited = do_lorem_template('CNS_TOPIC_POST_LAST_EDITED', array(
            'LAST_EDIT_DATE_RAW' => placeholder_date_raw(),
            'LAST_EDIT_DATE' => placeholder_date(),
            'LAST_EDIT_PROFILE_URL' => placeholder_url(),
            'LAST_EDIT_USERNAME' => lorem_word(),
        ));

        $custom_fields = do_lorem_template('CNS_MEMBER_BOX_CUSTOM_FIELD', array(
            'NAME' => lorem_phrase(),
            'VALUE' => placeholder_ip(),
        ));

        $poster_details = do_lorem_template('CNS_GUEST_DETAILS', array(
            'CUSTOM_FIELDS' => $custom_fields,
        ));

        $poster = do_lorem_template('CNS_POSTER_GUEST', array(
            'LOOKUP_IP_URL' => placeholder_url(),
            'POSTER_DETAILS' => $poster_details,
            'POSTER_USERNAME' => lorem_word(),
        ));

        $post_avatar = do_lorem_template('CNS_TOPIC_POST_AVATAR', array(
            'AVATAR' => placeholder_image_url(),
        ));

        $rank_images = do_lorem_template('CNS_RANK_IMAGE', array(
            'GROUP_NAME' => lorem_phrase(),
            'USERNAME' => lorem_word(),
            'IMG' => 'cns_rank_images/' . placeholder_img_code('cns_rank_images'),
            'IS_LEADER' => lorem_phrase(),
        ));

        $buttons = do_lorem_template('BUTTON_SCREEN_ITEM', array(
            'REL' => lorem_word(),
            'IMMEDIATE' => false,
            'IMG' => 'buttons__proceed',
            'URL' => placeholder_url(),
            'FULL_TITLE' => lorem_phrase(),
            'TITLE' => lorem_word(),
        ));

        $map = array(
            'ID' => placeholder_id(),
            'GIVE_CONTEXT' => false,
            'TOPIC_FIRST_POST_ID' => placeholder_id(),
            'TOPIC_FIRST_POSTER' => lorem_phrase(),
            'POST_ID' => placeholder_id(),
            'URL' => placeholder_url(),
            'CLASS' => lorem_phrase(),
            'EMPHASIS' => lorem_phrase(),
            'FIRST_UNREAD' => $first_unread,
            'POSTER_TITLE' => lorem_phrase(),
            'POST_TITLE' => lorem_phrase(),
            'POST_DATE_RAW' => placeholder_date_raw(),
            'POST_DATE' => placeholder_date(),
            'POST' => lorem_phrase(),
            'TOPIC_ID' => placeholder_id(),
            'LAST_EDITED_RAW' => lorem_phrase(),
            'LAST_EDITED' => $last_edited,
            'POSTER_ID' => placeholder_id(),
            'POSTER' => $poster,
            'POSTER_DETAILS' => $poster_details,
            'POST_AVATAR' => $post_avatar,
            'RANK_IMAGES' => $rank_images,
            'BUTTONS' => $buttons,
            'SIGNATURE' => lorem_phrase(),
            'UNVALIDATED' => lorem_phrase(),
            'DESCRIPTION' => lorem_phrase(),
        );
        $post = do_lorem_template('CNS_TOPIC_POST', $map);

        return array(
            lorem_globalise(do_lorem_template('CNS_POST_BOX', array(
                'GIVE_CONTEXT' => true,
                'ID' => placeholder_id(),
                'POST' => $post,
                'URL' => placeholder_url(),
                'BREADCRUMBS' => lorem_phrase(),
            ) + $map + array('ACTUAL_POST' => $post)), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_main_cns_involved_topics()
    {
        require_css('cns');

        require_lang('cns');

        return array(
            lorem_globalise(do_lorem_template('BLOCK_MAIN_CNS_INVOLVED_TOPICS', array(
                'TOPICS' => lorem_paragraph_html(),
                'BLOCK_PARAMS' => '',

                'START' => '0',
                'MAX' => '10',
                'START_PARAM' => 'x_start',
                'MAX_PARAM' => 'x_max',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_side_cns_private_topics()
    {
        require_css('cns');

        require_lang('cns');

        $out = new Tempcode();
        foreach (placeholder_array() as $k => $v) {
            $out->attach(do_lorem_template('CNS_PRIVATE_TOPIC_LINK', array(
                'TOPIC_URL' => placeholder_url(),
                'TITLE' => lorem_phrase(),
                'DATE' => placeholder_date(),
                'DATE_RAW' => placeholder_date_raw(),
                'LAST_POST_BY_POSTER_URL' => placeholder_url(),
                'LAST_POST_BY_USERNAME' => lorem_word(),
                'WITH_POSTER_URL' => placeholder_url(),
                'WITH_USERNAME' => lorem_word(),
                'WITH_POSTER_ID' => placeholder_id(),
                'BY_POSTER_URL' => placeholder_url(),
                'BY_USERNAME' => lorem_word(),
                'BY_POSTER_ID' => placeholder_id(),
                'TO_POSTER_URL' => placeholder_url(),
                'TO_USERNAME' => lorem_word(),
                'TO_POSTER_ID' => placeholder_id(),
                'POSTER_ID' => placeholder_id(),
                'NUM_POSTS' => placeholder_number(),
                'HAS_READ' => true,
            )));
        }

        return array(
            lorem_globalise(do_lorem_template('BLOCK_SIDE_CNS_PRIVATE_TOPICS', array(
                'SEND_URL' => placeholder_url(),
                'VIEW_URL' => placeholder_url(),
                'CONTENT' => $out,
                'FORUM_NAME' => lorem_word_html(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_forum_topic_list_line()
    {
        require_css('cns');

        return array(
            lorem_globalise(do_lorem_template('CNS_FORUM_TOPIC_LIST_LINE', array(
                'PRE' => lorem_phrase(),
                'TOPIC_TITLE' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_forum_list_line()
    {
        require_css('cns');

        return array(
            lorem_globalise(do_lorem_template('CNS_FORUM_LIST_LINE', array(
                'PRE' => lorem_phrase(),
                'NAME' => lorem_word(),
                'CAT_BIT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_forum_intro_question_popup()
    {
        require_css('cns');

        require_lang('cns');

        $content = do_lorem_template('CNS_FORUM_INTRO_QUESTION_POPUP', array(
            'QUESTION' => lorem_phrase(),
            'ANSWER' => lorem_phrase(),
        ));

        return array(
            lorem_globalise($content, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_main_member_bar_guest()
    {
        require_css('cns');

        require_lang('cns');

        $bar = do_lorem_template('CNS_GUEST_BAR', array(
            'LOGIN_URL' => placeholder_url(),
            'JOIN_URL' => placeholder_url(),
            'FULL_LOGIN_URL' => placeholder_url(),
            'INLINE_PERSONAL_POSTS_URL' => placeholder_url(),
            'NEW_POSTS_URL' => placeholder_url(),
            'UNANSWERED_TOPICS_URL' => placeholder_url(),
        ));

        $member_bar = do_lorem_template('BLOCK_MAIN_MEMBER_BAR', array('BAR' => $bar));

        return array(
            lorem_globalise($member_bar, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_main_member_bar_search()
    {
        require_css('cns');

        require_lang('cns');

        $bar = do_template('MEMBER_BAR_SEARCH', array());

        return array(
            lorem_globalise($bar, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_main_member_bar_member()
    {
        require_css('cns');

        require_lang('cns');

        $details = new Tempcode();
        $details->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LINE', array(
            'KEY' => lorem_word(),
            'VALUE' => placeholder_number(),
        )));

        $links = new Tempcode();
        $links->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LINK', array(
            'NAME' => lorem_word(),
            'URL' => placeholder_url(),
            'REL' => 'me',
        )));

        $bar = do_template('CNS_MEMBER_BAR', array(
            '_GUID' => 'd26f142a850c232ef14ec6de627cef4a',
            'AVATAR_URL' => placeholder_image_url(),
            'PROFILE_URL' => placeholder_url(),
            'USERNAME' => lorem_phrase(),
            'LOGOUT_URL' => placeholder_url(),
            'NUM_POINTS_ADVANCE' => placeholder_number(),
            'NUM_POINTS' => placeholder_number(),
            'NUM_POSTS' => placeholder_number(),
            'PRIMARY_GROUP' => lorem_phrase(),
            'LAST_VISIT_DATE_RAW' => placeholder_date_raw(),
            'LAST_VISIT_DATE' => placeholder_date(),
            'PRIVATE_TOPIC_URL' => placeholder_url(),
            'NEW_POSTS_URL' => placeholder_url(),
            'UNREAD_TOPICS_URL' => placeholder_url(),
            'RECENTLY_READ_URL' => placeholder_url(),
            'INLINE_PERSONAL_POSTS_URL' => placeholder_url(),
            'UNANSWERED_TOPICS_URL' => placeholder_url(),
            'INVOLVED_TOPICS_URL' => placeholder_url(),
            'PT_EXTRA' => '',
            'NUM_UNREAD_PTS' => placeholder_number(),
            'NEW_TOPICS' => placeholder_number(),
            'NEW_POSTS' => placeholder_number(),
            'MAX_AVATAR_HEIGHT' => placeholder_number(),
            'LINKS' => $links,
            'LINKS_ECOMMERCE' => $links,
            'DETAILS' => $details,
        ));

        $member_bar = do_lorem_template('BLOCK_MAIN_MEMBER_BAR', array('BAR' => $bar));

        return array(
            lorem_globalise($member_bar, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_pt_notifications()
    {
        require_css('cns');

        require_lang('cns');

        $notifications = do_lorem_template('CNS_NOTIFICATION', array(
            'ADDITIONAL_POSTS' => placeholder_number(),
            '_ADDITIONAL_POSTS' => lorem_phrase(),
            'ID' => placeholder_id(),
            'U_TITLE' => lorem_phrase(),
            'IGNORE_URL' => placeholder_url(),
            'IGNORE_URL_2' => placeholder_url(),
            'REPLY_URL' => placeholder_url(),
            'TOPIC_URL' => placeholder_url(),
            'POST' => lorem_phrase(),
            'DESCRIPTION' => lorem_paragraph_html(),
            'TIME' => placeholder_date(),
            'TIME_RAW' => placeholder_date_raw(),
            'BY' => lorem_phrase(),
            'PROFILE_URL' => placeholder_url(),
            'TYPE' => lorem_phrase(),
        ));

        $notifications_bar = do_lorem_template('BLOCK_MAIN_PT_NOTIFICATIONS', array('NOTIFICATIONS' => $notifications));

        return array(
            lorem_globalise($notifications_bar, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_main_bottom_bar()
    {
        require_css('cns');

        require_lang('cns');

        $birthdays = array();
        foreach (placeholder_array() as $k => $v) {
            $birthdays[] = array(
                'AGE' => placeholder_number(),
                'PROFILE_URL' => placeholder_url(),
                'USERNAME' => lorem_word(),
                'BIRTHDAY_URL' => placeholder_url(),
            );
        }

        $foot = do_lorem_template('BLOCK_MAIN_BOTTOM_BAR', array(
            'NEWEST_MEMBER_PROFILE_URL' => placeholder_url(),
            'NEWEST_MEMBER_USERNAME' => lorem_word(),
            'NUM_MEMBERS' => placeholder_number(),
            'NUM_TOPICS' => placeholder_number(),
            'NUM_POSTS' => placeholder_number(),
            'BIRTHDAYS' => $birthdays,
            'USERS_ONLINE' => lorem_phrase(),
            'USERS_ONLINE_URL' => placeholder_url(),
            'page' => lorem_phrase(),
            'GID' => placeholder_id(),
            'GCOLOUR' => lorem_word(),
            'GTITLE' => lorem_word(),
            'GROUPS' => placeholder_array(),
        ));

        return array(
            lorem_globalise($foot, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_forum_intro_question_screen()
    {
        require_css('cns');

        require_lang('cns');

        return array(
            lorem_globalise(do_lorem_template('CNS_FORUM_INTRO_QUESTION_SCREEN', array(
                'ANSWER' => lorem_phrase(),
                'TITLE' => lorem_title(),
                'URL' => placeholder_url(),
                'QUESTION' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_forum()
    {
        require_css('cns');

        require_lang('cns');

        //buttons
        $buttons = new Tempcode();
        foreach (placeholder_array() as $k => $v) {
            $buttons->attach(do_lorem_template('BUTTON_SCREEN', array(
                'REL' => lorem_word(),
                'URL' => placeholder_url(),
                'IMG' => 'buttons__proceed',
                'TITLE' => lorem_word(),
                'IMMEDIATE' => false,
            )));
        }

        //topics
        $topics = new Tempcode();
        foreach (placeholder_array() as $k => $v) {
            $marker = do_lorem_template('CNS_TOPIC_MARKER', array(
                'ID' => placeholder_id() . strval($k),
            ));

            $topic_row_links = array();
            $topic_row_links[] = array(
                'URL' => placeholder_url(),
                'IMG' => placeholder_img_code('icons/14x14/cns_topic_modifiers'),
                'ALT' => lorem_phrase(),
            );

            $topic_row_modifiers = array();
            $topic_row_modifiers[] = array(
                'IMG' => placeholder_img_code('icons/14x14/cns_topic_modifiers'),
                'ALT' => lorem_phrase(),
            );

            $b = do_lorem_template('CNS_USER_MEMBER', array(
                'FIRST' => true,
                'COLOUR' => lorem_word(),
                'PROFILE_URL' => placeholder_url(),
                'USERNAME' => lorem_word(),
                'MEMBER_ID' => placeholder_id(),
                'AT' => lorem_phrase(),
            ));

            $poster = do_lorem_template('CNS_PT_BETWEEN', array(
                'A' => lorem_phrase(),
                'B' => $b,
            ));

            $last_post = do_lorem_template('CNS_FORUM_TOPIC_ROW_LAST_POST', array(
                'ID' => placeholder_id(),
                'DATE_RAW' => placeholder_date_raw(),
                'DATE' => placeholder_date(),
                'POSTER' => lorem_phrase(),
                'LAST_URL' => placeholder_url(),
            ));

            $topics->attach(do_lorem_template('CNS_FORUM_TOPIC_ROW', array(
                'BREADCRUMBS' => placeholder_breadcrumbs(),
                'RAW_TIME' => placeholder_date_raw(),
                'UNREAD' => lorem_phrase(),
                'ID' => placeholder_random_id(),
                'FORUM_ID' => placeholder_id(),
                'HOVER' => lorem_phrase(),
                'PAGES' => lorem_phrase(),
                'MARKER' => $marker,
                'TOPIC_ROW_LINKS' => $topic_row_links,
                'TOPIC_ROW_MODIFIERS' => $topic_row_modifiers,
                '_TOPIC_ROW_MODIFIERS' => array(),
                'POST' => lorem_phrase(),
                'EMOTICON' => 'cns_emoticons/constipated',
                'DESCRIPTION' => lorem_paragraph(),
                'URL' => placeholder_url(),
                'TITLE' => lorem_phrase(),
                'POSTER' => $poster,
                '_POSTER' => placeholder_id(),
                'NUM_POSTS' => placeholder_number(),
                'NUM_VIEWS' => placeholder_number(),
                'LAST_POST' => $last_post,
            )));
        }

        //forum groupings
        $forum_groupings = new Tempcode();
        foreach (placeholder_array(1) as $k => $v) {
            $forums = new Tempcode();
            foreach (placeholder_array() as $_k => $_v) {
                $poster = do_lorem_template('CNS_USER_MEMBER', array(
                    'FIRST' => true,
                    'USERNAME' => lorem_word(),
                    'MEMBER_ID' => placeholder_id(),
                    'PROFILE_URL' => placeholder_url(),
                    'AT' => lorem_phrase(),
                ));

                $latest = do_lorem_template('CNS_FORUM_LATEST', array(
                    'DATE' => placeholder_date(),
                    'DATE_RAW' => placeholder_date_raw(),
                    'TOPIC_URL' => placeholder_url(),
                    'TOPIC_TITLE' => lorem_phrase(),
                    'POSTER' => $poster,
                    'MEMBER_ID' => placeholder_id(),
                    'ID' => placeholder_id(),
                ));

                $forums->attach(do_lorem_template('CNS_FORUM_IN_GROUPING', array(
                    'ID' => placeholder_random_id(),
                    'NEW_POST_OR_NOT' => placeholder_img_code('cns_general'),
                    'LANG_NEW_POST_OR_NOT' => lorem_word(),
                    'FORUM_NAME' => lorem_phrase(),
                    'FORUM_URL' => placeholder_url(),
                    'DESCRIPTION' => lorem_phrase(),
                    'NUM_POSTS' => placeholder_number(),
                    'NUM_TOPICS' => placeholder_number(),
                    'LATEST' => $latest,
                    'SUBFORUMS' => lorem_phrase(),
                    'EDIT_URL' => placeholder_url(),
                    'FORUM_RULES_URL' => placeholder_url(),
                    'INTRO_QUESTION_URL' => placeholder_url(),
                )));
                if ($_k == 1) {
                    $forums->attach(do_lorem_template('CNS_PINNED_DIVIDER', array()));
                }
            }

            $forum_groupings->attach(do_lorem_template('CNS_FORUM_GROUPING', array(
                'GROUPING_ID' => placeholder_random_id(),
                'EXPAND_TYPE' => 'expand',
                'DISPLAY' => 'block',
                'GROUPING_TITLE' => lorem_phrase(),
                'GROUPING_DESCRIPTION' => lorem_phrase(),
                'FORUMS' => $forums,
            )));
        }

        $filters = do_lorem_template('CNS_PT_FILTERS', array(
            'FILTERS' => array(),
            'RESET_URL' => placeholder_url(),
        ));

        $pagination = placeholder_pagination();
        $topic_wrapper = do_lorem_template('CNS_FORUM_TOPIC_WRAPPER', array(
            'TYPE' => 'browse',
            'MAX' => lorem_phrase(),
            'ORDER' => lorem_phrase(),
            'MAY_CHANGE_MAX' => lorem_phrase(),
            'TREE' => lorem_phrase(),
            'BUTTONS' => $buttons,
            'STARTER_TITLE' => lorem_phrase(),
            'PAGINATION' => $pagination,
            'MODERATOR_ACTIONS' => placeholder_options(),
            'ACTION_URL' => placeholder_url(),
            'TOPICS' => $topics,
            'FORUM_NAME' => lorem_word(),
        ));
        $content = do_lorem_template('CNS_FORUM', array(
            'BREADCRUMBS' => placeholder_breadcrumbs(),
            'FILTERS' => $filters,
            'FORUM_NAME' => lorem_word_html(),
            'STARTER_TITLE' => lorem_phrase(),
            'BUTTONS' => $buttons,
            'TOPIC_WRAPPER' => $topic_wrapper,
            'FORUM_GROUPINGS' => $forum_groupings,
            'ID' => placeholder_id(),
            'DESCRIPTION' => lorem_phrase(),
        ));

        $members_viewing = new Tempcode();
        foreach (placeholder_array() as $_k => $_v) {
            $members_viewing->attach(do_lorem_template('CNS_USER_MEMBER', array(
                'FIRST' => true,
                'PROFILE_URL' => placeholder_url(),
                'USERNAME' => lorem_word(),
                'MEMBER_ID' => placeholder_id(),
                'AT' => lorem_phrase(),
                'COLOUR' => lorem_word(),
            )));
        }

        $screen = do_lorem_template('CNS_FORUM_SCREEN', array(
            'TITLE' => lorem_title(),
            'CONTENT' => $content,
            'NUM_GUESTS' => placeholder_number(),
            'NUM_MEMBERS' => placeholder_number(),
            'MEMBERS_VIEWING' => $members_viewing,
        ));

        return array(
            lorem_globalise($screen, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_vforum()
    {
        require_css('cns');

        require_lang('cns');

        $content = do_lorem_template('CNS_VFORUM_SCREEN', array(
            'TITLE' => lorem_title(),
            'CONTENT' => lorem_phrase(),
        ));

        return array(
            lorem_globalise($content, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_whisper_choice_screen()
    {
        require_css('cns');

        require_lang('cns');

        return array(
            lorem_globalise(do_lorem_template('CNS_WHISPER_CHOICE_SCREEN', array(
                'URL' => placeholder_url(),
                'TITLE' => lorem_title(),
                'USERNAME' => lorem_word(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_quote_fcomcode()
    {
        require_css('cns');

        return array(
            lorem_globalise(do_lorem_template('CNS_QUOTE_FCOMCODE', array(
                'ID' => placeholder_id(),
                'TITLE' => lorem_phrase(),
                'POST' => lorem_phrase(),
                'BY' => lorem_phrase(),
                'BY_ID' => placeholder_id(),
            ), null, false, null, '.txt', 'text'), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_member_pt_rules_screen()
    {
        require_css('cns');

        require_lang('cns');

        return array(
            lorem_globalise(do_lorem_template('CNS_MEMBER_PT_RULES_SCREEN', array(
                'TITLE' => lorem_title(),
                'USERNAME' => lorem_word(),
                'MEMBER_ID' => placeholder_id(),
                'URL' => placeholder_url(),
                'RULES' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_posting_screen_posts()
    {
        require_css('cns');

        require_lang('cns');

        $posts = new Tempcode();
        foreach (placeholder_array() as $k => $v) {
            $posts->attach(lorem_paragraph_html());
        }

        return array(
            lorem_globalise(do_lorem_template('CNS_POSTING_SCREEN_POSTS', array(
                'POSTS' => $posts,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_member_profile_posts()
    {
        require_css('cns');

        $topics = new Tempcode();
        if (addon_installed('cns_forum')) {
            foreach (placeholder_array() as $k => $v) {
                $marker = do_lorem_template('CNS_TOPIC_MARKER', array(
                    'ID' => placeholder_id() . strval($k),
                ));

                $topic_row_links = array();
                $topic_row_links[] = array(
                    'URL' => placeholder_url(),
                    'IMG' => placeholder_img_code('icons/14x14/cns_topic_modifiers'),
                    'ALT' => lorem_phrase(),
                );

                $topic_row_modifiers = array();
                $topic_row_modifiers[] = array(
                    'IMG' => placeholder_img_code('icons/14x14/cns_topic_modifiers'),
                    'ALT' => lorem_phrase(),
                );

                $b = do_lorem_template('CNS_USER_MEMBER', array(
                    'FIRST' => true,
                    'COLOUR' => lorem_word(),
                    'PROFILE_URL' => placeholder_url(),
                    'USERNAME' => lorem_word(),
                    'MEMBER_ID' => placeholder_id(),
                    'AT' => lorem_phrase(),
                ));

                $poster = do_lorem_template('CNS_PT_BETWEEN', array(
                    'A' => lorem_phrase(),
                    'B' => $b,
                ));

                $last_post = do_lorem_template('CNS_FORUM_TOPIC_ROW_LAST_POST', array(
                    'ID' => placeholder_id(),
                    'DATE_RAW' => placeholder_date_raw(),
                    'DATE' => placeholder_date(),
                    'POSTER' => lorem_phrase(),
                    'LAST_URL' => placeholder_url(),
                ));

                $topics->attach(do_lorem_template('CNS_FORUM_TOPIC_ROW', array(
                    'BREADCRUMBS' => placeholder_breadcrumbs(),
                    'RAW_TIME' => placeholder_date_raw(),
                    'UNREAD' => lorem_phrase(),
                    'ID' => placeholder_id(),
                    'FORUM_ID' => placeholder_id(),
                    'HOVER' => lorem_phrase(),
                    'PAGES' => lorem_phrase(),
                    'MARKER' => $marker,
                    'TOPIC_ROW_LINKS' => $topic_row_links,
                    'TOPIC_ROW_MODIFIERS' => $topic_row_modifiers,
                    'POST' => lorem_phrase(),
                    'EMOTICON' => 'cns_emoticons/depressed',
                    'DESCRIPTION' => lorem_paragraph(),
                    'URL' => placeholder_url(),
                    'TITLE' => lorem_phrase(),
                    'POSTER' => $poster,
                    '_POSTER' => placeholder_id(),
                    'NUM_POSTS' => placeholder_number(),
                    'NUM_VIEWS' => placeholder_number(),
                    'LAST_POST' => $last_post,
                )));
            }
        }

        $pagination = placeholder_pagination();

        $buttons = lorem_phrase();

        $topic_wrapper = do_lorem_template('CNS_FORUM_TOPIC_WRAPPER', array(
            'TYPE' => '',
            'MAX' => lorem_phrase(),
            'ORDER' => lorem_phrase(),
            'MAY_CHANGE_MAX' => lorem_phrase(),
            'TREE' => lorem_phrase(),
            'BUTTONS' => $buttons,
            'STARTER_TITLE' => lorem_phrase(),
            'PAGINATION' => $pagination,
            'MODERATOR_ACTIONS' => placeholder_options(),
            'ACTION_URL' => placeholder_url(),
            'TOPICS' => $topics,
            'FORUM_NAME' => lorem_word(),
        ));

        $tab_content = do_lorem_template('CNS_MEMBER_PROFILE_POSTS', array(
            'MEMBER_ID' => placeholder_id(),
            'TOPICS' => $topic_wrapper,
        ));
        return array(
            lorem_globalise($tab_content, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_member_profile_pts()
    {
        require_css('cns');

        $tab_content = do_template('CNS_MEMBER_PROFILE_PTS', array('_GUID' => '1bcb43f6ded79efdc08cde4ee80be15d', 'CONTENT' => lorem_paragraph_html()));

        return array(
            lorem_globalise($tab_content, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_topic_not_voted_checkboxes_wrap()
    {
        return $this->_tpl_preview__cns_topic_screen(false, true);
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_topic_not_voted_radio_wrap()
    {
        return $this->_tpl_preview__cns_topic_screen(false, false);
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_topic_voted_wrap()
    {
        return $this->_tpl_preview__cns_topic_screen(true, false);
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @param  boolean $voted Whether to show for a has-voted-poll or not.
     * @param  boolean $checkboxes Whether to show checkboxes (as oppose to radio buttons). Irrelevant if !$voted.
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function _tpl_preview__cns_topic_screen($voted, $checkboxes)
    {
        require_css('cns');

        require_lang('cns');
        require_lang('polls');

        require_javascript('editing');

        $warning_details = do_lorem_template('WARNING_BOX', array(
            'WARNING' => lorem_phrase(),
        ));

        foreach (placeholder_array() as $k => $v) {
            $members_viewing = new Tempcode();
            foreach (placeholder_array() as $_k => $_v) {
                $members_viewing->attach(do_lorem_template('CNS_USER_MEMBER', array(
                    'FIRST' => $members_viewing->is_empty(),
                    'PROFILE_URL' => placeholder_url(),
                    'USERNAME' => lorem_word(),
                    'MEMBER_ID' => placeholder_id(),
                    'AT' => lorem_phrase(),
                    'COLOUR' => lorem_word(),
                )));
            }

            $pagination = placeholder_pagination();

            $quick_reply = do_lorem_template('COMMENTS_POSTING_FORM', array(
                'JOIN_BITS' => lorem_phrase_html(),
                'FIRST_POST' => lorem_paragraph_html(),
                'USE_CAPTCHA' => false,
                'GET_EMAIL' => false,
                'EMAIL_OPTIONAL' => true,
                'GET_TITLE' => false,
                'POST_WARNING' => '',
                'COMMENT_TEXT' => '',
                'EM' => placeholder_emoticon_chooser(),
                'EXPAND_TYPE' => 'expand',
                'DISPLAY' => 'block',
                'MORE_URL' => placeholder_url(),
                'FIRST_POST_URL' => placeholder_url(),
                'COMMENT_URL' => placeholder_url(),
                'TITLE' => lorem_word(),
                'MAKE_POST' => true,
                'CREATE_TICKET_MAKE_POST' => true,
                'NAME' => 'field',
            ));

            $poll = new Tempcode();
            $num_choices = do_lorem_template('PARAGRAPH', array(
                'TEXT' => lorem_phrase(),
                'CLASS' => lorem_word(),
            ));
            $private = $num_choices;

            if (!$voted) {
                $answers = new Tempcode();
                foreach (placeholder_array() as $_k => $_v) {
                    $answers->attach(do_lorem_template($checkboxes ? 'CNS_TOPIC_POLL_ANSWER' : 'CNS_TOPIC_POLL_ANSWER_RADIO', array(
                        'REAL_BUTTON' => '',
                        'ID' => placeholder_random_id(),
                        'ANSWER' => lorem_phrase(),
                        'I' => strval($_k),
                    )));
                }

                $button = do_lorem_template('CNS_TOPIC_POLL_BUTTON', array(
                    'RESULTS_URL' => placeholder_url(),
                ));

                $poll->attach(do_lorem_template('CNS_TOPIC_POLL', array(
                    'ID' => placeholder_random_id(),
                    'NUM_CHOICES' => $num_choices,
                    'PRIVATE' => $private,
                    'QUESTION' => lorem_phrase(),
                    'ANSWERS' => $answers,
                    'REAL_BUTTON' => '',
                    'BUTTON' => $button,
                    'VOTE_URL' => placeholder_url(),
                    'MINIMUM_SELECTIONS' => placeholder_number(),
                    'MAXIMUM_SELECTIONS' => placeholder_number(),
                )));
            } else {
                $answers = new Tempcode();
                $answers->attach(do_lorem_template('CNS_TOPIC_POLL_ANSWER_RESULTS', array(
                    'ID' => placeholder_random_id(),
                    'NUM_VOTES' => '10',
                    'TOTAL_VOTES' => '45',
                    'WIDTH' => '30',
                    'ANSWER' => lorem_phrase(),
                    'I' => '0',
                )));
                $answers->attach(do_lorem_template('CNS_TOPIC_POLL_ANSWER_RESULTS', array(
                    'ID' => placeholder_random_id(),
                    'NUM_VOTES' => '15',
                    'TOTAL_VOTES' => '45',
                    'WIDTH' => '45',
                    'ANSWER' => lorem_phrase(),
                    'I' => '1',
                )));
                $answers->attach(do_lorem_template('CNS_TOPIC_POLL_ANSWER_RESULTS', array(
                    'ID' => placeholder_random_id(),
                    'NUM_VOTES' => '20',
                    'TOTAL_VOTES' => '45',
                    'WIDTH' => '60',
                    'ANSWER' => lorem_phrase(),
                    'I' => '2',
                )));

                $button = new Tempcode();

                $poll->attach(do_lorem_template('CNS_TOPIC_POLL_VIEW_RESULTS', array(
                    'ID' => placeholder_random_id(),
                    'NUM_CHOICES' => $num_choices,
                    'PRIVATE' => $private,
                    'QUESTION' => lorem_phrase(),
                    'ANSWERS' => $answers,
                    'REAL_BUTTON' => '',
                    'BUTTON' => $button,
                    'VOTE_URL' => placeholder_url(),
                    'MINIMUM_SELECTIONS' => placeholder_number(),
                    'MAXIMUM_SELECTIONS' => placeholder_number(),
                )));
            }

            // Buttons
            $buttons = new Tempcode();
            foreach (placeholder_array(1) as $_k => $_v) {
                $buttons->attach(do_lorem_template('BUTTON_SCREEN', array(
                    'REL' => lorem_word(),
                    'IMMEDIATE' => null,
                    'URL' => placeholder_url(),
                    'IMG' => 'buttons__proceed',
                    'TITLE' => lorem_word(),
                )));
            }

            // Posts...

            $posts = new Tempcode();

            $first_unread = do_lorem_template('CNS_TOPIC_FIRST_UNREAD');

            $last_edited = do_lorem_template('CNS_TOPIC_POST_LAST_EDITED', array(
                'LAST_EDIT_DATE_RAW' => placeholder_date_raw(),
                'LAST_EDIT_DATE' => placeholder_date(),
                'LAST_EDIT_PROFILE_URL' => placeholder_url(),
                'LAST_EDIT_USERNAME' => lorem_word(),
            ));

            $custom_fields = do_lorem_template('CNS_MEMBER_BOX_CUSTOM_FIELD', array(
                'NAME' => lorem_phrase(),
                'VALUE' => placeholder_ip(),
            ));
            $poster_details = do_lorem_template('CNS_GUEST_DETAILS', array(
                'CUSTOM_FIELDS' => $custom_fields,
            ));

            $poster_details_mem = do_lorem_template('CNS_MEMBER_BOX', array(
                'AVATAR_URL' => placeholder_image_url(),
                'ONLINE' => false,
                'POSTS' => placeholder_number(),
                'POINTS' => placeholder_number(),
                'JOIN_DATE_RAW' => placeholder_date_raw(),
                'MEMBER_ID' => placeholder_id(),
                'JOIN_DATE' => placeholder_date(),
                'PRIMARY_GROUP_NAME' => lorem_phrase(),
                'CUSTOM_FIELDS' => lorem_phrase(),
                'CUSTOM_FIELDS_FULL' => lorem_phrase(),
                'GIVE_CONTEXT' => false,
            ));

            $poster = do_lorem_template('CNS_POSTER_MEMBER', array(
                'ID' => placeholder_random_id(),
                'POSTER_DETAILS' => $poster_details_mem,
                'PROFILE_URL' => placeholder_url(),
                'POSTER_USERNAME' => lorem_word(),
                'OTHER_USERGROUPS' => array(
                    lorem_word_html()
                ),
                'POSTER' => placeholder_number(),
                'HIGHLIGHT_NAME' => lorem_word_html(),
                'ONLINE' => false,
            ));

            $post_avatar = do_lorem_template('CNS_TOPIC_POST_AVATAR', array(
                'AVATAR' => placeholder_image_url(),
            ));

            $rank_images = do_lorem_template('CNS_RANK_IMAGE', array(
                'GROUP_NAME' => lorem_phrase(),
                'USERNAME' => lorem_word(),
                'IMG' => 'cns_rank_images/' . placeholder_img_code('cns_rank_images'),
                'IS_LEADER' => lorem_phrase(),
            ));

            // Buttons
            $buttons = new Tempcode();
            foreach (placeholder_array(1) as $_k => $_v) {
                $buttons->attach(do_lorem_template('BUTTON_SCREEN_ITEM', array(
                    'REL' => lorem_word(),
                    'IMMEDIATE' => '',
                    'URL' => placeholder_url(),
                    'IMG' => 'buttons__proceed',
                    'FULL_TITLE' => lorem_phrase(),
                    'TITLE' => lorem_word(),
                )));
            }

            $posts->attach(do_lorem_template('CNS_TOPIC_POST', array(
                'ID' => placeholder_random_id(),
                'GIVE_CONTEXT' => false,
                'TOPIC_FIRST_POST_ID' => placeholder_random_id(),
                'TOPIC_FIRST_POSTER' => lorem_phrase(),
                'POST_ID' => placeholder_random_id(),
                'URL' => placeholder_url(),
                'CLASS' => lorem_phrase(),
                'EMPHASIS' => lorem_phrase(),
                'FIRST_UNREAD' => $first_unread,
                'POSTER_TITLE' => lorem_word(),
                'POST_TITLE' => lorem_word(),
                'POST_DATE_RAW' => placeholder_date_raw(),
                'POST_DATE' => placeholder_date(),
                'POST' => lorem_phrase(),
                'TOPIC_ID' => placeholder_id(),
                'LAST_EDITED_RAW' => lorem_phrase(),
                'LAST_EDITED' => $last_edited,
                'POSTER_ID' => placeholder_id(),
                'POSTER' => $poster,
                'POSTER_DETAILS' => $poster_details,
                'POST_AVATAR' => $post_avatar,
                'RANK_IMAGES' => $rank_images,
                'BUTTONS' => $buttons,
                'SIGNATURE' => lorem_phrase(),
                'UNVALIDATED' => lorem_phrase(),
                'DESCRIPTION' => lorem_phrase(),
            )));
        }

        // Buttons
        $buttons = new Tempcode();
        foreach (placeholder_array(1) as $k => $v) {
            $buttons->attach(do_lorem_template('BUTTON_SCREEN', array(
                'REL' => lorem_word(),
                'IMMEDIATE' => '',
                'URL' => placeholder_url(),
                'IMG' => 'buttons__proceed',
                'TITLE' => lorem_word(),
            )));
        }

        $topic_tpl = do_lorem_template('CNS_TOPIC_SCREEN', array(
            'TITLE' => lorem_title(),
            'THREADED' => false,
            'ID' => placeholder_id(),
            '_TITLE' => lorem_phrase(),
            'WARNING_DETAILS' => $warning_details,
            'MAX' => lorem_phrase(),
            'ACTION_URL' => placeholder_url(),
            'NUM_GUESTS' => placeholder_number(),
            'NUM_MEMBERS' => placeholder_number(),
            'MEMBERS_VIEWING' => $members_viewing,
            'PAGINATION' => $pagination,
            'MODERATOR_ACTIONS' => placeholder_options(),
            'MARKED_POST_ACTIONS' => placeholder_options(),
            'QUICK_REPLY' => $quick_reply,
            'BREADCRUMBS' => placeholder_breadcrumbs(),
            'POLL' => $poll,
            'BUTTON_SCREENS' => $buttons,
            'POSTS' => $posts,
            'MAY_CHANGE_MAX' => lorem_word(),
            'LAST_POSTER' => placeholder_random_id(),
            'FORUM_ID' => placeholder_id(),
            'TICKET_FORUM' => false,
        ));

        return array(
            lorem_globalise($topic_tpl, null, '', true)
        );
    }
}
