<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    cns_reported_posts
 */

/**
 * Hook class.
 */
class Hook_checklist_reported_posts
{
    /**
     * Find items to include on the staff checklist.
     *
     * @return array An array of tuples: The task row to show, the number of seconds until it is due (or null if not on a timer), the number of things to sort out (or null if not on a queue), The name of the config option that controls the schedule (or null if no option).
     */
    public function run()
    {
        if (!addon_installed('cns_forum')) {
            return array();
        }
        if (get_forum_type() != 'cns') {
            return array();
        }

        require_lang('cns_config');

        $forum_id = $GLOBALS['FORUM_DRIVER']->forum_id_from_name(get_option('reported_posts_forum'));
        if (is_null($forum_id)) {
            return array();
        }
        $where = 't_forum_id=' . strval($forum_id) . ' AND t_is_open=1';
        $query = 'SELECT COUNT(*) FROM ' . $GLOBALS['FORUM_DB']->get_table_prefix() . 'f_topics WHERE ' . $where;
        $outstanding = $GLOBALS['FORUM_DB']->query_value_if_there($query);

        if ($outstanding > 0) {
            $status = do_template('BLOCK_MAIN_STAFF_CHECKLIST_ITEM_STATUS_0', array('_GUID' => 'e578142633c6f3d37776e82a869deb91'));
        } else {
            $status = do_template('BLOCK_MAIN_STAFF_CHECKLIST_ITEM_STATUS_1', array('_GUID' => 'f578142633c6f3d37776e82a869deb91'));
        }

        $url = $GLOBALS['FORUM_DRIVER']->forum_url($forum_id, true);

        $tpl = do_template('BLOCK_MAIN_STAFF_CHECKLIST_ITEM', array('_GUID' => '9ee69e250c997730a3670ed77d681e5f', 'URL' => $url, 'STATUS' => $status, 'TASK' => do_lang_tempcode('REPORTED_POSTS_FORUM'), 'INFO' => do_lang_tempcode('NUM_QUEUE', escape_html(integer_format($outstanding)))));
        return array(array($tpl, null, $outstanding, null));
    }
}
