<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_cns
 */

/* This file is designed to be overwritten by addons that implement external user sync schemes. */

/**
 * Get special type of a member.
 *
 * @param  MEMBER $member_id The ID of the member
 * @return ID_TEXT Special type
 */
function get_member_special_type($member_id)
{
    $special_type = $GLOBALS['FORUM_DRIVER']->get_member_row_field($member_id, 'm_password_compat_scheme');
    if ($special_type != '') {
        return $special_type;
    }
    if (cns_is_ldap_member($member_id)) {
        $special_type = 'ldap';
    } elseif (cns_is_httpauth_member($member_id)) {
        $special_type = 'httpauth';
    }
    return $special_type;
}

/**
 * Find is a field is editable.
 * Called for fields that have a fair chance of being set to auto-sync, and hence be locked to local edits.
 *
 * @param  ID_TEXT $field_name Field name
 * @param  ID_TEXT $special_type The special type of the user (built-in types are: <blank>, ldap, httpauth, <name of import source>)
 * @return boolean Whether the field is editable
 */
function cns_field_editable($field_name, $special_type)
{
    switch ($field_name) {
        case 'username':
            switch ($special_type) {
                case 'ldap':
                    return false;
            }
            break;

        case 'password':
            switch ($special_type) {
                case 'ldap':
                case 'httpauth':
                    return false;
            }
            break;

        case 'primary_group':
            switch ($special_type) {
                case 'ldap':
                    return false;
            }
            break;

        case 'secondary_groups':
            if (!has_actual_page_access(get_member(), 'groups', get_module_zone('groups'))) {
                return false;
            }

            switch ($special_type) {
                case 'ldap':
                    return false;
            }
            break;
    }

    return true;
}
