<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_adminzone_dashboard
 */

/**
 * Block class.
 */
class Block_main_staff_tips
{
    /**
     * Find details of the block.
     *
     * @return ?array Map of block info (null: block is disabled).
     */
    public function info()
    {
        $info = array();
        $info['author'] = 'Chris Graham';
        $info['organisation'] = 'ocProducts';
        $info['hacked_by'] = null;
        $info['hack_version'] = null;
        $info['version'] = 2;
        $info['locked'] = false;
        $info['parameters'] = array();
        return $info;
    }

    /**
     * Uninstall the block.
     */
    public function uninstall()
    {
        $GLOBALS['SITE_DB']->drop_table_if_exists('staff_tips_dismissed');
    }

    /**
     * Install the block.
     *
     * @param  ?integer $upgrade_from What version we're upgrading from (null: new install)
     * @param  ?integer $upgrade_from_hack What hack version we're upgrading from (null: new-install/not-upgrading-from-a-hacked-version)
     */
    public function install($upgrade_from = null, $upgrade_from_hack = null)
    {
        $GLOBALS['SITE_DB']->create_table('staff_tips_dismissed', array(
            't_member' => '*MEMBER',
            't_tip' => '*ID_TEXT'
        ));
    }

    /**
     * Execute the block.
     *
     * @param  array $map A map of parameters.
     * @return Tempcode The result of execution.
     */
    public function run($map)
    {
        require_css('adminzone_dashboard');
        require_lang('tips');

        // Anything to dismiss?
        $dismiss = get_param_string('staff_tips_dismiss', '');
        if ($dismiss != '') {
            $GLOBALS['SITE_DB']->query_delete('staff_tips_dismissed', array('t_tip' => $dismiss, 't_member' => get_member()), '', 1);
            $GLOBALS['SITE_DB']->query_insert('staff_tips_dismissed', array('t_tip' => $dismiss, 't_member' => get_member()));
        }

        // What tips have been permanently dismissed by the current member?
        $read = collapse_1d_complexity('t_tip', $GLOBALS['SITE_DB']->query_select('staff_tips_dismissed', array('t_tip'), array('t_member' => get_member())));

        $esc_free_support = escape_html(get_brand_page_url(array('page' => 'contact', 'type' => 'free'), ''));
        $esc_brand_name = escape_html(brand_name());
        $remaining_tip_params = array(
            escape_html(get_brand_page_url(array('page' => 'professional_support'), ''/*is site, except runs with single public zone*/)),
            escape_html(get_brand_page_url(array('page' => ''), 'forum')),
            escape_html(get_tutorial_url('tutorials')),
            escape_html(get_tutorial_url(null)),
            escape_html(get_tutorial_url('tut_do')),
        );

        // Load up tips by searching for the correctly named language files; also choose level
        require_lang('tips');
        $tips = array();
        $level = 0;
        $letters = array('a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z');
        for ($i = 0; $i < 5; $i++) {
            $tips[$i] = array();
            foreach ($letters as $j) {
                $tip_id = strval($i) . $j;
                if (!in_array($tip_id, $read)) {
                    $lang2 = do_lang('TIP_' . $tip_id, null, null, null, null, false);
                    if (!is_null($lang2)) {
                        $lang = do_lang_tempcode('TIP_' . $tip_id, $esc_free_support, $esc_brand_name, $remaining_tip_params);
                        $tips[$i][$tip_id] = $lang;
                    }
                }
            }
            if (count($tips[$level]) == 0) {
                $level = $i + 1;
            }
        }

        // Choose a tip from the level we're on
        if (!array_key_exists($level, $tips)) {
            $tip = do_lang_tempcode('ALL_TIPS_READ', $esc_free_support, $esc_brand_name, $remaining_tip_params);
            $level = 5;
            $tip_code = '';
            $count = 0;
        } else {
            $tip_pool = array_values($tips[$level]);
            $count = count($tip_pool);
            $choose_id = mt_rand(0, $count - 1);
            $tip = $tip_pool[$choose_id];
            $tip_keys = array_keys($tips[$level]);
            $tip_code = $tip_keys[$choose_id];
        }

        return do_template('BLOCK_MAIN_STAFF_TIPS', array(
            '_GUID' => 'c2cffc480b7bd9beef7f78a8ee7b7359',
            'BLOCK_PARAMS' => block_params_arr_to_str($map),
            'TIP' => $tip,
            'TIP_CODE' => $tip_code,
            'LEVEL' => integer_format($level),
            'COUNT' => integer_format($count),
        ));
    }
}
