<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    staff
 */

/**
 * Module page class.
 */
class Module_staff
{
    /**
     * Find details of the module.
     *
     * @return ?array Map of module info (null: module is disabled).
     */
    public function info()
    {
        $info = array();
        $info['author'] = 'Chris Graham';
        $info['organisation'] = 'ocProducts';
        $info['hacked_by'] = null;
        $info['hack_version'] = null;
        $info['version'] = 2;
        $info['locked'] = false;
        return $info;
    }

    /**
     * Find entry-points available within this module.
     *
     * @param  boolean $check_perms Whether to check permissions.
     * @param  ?MEMBER $member_id The member to check permissions as (null: current user).
     * @param  boolean $support_crosslinks Whether to allow cross links to other modules (identifiable via a full-page-link rather than a screen-name).
     * @param  boolean $be_deferential Whether to avoid any entry-point (or even return null to disable the page in the Sitemap) if we know another module, or page_group, is going to link to that entry-point. Note that "!" and "browse" entry points are automatically merged with container page nodes (likely called by page-groupings) as appropriate.
     * @return ?array A map of entry points (screen-name=>language-code/string or screen-name=>[language-code/string, icon-theme-image]) (null: disabled).
     */
    public function get_entry_points($check_perms = true, $member_id = null, $support_crosslinks = true, $be_deferential = false)
    {
        return array(
            'browse' => array('STAFF', 'menu/site_meta/staff'),
        );
    }

    /**
     * Uninstall the module.
     */
    public function uninstall()
    {
        $GLOBALS['FORUM_DRIVER']->install_delete_custom_field('sites');
        $GLOBALS['FORUM_DRIVER']->install_delete_custom_field('role');
    }

    /**
     * Install the module.
     *
     * @param  ?integer $upgrade_from What version we're upgrading from (null: new install)
     * @param  ?integer $upgrade_from_hack What hack version we're upgrading from (null: new-install/not-upgrading-from-a-hacked-version)
     */
    public function install($upgrade_from = null, $upgrade_from_hack = null)
    {
        $GLOBALS['FORUM_DRIVER']->install_create_custom_field('sites', 255, /*locked=*/1, /*viewable=*/0, /*settable=*/0, /*required=*/0, '', 'short_text');
        $GLOBALS['FORUM_DRIVER']->install_create_custom_field('role', 100, /*locked=*/0, /*viewable=*/0, /*settable=*/1, /*required=*/0, '', 'short_text');
    }

    public $title;

    /**
     * Module pre-run function. Allows us to know metadata for <head> before we start streaming output.
     *
     * @return ?Tempcode Tempcode indicating some kind of exceptional output (null: none).
     */
    public function pre_run()
    {
        $type = get_param_string('type', 'browse');

        require_lang('staff');

        if ($type == 'browse') {
            $this->title = get_screen_title('STAFF_TITLE', true, array(escape_html(get_site_name())));
        }

        if ($type == 'view') {
            breadcrumb_set_parents(array(array('_SELF:_SELF:browse', do_lang_tempcode('STAFF_TITLE', escape_html(get_site_name())))));

            $username = get_param_string('id');
            $this->title = get_screen_title('_STAFF', true, array(escape_html($username)));
        }

        return null;
    }

    /**
     * Execute the module.
     *
     * @return Tempcode The result of execution.
     */
    public function run()
    {
        $type = get_param_string('type', 'browse');

        if ($type == 'browse') {
            return $this->do_all_staff();
        }
        if ($type == 'view') {
            return $this->do_staff_member();
        }

        return new Tempcode();
    }

    /**
     * The UI to view a staff list.
     *
     * @return Tempcode The UI
     */
    public function do_all_staff()
    {
        $admin_groups = array_merge($GLOBALS['FORUM_DRIVER']->get_super_admin_groups(), $GLOBALS['FORUM_DRIVER']->get_moderator_groups());
        $rows = $GLOBALS['FORUM_DRIVER']->member_group_query($admin_groups, intval(get_option('general_safety_listing_limit')));
        if (count($rows) >= intval(get_option('general_safety_listing_limit'))) {
            warn_exit(do_lang_tempcode('TOO_MANY_TO_CHOOSE_FROM'));
        }

        $pre = do_lang_tempcode('PRE_STAFF');

        foreach ($rows as $i => $row_staff) {
            $username = $GLOBALS['FORUM_DRIVER']->mrow_username($row_staff);
            $rows[$i]['username'] = $username;
        }

        sort_maps_by($rows, 'username');

        $content = new Tempcode();
        foreach ($rows as $row_staff) {
            $id = $GLOBALS['FORUM_DRIVER']->mrow_id($row_staff);

            if (!$GLOBALS['FORUM_DRIVER']->is_staff($id)) {
                continue;
            }

            $username = $row_staff['username'];
            $url = build_url(array('page' => '_SELF', 'type' => 'view', 'id' => $username), '_SELF');
            $role = escape_html(get_cms_cpf('role', $id));
            if (is_null($role)) {
                $description = ''; // Null should not happen, but sometimes things corrupt
            } else {
                require_code('comcode_compiler');
                $description = apply_emoticons($role);
            }

            $content->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => '2650660652a01ce39e6085615436f370', 'TITLE' => do_lang_tempcode('STAFF'), 'URL' => $url, 'NAME' => $username, 'DESCRIPTION' => $description)));
        }

        $message = get_option('staff_text');
        if (has_actual_page_access(get_member(), 'admin_config')) {
            if ($message != '') {
                $message .= ' [semihtml]<span class="associated_link"><a href="{$PAGE_LINK*,_SEARCH:admin_config:category:SECURITY#group_STAFF}">' . do_lang('EDIT') . '</a></span>[/semihtml]'; // XHTMLXHTML: This (and similar things in other modules) should be done through a template really
            }
        }
        $post = comcode_to_tempcode($message, null, true);

        return do_template('INDEX_SCREEN_FANCIER_SCREEN', array('_GUID' => '3fb63955b3e1cb1cb4fda2e56b428d08', 'CONTENT' => $content, 'TITLE' => $this->title, 'POST' => $post, 'PRE' => $pre));
    }

    /**
     * The UI to view a staff member.
     *
     * @return Tempcode The UI
     */
    public function do_staff_member()
    {
        $username = get_param_string('id');

        require_code('obfuscate');

        $row_staff = $GLOBALS['FORUM_DRIVER']->get_mrow($username);
        if (is_null($row_staff)) {
            warn_exit(do_lang_tempcode('MISSING_RESOURCE'));
        }
        $id = $GLOBALS['FORUM_DRIVER']->mrow_id($row_staff);

        $_real_name = trim(get_cms_cpf('firstname', $id) . ' ' . get_cms_cpf('lastname', $id));
        if ($_real_name == '') {
            $real_name = do_lang_tempcode('_UNKNOWN'); // Null should not happen, but sometimes things corrupt
        } else {
            $real_name = protect_from_escaping(escape_html($_real_name));
        }
        $_role = get_cms_cpf('role', $id);
        if ($_role == '') {
            $role = do_lang_tempcode('_UNKNOWN'); // Null should not happen, but sometimes things corrupt
        } else {
            require_code('comcode_compiler');
            $role = make_string_tempcode(apply_emoticons($_role));
        }
        $email_address = obfuscate_email_address($GLOBALS['FORUM_DRIVER']->mrow_email($row_staff));
        $username = $GLOBALS['FORUM_DRIVER']->mrow_username($row_staff);
        $profile_url = $GLOBALS['FORUM_DRIVER']->member_profile_url($id, false, true);

        $all_link = build_url(array('page' => '_SELF', 'type' => 'browse'), '_SELF');

        return do_template('STAFF_SCREEN', array('_GUID' => 'fd149466f16722fcbcef0fba5685a895', 'TITLE' => $this->title, 'REAL_NAME' => $real_name, 'ROLE' => $role, 'ADDRESS' => $email_address, 'USERNAME' => $username, 'MEMBER_ID' => strval($id), 'PROFILE_URL' => $profile_url, 'ALL_STAFF_URL' => $all_link));
    }
}
