<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    ssl
 */

/**
 * Module page class.
 */
class Module_admin_ssl
{
    /**
     * Find details of the module.
     *
     * @return ?array Map of module info (null: module is disabled).
     */
    public function info()
    {
        $info = array();
        $info['author'] = 'Chris Graham';
        $info['organisation'] = 'ocProducts';
        $info['hacked_by'] = null;
        $info['hack_version'] = null;
        $info['version'] = 2;
        $info['locked'] = false;
        return $info;
    }

    /**
     * Find entry-points available within this module.
     *
     * @param  boolean $check_perms Whether to check permissions.
     * @param  ?MEMBER $member_id The member to check permissions as (null: current user).
     * @param  boolean $support_crosslinks Whether to allow cross links to other modules (identifiable via a full-page-link rather than a screen-name).
     * @param  boolean $be_deferential Whether to avoid any entry-point (or even return null to disable the page in the Sitemap) if we know another module, or page_group, is going to link to that entry-point. Note that "!" and "browse" entry points are automatically merged with container page nodes (likely called by page-groupings) as appropriate.
     * @return ?array A map of entry points (screen-name=>language-code/string or screen-name=>[language-code/string, icon-theme-image]) (null: disabled).
     */
    public function get_entry_points($check_perms = true, $member_id = null, $support_crosslinks = true, $be_deferential = false)
    {
        return array(
            'browse' => array('SSL_CONFIGURATION', 'menu/adminzone/security/ssl'),
        );
    }

    public $title;

    /**
     * Module pre-run function. Allows us to know metadata for <head> before we start streaming output.
     *
     * @return ?Tempcode Tempcode indicating some kind of exceptional output (null: none).
     */
    public function pre_run()
    {
        $type = get_param_string('type', 'browse');

        require_lang('ssl');

        set_helper_panel_tutorial('tut_security');

        $this->title = get_screen_title('SSL_CONFIGURATION');

        return null;
    }

    /**
     * Execute the module.
     *
     * @return Tempcode The result of execution.
     */
    public function run()
    {
        if (!is_null($GLOBALS['CURRENT_SHARE_USER'])) {
            warn_exit(do_lang_tempcode('SHARED_INSTALL_PROHIBIT'));
        }

        $type = get_param_string('type', 'browse');

        if ($type == 'set') {
            return $this->set();
        }
        if ($type == 'browse') {
            return $this->ssl_interface();
        }

        return new Tempcode();
    }

    /**
     * The UI for selecting HTTPS pages.
     *
     * @return Tempcode The UI
     */
    public function ssl_interface()
    {
        $entries = array();
        $zones = find_all_zones();
        foreach ($zones as $zone) {
            $pages = find_all_pages_wrap($zone);
            $pk = array_keys($pages);
            @sort($pk); // @'d for inconsistency (some integer keys like 404) (annoying PHP quirk)
            foreach ($pk as $page) {
                if (!is_string($page)) {
                    $page = strval($page); // strval($page) as $page could have become numeric due to array imprecision
                }
                $ticked = is_page_https($zone, $page);
                $entries[] = array('TICKED' => $ticked, 'PAGE' => $page, 'ZONE' => $zone);
            }
        }

        $url = build_url(array('page' => '_SELF', 'type' => 'set'), '_SELF');
        return do_template('SSL_CONFIGURATION_SCREEN', array('_GUID' => '823f395205f0c018861847e80c622710', 'TITLE' => $this->title, 'URL' => $url, 'ENTRIES' => $entries));
    }

    /**
     * The actualiser for selecting HTTPS pages.
     *
     * @return Tempcode The UI
     */
    public function set()
    {
        $zones = find_all_zones();
        foreach ($zones as $zone) {
            $pages = find_all_pages_wrap($zone);
            foreach (array_keys($pages) as $page) {
                if (!is_string($page)) {
                    $page = strval($page); // strval($page) as $page could have become numeric due to array imprecision
                }
                $id = $zone . ':' . $page;
                $value = post_param_integer('ssl_' . $zone . '__' . $page, 0);
                $GLOBALS['SITE_DB']->query_delete('https_pages', array('https_page_name' => $id), '', 1);
                if ($value == 1) {
                    $GLOBALS['SITE_DB']->query_insert('https_pages', array('https_page_name' => $id));
                }
            }
        }

        erase_persistent_cache();

        log_it('SSL_CONFIGURATION');

        // Show it worked / Refresh
        $url = build_url(array('page' => '_SELF', 'type' => 'browse'), '_SELF');
        return redirect_screen($this->title, $url, do_lang_tempcode('SUCCESS'));
    }
}
