<?php

/**
 * @module          Reset PIN
 * @author          cms-lab
 * @copyright       2010-2025 cms-lab
 * @link            https://cms-lab.com
 * @license         custom license: https://cms-lab.com/_documentation/reset-pin/license.php
 * @license_terms   please see license
 *
 */

// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {	
	include LEPTON_PATH.SEC_FILE;
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.SEC_FILE))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.SEC_FILE)) { 
		include $root.SEC_FILE;  
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include secure file

// get instance of functions file
$oRP = reset_pin::getInstance();

if(!isset ($_GET['tool'])) 
{
	die('[1]');
}

if(isset ($_GET['tool']) && (empty($_POST)) ) 
{
	$oRP->display_reset();
}

if(isset ($_POST['reset_displayname']) ) 
{
	$oRP->save_value($_POST['displayname']);
}

if(isset ($_POST['reset_username']) ) 
{
	$oRP->save_value($_POST['username']);
}

if(isset ($_POST['show_info']) ) 
{
	$oRP->show_info();
}
